<?php
/* http://www.sundesignworkshop.com */

////
// Get the installed version number
  function tep_get_version() {
    static $v;

    if (!isset($v)) {
      $v = trim(implode('', file(DIR_FS_CATALOG . 'includes/version.php')));
    }

    return $v;
  }

////
// Redirect to another page or site
  function tep_redirect($url) {
    global $logger;

    if ( (strstr($url, "\n") != false) || (strstr($url, "\r") != false) ) {
     // tep_redirect(tep_href_link(FILENAME_DEFAULT, '', 'NONSSL', false));
	 tep_redirect(tep_href_link(FILENAME_DEFAULT, '', 'SSL', false));
    }

 header('Location: ' . $url);

    /*if (STORE_PAGE_PARSE_TIME == 'true') {
      if (!is_object($logger)) $logger = new logger;
      $logger->timer_stop();
    }
*/
    exit;
  }

////
// Parse the data used in the html tags to ensure the tags will not break
  function tep_parse_input_field_data($data, $parse) {
    return strtr(trim($data), $parse);
  }

  function tep_output_string($string, $translate = false, $protected = false) {
    if ($protected == true) {
      return htmlspecialchars($string);
    } else {
      if ($translate == false) {
        return tep_parse_input_field_data($string, array('"' => '&quot;'));
      } else {
        return tep_parse_input_field_data($string, $translate);
      }
    }
  }

  function tep_output_string_protected($string) {
    return tep_output_string($string, false, true);
  }

  function tep_sanitize_string($string) {
    $patterns = array ('/ +/','/[<>]/');
    $replace = array (' ', '_');
    return preg_replace($patterns, $replace, trim($string));
  }

  function tep_customers_name($customers_id) {
    $customers = tep_db_query("select customers_firstname, customers_lastname from " . TABLE_CUSTOMERS . " where customers_id = '" . (int)$customers_id . "'");
    $customers_values = tep_db_fetch_array($customers);

    return $customers_values['customers_firstname'] . ' ' . $customers_values['customers_lastname'];
  }

  function tep_get_path($current_category_id = '') {
    global $cPath_array;

    if ($current_category_id == '') {
      $cPath_new = implode('_', $cPath_array);
    } else {
      if (sizeof($cPath_array) == 0) {
        $cPath_new = $current_category_id;
      } else {
        $cPath_new = '';
        $last_category_query = tep_db_query("select parent_id from " . TABLE_CATEGORIES . " where categories_id = '" . (int)$cPath_array[(sizeof($cPath_array)-1)] . "'");
        $last_category = tep_db_fetch_array($last_category_query);

        $current_category_query = tep_db_query("select parent_id from " . TABLE_CATEGORIES . " where categories_id = '" . (int)$current_category_id . "'");
        $current_category = tep_db_fetch_array($current_category_query);

        if ($last_category['parent_id'] == $current_category['parent_id']) {
          for ($i = 0, $n = sizeof($cPath_array) - 1; $i < $n; $i++) {
            $cPath_new .= '_' . $cPath_array[$i];
          }
        } else {
          for ($i = 0, $n = sizeof($cPath_array); $i < $n; $i++) {
            $cPath_new .= '_' . $cPath_array[$i];
          }
        }

        $cPath_new .= '_' . $current_category_id;

        if (substr($cPath_new, 0, 1) == '_') {
          $cPath_new = substr($cPath_new, 1);
        }
      }
    }

    return 'cPath=' . $cPath_new;
  }

  function tep_get_all_get_params($exclude_array = '') {
    global $HTTP_GET_VARS;

    if ($exclude_array == '') $exclude_array = array();

    $get_url = '';

    reset($HTTP_GET_VARS);
    foreach ($_GET as $key => $value) {
      if (($key != tep_session_name()) && ($key != 'error') && (!in_array($key, $exclude_array))) $get_url .= $key . '=' . $value . '&';
    }

    return $get_url;
  }

  function tep_date_long($raw_date) {
    if ( ($raw_date == '0000-00-00 00:00:00') || ($raw_date == '') ) return false;

    $year = (int)substr($raw_date, 0, 4);
    $month = (int)substr($raw_date, 5, 2);
    $day = (int)substr($raw_date, 8, 2);
    $hour = (int)substr($raw_date, 11, 2);
    $minute = (int)substr($raw_date, 14, 2);
    $second = (int)substr($raw_date, 17, 2);

    return strftime(DATE_FORMAT_LONG, mktime($hour, $minute, $second, $month, $day, $year));
  }

////
// Output a raw date string in the selected locale date format
// $raw_date needs to be in this format: YYYY-MM-DD HH:MM:SS
// NOTE: Includes a workaround for dates before 01/01/1970 that fail on windows servers
  function tep_date_short($raw_date) {
    if ( ($raw_date == '0000-00-00 00:00:00') || ($raw_date == '') ) return false;

    $year = substr($raw_date, 0, 4);
    $month = (int)substr($raw_date, 5, 2);
    $day = (int)substr($raw_date, 8, 2);
    $hour = (int)substr($raw_date, 11, 2);
    $minute = (int)substr($raw_date, 14, 2);
    $second = (int)substr($raw_date, 17, 2);

    if (@date('Y', mktime($hour, $minute, $second, $month, $day, $year)) == $year) {
      return date(DATE_FORMAT, mktime($hour, $minute, $second, $month, $day, $year));
    } else {
      return preg_replace('/2037$/', $year, date(DATE_FORMAT, mktime($hour, $minute, $second, $month, $day, 2037)));
    }

  }

  function tep_datetime_short($raw_datetime) {
    if ( ($raw_datetime == '0000-00-00 00:00:00') || ($raw_datetime == '') ) return false;

    $year = (int)substr($raw_datetime, 0, 4);
    $month = (int)substr($raw_datetime, 5, 2);
    $day = (int)substr($raw_datetime, 8, 2);
    $hour = (int)substr($raw_datetime, 11, 2);
    $minute = (int)substr($raw_datetime, 14, 2);
    $second = (int)substr($raw_datetime, 17, 2);

    return strftime(DATE_TIME_FORMAT, mktime($hour, $minute, $second, $month, $day, $year));
  }

  function tep_get_category_tree($parent_id = '0', $spacing = '', $exclude = '', $category_tree_array = '', $include_itself = false) {
    global $languages_id;

    if (!is_array($category_tree_array)) $category_tree_array = array();
    if ( (sizeof($category_tree_array) < 1) && ($exclude != '0') ) $category_tree_array[] = array('id' => '0', 'text' => TEXT_TOP);

    if ($include_itself) {
      $category_query = tep_db_query("select cd.categories_name from " . TABLE_CATEGORIES_DESCRIPTION . " cd where cd.language_id = '" . (int)$languages_id . "' and cd.categories_id = '" . (int)$parent_id . "'");
      $category = tep_db_fetch_array($category_query);
      $category_tree_array[] = array('id' => $parent_id, 'text' => $category['categories_name']);
    }

    $categories_query = tep_db_query("select c.categories_id, cd.categories_name, c.parent_id from " . TABLE_CATEGORIES . " c, " . TABLE_CATEGORIES_DESCRIPTION . " cd where c.categories_id = cd.categories_id and cd.language_id = '" . (int)$languages_id . "' and c.parent_id = '" . (int)$parent_id . "' order by c.sort_order, cd.categories_name");
    while ($categories = tep_db_fetch_array($categories_query)) {
      if ($exclude != $categories['categories_id']) $category_tree_array[] = array('id' => $categories['categories_id'], 'text' => $spacing . $categories['categories_name']);
      $category_tree_array = tep_get_category_tree($categories['categories_id'], $spacing . '&nbsp;&nbsp;&nbsp;', $exclude, $category_tree_array);
    }

    return $category_tree_array;
  }

  function tep_draw_products_pull_down($name, $parameters = '', $exclude = '') {
    global $currencies, $languages_id;

    if ($exclude == '') {
      $exclude = array();
    }

    $select_string = '<select name="' . $name . '"';

    if ($parameters) {
      $select_string .= ' ' . $parameters;
    }

    $select_string .= '>';

    $products_query = tep_db_query("select p.products_id, pd.products_name, p.products_price from " . TABLE_PRODUCTS . " p, " . TABLE_PRODUCTS_DESCRIPTION . " pd where p.products_id = pd.products_id and pd.language_id = '" . (int)$languages_id . "' order by products_name");
    while ($products = tep_db_fetch_array($products_query)) {
      if (!in_array($products['products_id'], $exclude)) {
        $select_string .= '<option value="' . $products['products_id'] . '">' . $products['products_name'] . ' (' . $currencies->format($products['products_price']) . ')</option>';
      }
    }

    $select_string .= '</select>';

    return $select_string;
  }

  function tep_format_system_info_array($array) {

    $output = '';
    foreach ($array as $section => $child) {
      $output .= '[' . $section . ']' . "\n";
      foreach ($child as $variable => $value) {
        if (is_array($value)) {
          $output .= $variable . ' = ' . implode(',', $value) ."\n";
        } else {
          $output .= $variable . ' = ' . $value . "\n";
        }
      }

    $output .= "\n";
    }
    return $output;

  }



  function tep_options_name($options_id) {
    global $languages_id;

    $options = tep_db_query("select products_options_name from " . TABLE_PRODUCTS_OPTIONS . " where products_options_id = '" . (int)$options_id . "' and language_id = '" . (int)$languages_id . "'");
    $options_values = tep_db_fetch_array($options);

    return $options_values['products_options_name'];
  }

  function tep_values_name($values_id) {
    global $languages_id;

    $values = tep_db_query("select products_options_values_name from " . TABLE_PRODUCTS_OPTIONS_VALUES . " where products_options_values_id = '" . (int)$values_id . "' and language_id = '" . (int)$languages_id . "'");
    $values_values = tep_db_fetch_array($values);

    return $values_values['products_options_values_name'];
  }

  function tep_info_image($image, $alt, $width = '', $height = '') {
    if (tep_not_null($image) && (file_exists(DIR_FS_CATALOG_IMAGES . $image)) ) {
      $image = tep_image(DIR_WS_CATALOG_IMAGES . $image, $alt, $width, $height);
    } else {
      $image = TEXT_IMAGE_NONEXISTENT;
    }

    return $image;
  }

  function tep_break_string($string, $len, $break_char = '-') {
    $l = 0;
    $output = '';
    for ($i=0, $n=strlen($string); $i<$n; $i++) {
      $char = substr($string, $i, 1);
      if ($char != ' ') {
        $l++;
      } else {
        $l = 0;
      }
      if ($l > $len) {
        $l = 1;
        $output .= $break_char;
      }
      $output .= $char;
    }

    return $output;
  }

  function tep_get_country_name($country_id) {
    $country_query = tep_db_query("select countries_name from " . TABLE_COUNTRIES . " where countries_id = '" . (int)$country_id . "'");

    if (!tep_db_num_rows($country_query)) {
      return $country_id;
    } else {
      $country = tep_db_fetch_array($country_query);
      return $country['countries_name'];
    }
  }

  function tep_get_zone_name($country_id, $zone_id, $default_zone) {
    $zone_query = tep_db_query("select zone_name from " . TABLE_ZONES . " where zone_country_id = '" . (int)$country_id . "' and zone_id = '" . (int)$zone_id . "'");
    if (tep_db_num_rows($zone_query)) {
      $zone = tep_db_fetch_array($zone_query);
      return $zone['zone_name'];
    } else {
      return $default_zone;
    }
  }

  function tep_not_null($value) {
    if (is_array($value)) {
      if (sizeof($value) > 0) {
        return true;
      } else {
        return false;
      }
    } else {
      if ( (is_string($value) || is_int($value)) && ($value != '') && ($value != 'NULL') && (strlen(trim($value)) > 0)) {
        return true;
      } else {
        return false;
      }
    }
  }

  function tep_browser_detect($component) {
    global $HTTP_USER_AGENT;

    return stristr($HTTP_USER_AGENT, $component);
  }

  function tep_tax_classes_pull_down($parameters, $selected = '') {
    $select_string = '<select ' . $parameters . '>';
    $classes_query = tep_db_query("select tax_class_id, tax_class_title from " . TABLE_TAX_CLASS . " order by tax_class_title");
    while ($classes = tep_db_fetch_array($classes_query)) {
      $select_string .= '<option value="' . $classes['tax_class_id'] . '"';
      if ($selected == $classes['tax_class_id']) $select_string .= ' SELECTED';
      $select_string .= '>' . $classes['tax_class_title'] . '</option>';
    }
    $select_string .= '</select>';

    return $select_string;
  }

  function tep_geo_zones_pull_down($parameters, $selected = '') {
    $select_string = '<select ' . $parameters . '>';
    $zones_query = tep_db_query("select geo_zone_id, geo_zone_name from " . TABLE_GEO_ZONES . " order by geo_zone_name");
    while ($zones = tep_db_fetch_array($zones_query)) {
      $select_string .= '<option value="' . $zones['geo_zone_id'] . '"';
      if ($selected == $zones['geo_zone_id']) $select_string .= ' SELECTED';
      $select_string .= '>' . $zones['geo_zone_name'] . '</option>';
    }
    $select_string .= '</select>';

    return $select_string;
  }

  function tep_get_geo_zone_name($geo_zone_id) {
    $zones_query = tep_db_query("select geo_zone_name from " . TABLE_GEO_ZONES . " where geo_zone_id = '" . (int)$geo_zone_id . "'");

    if (!tep_db_num_rows($zones_query)) {
      $geo_zone_name = $geo_zone_id;
    } else {
      $zones = tep_db_fetch_array($zones_query);
      $geo_zone_name = $zones['geo_zone_name'];
    }

    return $geo_zone_name;
  }

  function tep_address_format($address_format_id, $address, $html, $boln, $eoln) {
    $address_format_query = tep_db_query("select address_format as format from " . TABLE_ADDRESS_FORMAT . " where address_format_id = '" . (int)$address_format_id . "'");
    $address_format = tep_db_fetch_array($address_format_query);

    $company = tep_output_string_protected($address['company']);
    if (isset($address['firstname']) && tep_not_null($address['firstname'])) {
      $firstname = tep_output_string_protected($address['firstname']);
      $lastname = tep_output_string_protected($address['lastname']);
    } elseif (isset($address['name']) && tep_not_null($address['name'])) {
      $firstname = tep_output_string_protected($address['name']);
      $lastname = '';
    } else {
      $firstname = '';
      $lastname = '';
    }
    $street = tep_output_string_protected($address['street_address']);
    $suburb = tep_output_string_protected($address['suburb']);
    $city = tep_output_string_protected($address['city']);
    $state = tep_output_string_protected($address['state']);
    if (isset($address['country_id']) && tep_not_null($address['country_id'])) {
      $country = tep_get_country_name($address['country_id']);

      if (isset($address['zone_id']) && tep_not_null($address['zone_id'])) {
        $state = tep_get_zone_code($address['country_id'], $address['zone_id'], $state);
      }
    } elseif (isset($address['country']) && tep_not_null($address['country'])) {
      $country = tep_output_string_protected($address['country']);
    } else {
      $country = '';
    }
    $postcode = tep_output_string_protected($address['postcode']);
    $zip = $postcode;

    if ($html) {
// HTML Mode
      $HR = '<hr />';
      $hr = '<hr />';
      if ( ($boln == '') && ($eoln == "\n") ) { // Values not specified, use rational defaults
        $CR = '<br />';
        $cr = '<br />';
        $eoln = $cr;
      } else { // Use values supplied
        $CR = $eoln . $boln;
        $cr = $CR;
      }
    } else {
// Text Mode
      $CR = $eoln;
      $cr = $CR;
      $HR = '----------------------------------------';
      $hr = '----------------------------------------';
    }

    $statecomma = '';
    $streets = $street;
    if ($suburb != '') $streets = $street . $cr . $suburb;
    if ($country == '') $country = tep_output_string_protected($address['country']);
    if ($state != '') $statecomma = $state . ', ';

    $fmt = $address_format['format'];
    eval("\$address = \"$fmt\";");

    if ( (ACCOUNT_COMPANY == 'true') && (tep_not_null($company)) ) {
      $address = $company . $cr . $address;
    }

    return $address;
  }

  ////////////////////////////////////////////////////////////////////////////////////////////////
  //
  // Function    : tep_get_zone_code
  //
  // Arguments   : country           country code string
  //               zone              state/province zone_id
  //               def_state         default string if zone==0
  //
  // Return      : state_prov_code   state/province code
  //
  // Description : Function to retrieve the state/province code (as in FL for Florida etc)
  //
  ////////////////////////////////////////////////////////////////////////////////////////////////
  function tep_get_zone_code($country, $zone, $def_state) {

    $state_prov_query = tep_db_query("select zone_code from " . TABLE_ZONES . " where zone_country_id = '" . (int)$country . "' and zone_id = '" . (int)$zone . "'");

    if (!tep_db_num_rows($state_prov_query)) {
      $state_prov_code = $def_state;
    }
    else {
      $state_prov_values = tep_db_fetch_array($state_prov_query);
      $state_prov_code = $state_prov_values['zone_code'];
    }
    
    return $state_prov_code;
  }

  function tep_get_uprid($prid, $params) {
    $uprid = $prid;
    if ( (is_array($params)) && (!strstr($prid, '{')) ) {
      foreach ($params as $option => $value) {
        $uprid = $uprid . '{' . $option . '}' . $value;
      }
    }

    return $uprid;
  }

  function tep_get_prid($uprid) {
    $pieces = explode('{', $uprid);

    return $pieces[0];
  }

  function tep_get_languages() {
    $languages_query = tep_db_query("select languages_id, name, code, image, directory from " . TABLE_LANGUAGES . " order by sort_order");
    while ($languages = tep_db_fetch_array($languages_query)) {
      $languages_array[] = array('id' => $languages['languages_id'],
                                 'name' => $languages['name'],
                                 'code' => $languages['code'],
                                 'image' => $languages['image'],
                                 'directory' => $languages['directory']);
    }

    return $languages_array;
  }

  function tep_get_category_name($category_id, $language_id) {
    $category_query = tep_db_query("select categories_name from " . TABLE_CATEGORIES_DESCRIPTION . " where categories_id = '" . (int)$category_id . "' and language_id = '" . (int)$language_id . "'");
    $category = tep_db_fetch_array($category_query);

    return $category['categories_name'];
  }

  function tep_get_orders_status_name($orders_status_id, $language_id = '') {
    global $languages_id;

    if (!$language_id) $language_id = $languages_id;
    $orders_status_query = tep_db_query("select orders_status_name from " . TABLE_ORDERS_STATUS . " where orders_status_id = '" . (int)$orders_status_id . "' and language_id = '" . (int)$language_id . "'");
    $orders_status = tep_db_fetch_array($orders_status_query);

    return $orders_status['orders_status_name'];
  }

  function tep_get_orders_status() {
    global $languages_id;

    $orders_status_array = array();
    $orders_status_query = tep_db_query("select orders_status_id, orders_status_name from " . TABLE_ORDERS_STATUS . " where language_id = '" . (int)$languages_id . "' order by orders_status_id");
    while ($orders_status = tep_db_fetch_array($orders_status_query)) {
      $orders_status_array[] = array('id' => $orders_status['orders_status_id'],
                                     'text' => $orders_status['orders_status_name']);
    }

    return $orders_status_array;
  }

  function tep_get_products_name($product_id, $language_id = 0) {
    global $languages_id;

    if ($language_id == 0) $language_id = $languages_id;
    $product_query = tep_db_query("select products_name from " . TABLE_PRODUCTS_DESCRIPTION . " where products_id = '" . (int)$product_id . "' and language_id = '" . (int)$language_id . "'");
    $product = tep_db_fetch_array($product_query);

    return $product['products_name'];
  }

  function tep_get_products_description($product_id, $language_id) {
    $product_query = tep_db_query("select products_description from " . TABLE_PRODUCTS_DESCRIPTION . " where products_id = '" . (int)$product_id . "' and language_id = '" . (int)$language_id . "'");
    $product = tep_db_fetch_array($product_query);

    return $product['products_description'];
  }

  function tep_get_products_url($product_id, $language_id) {
    $product_query = tep_db_query("select products_url from " . TABLE_PRODUCTS_DESCRIPTION . " where products_id = '" . (int)$product_id . "' and language_id = '" . (int)$language_id . "'");
    $product = tep_db_fetch_array($product_query);

    return $product['products_url'];
  }

////
// Return the manufacturers URL in the needed language
// TABLES: manufacturers_info
  function tep_get_manufacturer_url($manufacturer_id, $language_id) {
    $manufacturer_query = tep_db_query("select manufacturers_url from " . TABLE_MANUFACTURERS_INFO . " where manufacturers_id = '" . (int)$manufacturer_id . "' and languages_id = '" . (int)$language_id . "'");
    $manufacturer = tep_db_fetch_array($manufacturer_query);

    return $manufacturer['manufacturers_url'];
  }

////
// Wrapper for class_exists() function
// This function is not available in all PHP versions so we test it before using it.
  function tep_class_exists($class_name) {
    if (function_exists('class_exists')) {
      return class_exists($class_name);
    } else {
      return true;
    }
  }

////
// Count how many products exist in a category
// TABLES: products, products_to_categories, categories
  function tep_products_in_category_count($categories_id, $include_deactivated = false) {
    $products_count = 0;

    if ($include_deactivated) {
      $products_query = tep_db_query("select count(*) as total from " . TABLE_PRODUCTS . " p, " . TABLE_PRODUCTS_TO_CATEGORIES . " p2c where p.products_id = p2c.products_id and p2c.categories_id = '" . (int)$categories_id . "'");
    } else {
      $products_query = tep_db_query("select count(*) as total from " . TABLE_PRODUCTS . " p, " . TABLE_PRODUCTS_TO_CATEGORIES . " p2c where p.products_id = p2c.products_id and p.products_status = '1' and p2c.categories_id = '" . (int)$categories_id . "'");
    }

    $products = tep_db_fetch_array($products_query);

    $products_count += $products['total'];

    $childs_query = tep_db_query("select categories_id from " . TABLE_CATEGORIES . " where parent_id = '" . (int)$categories_id . "'");
    if (tep_db_num_rows($childs_query)) {
      while ($childs = tep_db_fetch_array($childs_query)) {
        $products_count += tep_products_in_category_count($childs['categories_id'], $include_deactivated);
      }
    }

    return $products_count;
  }

////
// Count how many subcategories exist in a category
// TABLES: categories
  function tep_childs_in_category_count($categories_id) {
    $categories_count = 0;

    $categories_query = tep_db_query("select categories_id from " . TABLE_CATEGORIES . " where parent_id = '" . (int)$categories_id . "'");
    while ($categories = tep_db_fetch_array($categories_query)) {
      $categories_count++;
      $categories_count += tep_childs_in_category_count($categories['categories_id']);
    }

    return $categories_count;
  }

////
// Returns an array with countries
// TABLES: countries
  function tep_get_countries($default = '') {
    $countries_array = array();
    if ($default) {
      $countries_array[] = array('id' => '',
                                 'text' => $default);
    }
    $countries_query = tep_db_query("select countries_id, countries_name from " . TABLE_COUNTRIES . " order by countries_name");
    while ($countries = tep_db_fetch_array($countries_query)) {
      $countries_array[] = array('id' => $countries['countries_id'],
                                 'text' => $countries['countries_name']);
    }

    return $countries_array;
  }

////
// return an array with country zones
  function tep_get_country_zones($country_id) {
    $zones_array = array();
    $zones_query = tep_db_query("select zone_id, zone_name from " . TABLE_ZONES . " where zone_country_id = '" . (int)$country_id . "' order by zone_name");
    while ($zones = tep_db_fetch_array($zones_query)) {
      $zones_array[] = array('id' => $zones['zone_id'],
                             'text' => $zones['zone_name']);
    }

    return $zones_array;
  }

  function tep_prepare_country_zones_pull_down($country_id = '') {
// preset the width of the drop-down for Netscape
    $pre = '';
    if ( (!tep_browser_detect('MSIE')) && (tep_browser_detect('Mozilla/4')) ) {
      for ($i=0; $i<45; $i++) $pre .= '&nbsp;';
    }

    $zones = tep_get_country_zones($country_id);

    if (sizeof($zones) > 0) {
      $zones_select = array(array('id' => '', 'text' => PLEASE_SELECT));
      $zones = array_merge($zones_select, $zones);
    } else {
      $zones = array(array('id' => '', 'text' => TYPE_BELOW));
// create dummy options for Netscape to preset the height of the drop-down
      if ( (!tep_browser_detect('MSIE')) && (tep_browser_detect('Mozilla/4')) ) {
        for ($i=0; $i<9; $i++) {
          $zones[] = array('id' => '', 'text' => $pre);
        }
      }
    }

    return $zones;
  }

////
// Get list of address_format_id's
  function tep_get_address_formats() {
    $address_format_query = tep_db_query("select address_format_id from " . TABLE_ADDRESS_FORMAT . " order by address_format_id");
    $address_format_array = array();
    while ($address_format_values = tep_db_fetch_array($address_format_query)) {
      $address_format_array[] = array('id' => $address_format_values['address_format_id'],
                                      'text' => $address_format_values['address_format_id']);
    }
    return $address_format_array;
  }

////
// Alias function for Store configuration values in the Administration Tool
  function tep_cfg_pull_down_country_list($country_id) {
    return tep_draw_pull_down_menu('configuration_value', tep_get_countries(), $country_id);
  }

  function tep_cfg_pull_down_zone_list($zone_id) {
    return tep_draw_pull_down_menu('configuration_value', tep_get_country_zones(STORE_COUNTRY), $zone_id);
  }

  function tep_cfg_pull_down_tax_classes($tax_class_id, $key = '') {
    $name = (($key) ? 'configuration[' . $key . ']' : 'configuration_value');

    $tax_class_array = array(array('id' => '0', 'text' => TEXT_NONE));
    $tax_class_query = tep_db_query("select tax_class_id, tax_class_title from " . TABLE_TAX_CLASS . " order by tax_class_title");
    while ($tax_class = tep_db_fetch_array($tax_class_query)) {
      $tax_class_array[] = array('id' => $tax_class['tax_class_id'],
                                 'text' => $tax_class['tax_class_title']);
    }

    return tep_draw_pull_down_menu($name, $tax_class_array, $tax_class_id);
  }

////
// Function to read in text area in admin
 function tep_cfg_textarea($text) {
    return tep_draw_textarea_field('configuration_value', false, 35, 5, $text);
  }

  function tep_cfg_get_zone_name($zone_id) {
    $zone_query = tep_db_query("select zone_name from " . TABLE_ZONES . " where zone_id = '" . (int)$zone_id . "'");

    if (!tep_db_num_rows($zone_query)) {
      return $zone_id;
    } else {
      $zone = tep_db_fetch_array($zone_query);
      return $zone['zone_name'];
    }
  }

////
// Sets the status of a banner
  function tep_set_banner_status($banners_id, $status) {
    if ($status == '1') {
      return tep_db_query("update " . TABLE_BANNERS . " set status = '1', expires_impressions = NULL, expires_date = NULL, date_status_change = NULL where banners_id = '" . $banners_id . "'");
    } elseif ($status == '0') {
      return tep_db_query("update " . TABLE_BANNERS . " set status = '0', date_status_change = now() where banners_id = '" . $banners_id . "'");
    } else {
      return -1;
    }
  }

////
// Sets the status of a product
  function tep_set_product_status($products_id, $status) {
    if ($status == '1') {
      return tep_db_query("update " . TABLE_PRODUCTS . " set products_status = '1', products_last_modified = now() where products_id = '" . (int)$products_id . "'");
    } elseif ($status == '0') {
      return tep_db_query("update " . TABLE_PRODUCTS . " set products_status = '0', products_last_modified = now() where products_id = '" . (int)$products_id . "'");
    } else {
      return -1;
    }
  }

////
// Sets the status of a review
  function tep_set_review_status($reviews_id, $status) {
    if ($status == '1') {
      return tep_db_query("update " . TABLE_REVIEWS . " set reviews_status = '1', last_modified = now() where reviews_id = '" . (int)$reviews_id . "'");
    } elseif ($status == '0') {
      return tep_db_query("update " . TABLE_REVIEWS . " set reviews_status = '0', last_modified = now() where reviews_id = '" . (int)$reviews_id . "'");
    } else {
      return -1;
    }
  }

////
// Sets the status of a product on special
  function tep_set_specials_status($specials_id, $status) {
    if ($status == '1') {
      return tep_db_query("update " . TABLE_SPECIALS . " set status = '1', expires_date = NULL, date_status_change = NULL where specials_id = '" . (int)$specials_id . "'");
    } elseif ($status == '0') {
      return tep_db_query("update " . TABLE_SPECIALS . " set status = '0', date_status_change = now() where specials_id = '" . (int)$specials_id . "'");
    } else {
      return -1;
    }
  }

////
// Sets timeout for the current script.
// Cant be used in safe mode.
  function tep_set_time_limit($limit) {
    if (!get_cfg_var('safe_mode')) {
      set_time_limit($limit);
    }
  }

////
// Alias function for Store configuration values in the Administration Tool
  function tep_cfg_select_option($select_array, $key_value, $key = '') {
    $string = '';

    for ($i=0, $n=sizeof($select_array); $i<$n; $i++) {
      $name = ((tep_not_null($key)) ? 'configuration[' . $key . ']' : 'configuration_value');

      $string .= '<br /><input type="radio" name="' . $name . '" value="' . $select_array[$i] . '"';

      if ($key_value == $select_array[$i]) $string .= ' checked="checked"';

      $string .= ' /> ' . $select_array[$i];
    }

    return $string;
  }

////
// Alias function for module configuration keys
  function tep_mod_select_option($select_array, $key_name, $key_value) {
    reset($select_array);
    foreach ($select_array as $key => $value) {
      if (is_int($key)) $key = $value;
      $string .= '<br /><input type="radio" name="configuration[' . $key_name . ']" value="' . $key . '"';
      if ($key_value == $key) $string .= ' checked="checked"';
      $string .= ' /> ' . $value;
    }

    return $string;
  }

////
// Retreive server information
  function tep_get_system_information() {
    global $HTTP_SERVER_VARS;

    $db_query = tep_db_query("select now() as datetime");
    $db = tep_db_fetch_array($db_query);

    @list($system, $host, $kernel) = preg_split('/[\s,]+/', @exec('uname -a'), 5);

    $data = array();

    $data['oscommerce']  = array('version' => tep_get_version());

    $data['system'] = array('date' => date('Y-m-d H:i:s O T'),
                            'os' => PHP_OS,
                            'kernel' => $kernel,
                            'uptime' => @exec('uptime'),
                            'http_server' => $HTTP_SERVER_VARS['SERVER_SOFTWARE']);

    $data['mysql']  = array('version' => (function_exists('mysql_get_server_info') ? mysqli_get_server_info() : ''),
                            'date' => $db['datetime']);

    $data['php']    = array('version' => PHP_VERSION,
                            'zend' => zend_version(),
                            'sapi' => PHP_SAPI,
                            'int_size'	=> defined('PHP_INT_SIZE') ? PHP_INT_SIZE : '',
                            'safe_mode'	=> (int) @ini_get('safe_mode'),
                            'open_basedir' => (int) @ini_get('open_basedir'),
                            'memory_limit' => @ini_get('memory_limit'),
                            'error_reporting' => error_reporting(),
                            'display_errors' => (int)@ini_get('display_errors'),
                            'allow_url_fopen' => (int) @ini_get('allow_url_fopen'),
                            'allow_url_include' => (int) @ini_get('allow_url_include'),
                            'file_uploads' => (int) @ini_get('file_uploads'),
                            'upload_max_filesize' => @ini_get('upload_max_filesize'),
                            'post_max_size' => @ini_get('post_max_size'),
                            'disable_functions' => @ini_get('disable_functions'),
                            'disable_classes' => @ini_get('disable_classes'),
                            'enable_dl'	=> (int) @ini_get('enable_dl'),
                            'magic_quotes_gpc' => (int) @ini_get('magic_quotes_gpc'),
                            'register_globals' => (int) @ini_get('register_globals'),
                            'filter.default'   => @ini_get('filter.default'),
                            'zend.ze1_compatibility_mode' => (int) @ini_get('zend.ze1_compatibility_mode'),
                            'unicode.semantics' => (int) @ini_get('unicode.semantics'),
                            'zend_thread_safty'	=> (int) function_exists('zend_thread_id'),
                            'extensions' => get_loaded_extensions());

    return $data;
  }

  function tep_generate_category_path($id, $from = 'category', $categories_array = '', $index = 0) {
    global $languages_id;

    if (!is_array($categories_array)) $categories_array = array();

    if ($from == 'product') {
      $categories_query = tep_db_query("select categories_id from " . TABLE_PRODUCTS_TO_CATEGORIES . " where products_id = '" . (int)$id . "'");
      while ($categories = tep_db_fetch_array($categories_query)) {
        if ($categories['categories_id'] == '0') {
          $categories_array[$index][] = array('id' => '0', 'text' => TEXT_TOP);
        } else {
          $category_query = tep_db_query("select cd.categories_name, c.parent_id from " . TABLE_CATEGORIES . " c, " . TABLE_CATEGORIES_DESCRIPTION . " cd where c.categories_id = '" . (int)$categories['categories_id'] . "' and c.categories_id = cd.categories_id and cd.language_id = '" . (int)$languages_id . "'");
          $category = tep_db_fetch_array($category_query);
          $categories_array[$index][] = array('id' => $categories['categories_id'], 'text' => $category['categories_name']);
          if ( (tep_not_null($category['parent_id'])) && ($category['parent_id'] != '0') ) $categories_array = tep_generate_category_path($category['parent_id'], 'category', $categories_array, $index);
          $categories_array[$index] = array_reverse($categories_array[$index]);
        }
        $index++;
      }
    } elseif ($from == 'category') {
      $category_query = tep_db_query("select cd.categories_name, c.parent_id from " . TABLE_CATEGORIES . " c, " . TABLE_CATEGORIES_DESCRIPTION . " cd where c.categories_id = '" . (int)$id . "' and c.categories_id = cd.categories_id and cd.language_id = '" . (int)$languages_id . "'");
      $category = tep_db_fetch_array($category_query);
      $categories_array[$index][] = array('id' => $id, 'text' => $category['categories_name']);
      if ( (tep_not_null($category['parent_id'])) && ($category['parent_id'] != '0') ) $categories_array = tep_generate_category_path($category['parent_id'], 'category', $categories_array, $index);
    }

    return $categories_array;
  }

  function tep_output_generated_category_path($id, $from = 'category') {
    $calculated_category_path_string = '';
    $calculated_category_path = tep_generate_category_path($id, $from);
    for ($i=0, $n=sizeof($calculated_category_path); $i<$n; $i++) {
      for ($j=0, $k=sizeof($calculated_category_path[$i]); $j<$k; $j++) {
        $calculated_category_path_string .= $calculated_category_path[$i][$j]['text'] . '&nbsp;&gt;&nbsp;';
      }
      $calculated_category_path_string = substr($calculated_category_path_string, 0, -16) . '<br />';
    }
    $calculated_category_path_string = substr($calculated_category_path_string, 0, -6);

    if (strlen($calculated_category_path_string) < 1) $calculated_category_path_string = TEXT_TOP;

    return $calculated_category_path_string;
  }

  function tep_get_generated_category_path_ids($id, $from = 'category') {
    $calculated_category_path_string = '';
    $calculated_category_path = tep_generate_category_path($id, $from);
    for ($i=0, $n=sizeof($calculated_category_path); $i<$n; $i++) {
      for ($j=0, $k=sizeof($calculated_category_path[$i]); $j<$k; $j++) {
        $calculated_category_path_string .= $calculated_category_path[$i][$j]['id'] . '_';
      }
      $calculated_category_path_string = substr($calculated_category_path_string, 0, -1) . '<br />';
    }
    $calculated_category_path_string = substr($calculated_category_path_string, 0, -6);

    if (strlen($calculated_category_path_string) < 1) $calculated_category_path_string = TEXT_TOP;

    return $calculated_category_path_string;
  }

  function tep_remove_category($category_id) {
    $category_image_query = tep_db_query("select categories_image from " . TABLE_CATEGORIES . " where categories_id = '" . (int)$category_id . "'");
    $category_image = tep_db_fetch_array($category_image_query);

    $duplicate_image_query = tep_db_query("select count(*) as total from " . TABLE_CATEGORIES . " where categories_image = '" . tep_db_input($category_image['categories_image']) . "'");
    $duplicate_image = tep_db_fetch_array($duplicate_image_query);

    if ($duplicate_image['total'] < 2) {
      if (file_exists(DIR_FS_CATALOG_IMAGES . $category_image['categories_image'])) {
        @unlink(DIR_FS_CATALOG_IMAGES . $category_image['categories_image']);
      }
    }

    tep_db_query("delete from " . TABLE_CATEGORIES . " where categories_id = '" . (int)$category_id . "'");
    tep_db_query("delete from " . TABLE_CATEGORIES_DESCRIPTION . " where categories_id = '" . (int)$category_id . "'");
    tep_db_query("delete from " . TABLE_PRODUCTS_TO_CATEGORIES . " where categories_id = '" . (int)$category_id . "'");

    if (USE_CACHE == 'true') {
      tep_reset_cache_block('categories');
      tep_reset_cache_block('also_purchased');
    }
  }

  function tep_remove_product($product_id) {
    $product_image_query = tep_db_query("select products_image from " . TABLE_PRODUCTS . " where products_id = '" . (int)$product_id . "'");
    $product_image = tep_db_fetch_array($product_image_query);

    $duplicate_image_query = tep_db_query("select count(*) as total from " . TABLE_PRODUCTS . " where products_image = '" . tep_db_input($product_image['products_image']) . "'");
    $duplicate_image = tep_db_fetch_array($duplicate_image_query);

    if ($duplicate_image['total'] < 2) {
      if (file_exists(DIR_FS_CATALOG_IMAGES . $product_image['products_image'])) {
        @unlink(DIR_FS_CATALOG_IMAGES . $product_image['products_image']);
      }
    }

    $product_images_query = tep_db_query("select image from " . TABLE_PRODUCTS_IMAGES . " where products_id = '" . (int)$product_id . "'");
    if (tep_db_num_rows($product_images_query)) {
      while ($product_images = tep_db_fetch_array($product_images_query)) {
        $duplicate_image_query = tep_db_query("select count(*) as total from " . TABLE_PRODUCTS_IMAGES . " where image = '" . tep_db_input($product_images['image']) . "'");
        $duplicate_image = tep_db_fetch_array($duplicate_image_query);

        if ($duplicate_image['total'] < 2) {
          if (file_exists(DIR_FS_CATALOG_IMAGES . $product_images['image'])) {
            @unlink(DIR_FS_CATALOG_IMAGES . $product_images['image']);
          }
        }
      }

      tep_db_query("delete from " . TABLE_PRODUCTS_IMAGES . " where products_id = '" . (int)$product_id . "'");
    }

    tep_db_query("delete from " . TABLE_SPECIALS . " where products_id = '" . (int)$product_id . "'");
    tep_db_query("delete from " . TABLE_PRODUCTS . " where products_id = '" . (int)$product_id . "'");
    tep_db_query("delete from " . TABLE_PRODUCTS_TO_CATEGORIES . " where products_id = '" . (int)$product_id . "'");
    tep_db_query("delete from " . TABLE_PRODUCTS_DESCRIPTION . " where products_id = '" . (int)$product_id . "'");
    tep_db_query("delete from " . TABLE_PRODUCTS_ATTRIBUTES . " where products_id = '" . (int)$product_id . "'");
    tep_db_query("delete from " . TABLE_CUSTOMERS_BASKET . " where products_id = '" . (int)$product_id . "' or products_id like '" . (int)$product_id . "{%'");
    tep_db_query("delete from " . TABLE_CUSTOMERS_BASKET_ATTRIBUTES . " where products_id = '" . (int)$product_id . "' or products_id like '" . (int)$product_id . "{%'");

    $product_reviews_query = tep_db_query("select reviews_id from " . TABLE_REVIEWS . " where products_id = '" . (int)$product_id . "'");
    while ($product_reviews = tep_db_fetch_array($product_reviews_query)) {
      tep_db_query("delete from " . TABLE_REVIEWS_DESCRIPTION . " where reviews_id = '" . (int)$product_reviews['reviews_id'] . "'");
    }
    tep_db_query("delete from " . TABLE_REVIEWS . " where products_id = '" . (int)$product_id . "'");

    if (USE_CACHE == 'true') {
      tep_reset_cache_block('categories');
      tep_reset_cache_block('also_purchased');
    }
  }

  function tep_remove_order($order_id, $restock = false) {
    if ($restock == 'on') {
      $order_query = tep_db_query("select products_id, products_quantity from " . TABLE_ORDERS_PRODUCTS . " where orders_id = '" . (int)$order_id . "'");
      while ($order = tep_db_fetch_array($order_query)) {
        tep_db_query("update " . TABLE_PRODUCTS . " set products_quantity = products_quantity + " . $order['products_quantity'] . ", products_ordered = products_ordered - " . $order['products_quantity'] . " where products_id = '" . (int)$order['products_id'] . "'");
      }
    }

    tep_db_query("delete from " . TABLE_ORDERS . " where orders_id = '" . (int)$order_id . "'");
    tep_db_query("delete from " . TABLE_ORDERS_PRODUCTS . " where orders_id = '" . (int)$order_id . "'");
    tep_db_query("delete from " . TABLE_ORDERS_PRODUCTS_ATTRIBUTES . " where orders_id = '" . (int)$order_id . "'");
    tep_db_query("delete from " . TABLE_ORDERS_STATUS_HISTORY . " where orders_id = '" . (int)$order_id . "'");
    tep_db_query("delete from " . TABLE_ORDERS_TOTAL . " where orders_id = '" . (int)$order_id . "'");
  }

  function tep_reset_cache_block($cache_block) {
    global $cache_blocks;

    for ($i=0, $n=sizeof($cache_blocks); $i<$n; $i++) {
      if ($cache_blocks[$i]['code'] == $cache_block) {
        if ($cache_blocks[$i]['multiple']) {
          if ($dir = @opendir(DIR_FS_CACHE)) {
            while ($cache_file = readdir($dir)) {
              $cached_file = $cache_blocks[$i]['file'];
              $languages = tep_get_languages();
              for ($j=0, $k=sizeof($languages); $j<$k; $j++) {
                $cached_file_unlink = preg_replace('/-language/', '-' . $languages[$j]['directory'], $cached_file);
                if (preg_match('/^' . $cached_file_unlink . '/', $cache_file)) {
                  @unlink(DIR_FS_CACHE . $cache_file);
                }
              }
            }
            closedir($dir);
          }
        } else {
          $cached_file = $cache_blocks[$i]['file'];
          $languages = tep_get_languages();
          for ($i=0, $n=sizeof($languages); $i<$n; $i++) {
            $cached_file = preg_replace('/-language/', '-' . $languages[$i]['directory'], $cached_file);
            @unlink(DIR_FS_CACHE . $cached_file);
          }
        }
        break;
      }
    }
  }

  function tep_get_file_permissions($mode) {
// determine type
    if ( ($mode & 0xC000) == 0xC000) { // unix domain socket
      $type = 's';
    } elseif ( ($mode & 0x4000) == 0x4000) { // directory
      $type = 'd';
    } elseif ( ($mode & 0xA000) == 0xA000) { // symbolic link
      $type = 'l';
    } elseif ( ($mode & 0x8000) == 0x8000) { // regular file
      $type = '-';
    } elseif ( ($mode & 0x6000) == 0x6000) { //bBlock special file
      $type = 'b';
    } elseif ( ($mode & 0x2000) == 0x2000) { // character special file
      $type = 'c';
    } elseif ( ($mode & 0x1000) == 0x1000) { // named pipe
      $type = 'p';
    } else { // unknown
      $type = '?';
    }

// determine permissions
    $owner['read']    = ($mode & 00400) ? 'r' : '-';
    $owner['write']   = ($mode & 00200) ? 'w' : '-';
    $owner['execute'] = ($mode & 00100) ? 'x' : '-';
    $group['read']    = ($mode & 00040) ? 'r' : '-';
    $group['write']   = ($mode & 00020) ? 'w' : '-';
    $group['execute'] = ($mode & 00010) ? 'x' : '-';
    $world['read']    = ($mode & 00004) ? 'r' : '-';
    $world['write']   = ($mode & 00002) ? 'w' : '-';
    $world['execute'] = ($mode & 00001) ? 'x' : '-';

// adjust for SUID, SGID and sticky bit
    if ($mode & 0x800 ) $owner['execute'] = ($owner['execute'] == 'x') ? 's' : 'S';
    if ($mode & 0x400 ) $group['execute'] = ($group['execute'] == 'x') ? 's' : 'S';
    if ($mode & 0x200 ) $world['execute'] = ($world['execute'] == 'x') ? 't' : 'T';

    return $type .
           $owner['read'] . $owner['write'] . $owner['execute'] .
           $group['read'] . $group['write'] . $group['execute'] .
           $world['read'] . $world['write'] . $world['execute'];
  }

  function tep_remove($source) {
    global $messageStack, $tep_remove_error;

    if (isset($tep_remove_error)) $tep_remove_error = false;

    if (is_dir($source)) {
      $dir = dir($source);
      while ($file = $dir->read()) {
        if ( ($file != '.') && ($file != '..') ) {
          if (tep_is_writable($source . '/' . $file)) {
            tep_remove($source . '/' . $file);
          } else {
            $messageStack->add(sprintf(ERROR_FILE_NOT_REMOVEABLE, $source . '/' . $file), 'error');
            $tep_remove_error = true;
          }
        }
      }
      $dir->close();

      if (tep_is_writable($source)) {
        rmdir($source);
      } else {
        $messageStack->add(sprintf(ERROR_DIRECTORY_NOT_REMOVEABLE, $source), 'error');
        $tep_remove_error = true;
      }
    } else {
      if (tep_is_writable($source)) {
        unlink($source);
      } else {
        $messageStack->add(sprintf(ERROR_FILE_NOT_REMOVEABLE, $source), 'error');
        $tep_remove_error = true;
      }
    }
  }

////
// Output the tax percentage with optional padded decimals
  function tep_display_tax_value($value, $padding = TAX_DECIMAL_PLACES) {
    if (strpos($value, '.')) {
      $loop = true;
      while ($loop) {
        if (substr($value, -1) == '0') {
          $value = substr($value, 0, -1);
        } else {
          $loop = false;
          if (substr($value, -1) == '.') {
            $value = substr($value, 0, -1);
          }
        }
      }
    }

    if ($padding > 0) {
      if ($decimal_pos = strpos($value, '.')) {
        $decimals = strlen(substr($value, ($decimal_pos+1)));
        for ($i=$decimals; $i<$padding; $i++) {
          $value .= '0';
        }
      } else {
        $value .= '.';
        for ($i=0; $i<$padding; $i++) {
          $value .= '0';
        }
      }
    }

    return $value;
  }

  function tep_mail($to_name, $to_email_address, $email_subject, $email_text, $from_email_name, $from_email_address) {
    if (SEND_EMAILS != 'true') return false;

    // Instantiate a new mail object
    $message = new email(array('X-Mailer: osCommerce'));

    // Build the text version
    $text = strip_tags($email_text);
    if (EMAIL_USE_HTML == 'true') {
      $message->add_html($email_text, $text);
    } else {
      $message->add_text($text);
    }

    // Send message
    $message->build_message();
    $message->send($to_name, $to_email_address, $from_email_name, $from_email_address, $email_subject);
  }

  function tep_get_tax_class_title($tax_class_id) {
    if ($tax_class_id == '0') {
      return TEXT_NONE;
    } else {
      $classes_query = tep_db_query("select tax_class_title from " . TABLE_TAX_CLASS . " where tax_class_id = '" . (int)$tax_class_id . "'");
      $classes = tep_db_fetch_array($classes_query);

      return $classes['tax_class_title'];
    }
  }

  function tep_banner_image_extension() {
    if (function_exists('imagetypes')) {
      if (imagetypes() & IMG_PNG) {
        return 'png';
      } elseif (imagetypes() & IMG_JPG) {
        return 'jpg';
      } elseif (imagetypes() & IMG_GIF) {
        return 'gif';
      }
    } elseif (function_exists('imagecreatefrompng') && function_exists('imagepng')) {
      return 'png';
    } elseif (function_exists('imagecreatefromjpeg') && function_exists('imagejpeg')) {
      return 'jpg';
    } elseif (function_exists('imagecreatefromgif') && function_exists('imagegif')) {
      return 'gif';
    }

    return false;
  }

////
// Wrapper function for round() for php3 compatibility
  function tep_round($value, $precision) {
    return round($value, $precision);
  }

////
// Add tax to a products price
  function tep_add_tax($price, $tax, $override = false) {
    if ( ( (DISPLAY_PRICE_WITH_TAX == 'true') || ($override == true) ) && ($tax > 0) ) {
      return $price + tep_calculate_tax($price, $tax);
    } else {
      return $price;
    }
  }

// Calculates Tax rounding the result
  function tep_calculate_tax($price, $tax) {
    return $price * $tax / 100;
  }

////
// Returns the tax rate for a zone / class
// TABLES: tax_rates, zones_to_geo_zones
  function tep_get_tax_rate($class_id, $country_id = -1, $zone_id = -1) {
    global $customer_zone_id, $customer_country_id;

    if ( ($country_id == -1) && ($zone_id == -1) ) {
      if (!tep_session_is_registered('customer_id')) {
        $country_id = STORE_COUNTRY;
        $zone_id = STORE_ZONE;
      } else {
        $country_id = $customer_country_id;
        $zone_id = $customer_zone_id;
      }
    }

    $tax_query = tep_db_query("select SUM(tax_rate) as tax_rate from " . TABLE_TAX_RATES . " tr left join " . TABLE_ZONES_TO_GEO_ZONES . " za ON tr.tax_zone_id = za.geo_zone_id left join " . TABLE_GEO_ZONES . " tz ON tz.geo_zone_id = tr.tax_zone_id WHERE (za.zone_country_id IS NULL OR za.zone_country_id = '0' OR za.zone_country_id = '" . (int)$country_id . "') AND (za.zone_id IS NULL OR za.zone_id = '0' OR za.zone_id = '" . (int)$zone_id . "') AND tr.tax_class_id = '" . (int)$class_id . "' GROUP BY tr.tax_priority");
    if (tep_db_num_rows($tax_query)) {
      $tax_multiplier = 0;
      while ($tax = tep_db_fetch_array($tax_query)) {
        $tax_multiplier += $tax['tax_rate'];
      }
      return $tax_multiplier;
    } else {
      return 0;
    }
  }

////
// Returns the tax rate for a tax class
// TABLES: tax_rates
  function tep_get_tax_rate_value($class_id) {
    $tax_query = tep_db_query("select SUM(tax_rate) as tax_rate from " . TABLE_TAX_RATES . " where tax_class_id = '" . (int)$class_id . "' group by tax_priority");
    if (tep_db_num_rows($tax_query)) {
      $tax_multiplier = 0;
      while ($tax = tep_db_fetch_array($tax_query)) {
        $tax_multiplier += $tax['tax_rate'];
      }
      return $tax_multiplier;
    } else {
      return 0;
    }
  }

  function tep_call_function($function, $parameter, $object = '') {
    if ($object == '') {
      return call_user_func($function, $parameter);
    } else {
      return call_user_func(array($object, $function), $parameter);
    }
  }

  function tep_get_zone_class_title($zone_class_id) {
    if ($zone_class_id == '0') {
      return TEXT_NONE;
    } else {
      $classes_query = tep_db_query("select geo_zone_name from " . TABLE_GEO_ZONES . " where geo_zone_id = '" . (int)$zone_class_id . "'");
      $classes = tep_db_fetch_array($classes_query);

      return $classes['geo_zone_name'];
    }
  }

  function tep_cfg_pull_down_zone_classes($zone_class_id, $key = '') {
    $name = (($key) ? 'configuration[' . $key . ']' : 'configuration_value');

    $zone_class_array = array(array('id' => '0', 'text' => TEXT_NONE));
    $zone_class_query = tep_db_query("select geo_zone_id, geo_zone_name from " . TABLE_GEO_ZONES . " order by geo_zone_name");
    while ($zone_class = tep_db_fetch_array($zone_class_query)) {
      $zone_class_array[] = array('id' => $zone_class['geo_zone_id'],
                                  'text' => $zone_class['geo_zone_name']);
    }

    return tep_draw_pull_down_menu($name, $zone_class_array, $zone_class_id);
  }

  function tep_cfg_pull_down_order_statuses($order_status_id, $key = '') {
    global $languages_id;

    $name = (($key) ? 'configuration[' . $key . ']' : 'configuration_value');

    $statuses_array = array(array('id' => '0', 'text' => TEXT_DEFAULT));
    $statuses_query = tep_db_query("select orders_status_id, orders_status_name from " . TABLE_ORDERS_STATUS . " where language_id = '" . (int)$languages_id . "' order by orders_status_name");
    while ($statuses = tep_db_fetch_array($statuses_query)) {
      $statuses_array[] = array('id' => $statuses['orders_status_id'],
                                'text' => $statuses['orders_status_name']);
    }

    return tep_draw_pull_down_menu($name, $statuses_array, $order_status_id);
  }

  function tep_get_order_status_name($order_status_id, $language_id = '') {
    global $languages_id;

    if ($order_status_id < 1) return TEXT_DEFAULT;

    if (!is_numeric($language_id)) $language_id = $languages_id;

    $status_query = tep_db_query("select orders_status_name from " . TABLE_ORDERS_STATUS . " where orders_status_id = '" . (int)$order_status_id . "' and language_id = '" . (int)$language_id . "'");
    $status = tep_db_fetch_array($status_query);

    return $status['orders_status_name'];
  }

////
// Return a random value
  function tep_rand($min = null, $max = null) {
    static $seeded;

    if (!$seeded) {
      mt_srand((double)microtime()*1000000);
      $seeded = true;
    }

    if (isset($min) && isset($max)) {
      if ($min >= $max) {
        return $min;
      } else {
        return mt_rand($min, $max);
      }
    } else {
      return mt_rand();
    }
  }

// nl2br() prior PHP 4.2.0 did not convert linefeeds on all OSs (it only converted \n)
  function tep_convert_linefeeds($from, $to, $string) {
    if ((PHP_VERSION < "4.0.5") && is_array($from)) {
      return preg_replace('/(' . implode('|', $from) . ')/', $to, $string);
    } else {
      return str_replace($from, $to, $string);
    }
  }

  function tep_string_to_int($string) {
    return (int)$string;
  }

////
// Parse and secure the cPath parameter values
  function tep_parse_category_path($cPath) {
// make sure the category IDs are integers
    $cPath_array = array_map('tep_string_to_int', explode('_', $cPath));

// make sure no duplicate category IDs exist which could lock the server in a loop
    $tmp_array = array();
    $n = sizeof($cPath_array);
    for ($i=0; $i<$n; $i++) {
      if (!in_array($cPath_array[$i], $tmp_array)) {
        $tmp_array[] = $cPath_array[$i];
      }
    }

    return $tmp_array;
  }

  function tep_validate_ip_address($ip_address) {
    if (function_exists('filter_var') && defined('FILTER_VALIDATE_IP')) {
      return filter_var($ip_address, FILTER_VALIDATE_IP, array('flags' => FILTER_FLAG_IPV4));
    }

    if (preg_match('/^(\d{1,3})\.(\d{1,3})\.(\d{1,3})\.(\d{1,3})$/', $ip_address)) {
      $parts = explode('.', $ip_address);

      foreach ($parts as $ip_parts) {
        if ( (intval($ip_parts) > 255) || (intval($ip_parts) < 0) ) {
          return false; // number is not within 0-255
        }
      }

      return true;
    }

    return false;
  }

  function tep_get_ip_address() {
    global $HTTP_SERVER_VARS;

    $ip_address = null;
    $ip_addresses = array();

    if (isset($HTTP_SERVER_VARS['HTTP_X_FORWARDED_FOR']) && !empty($HTTP_SERVER_VARS['HTTP_X_FORWARDED_FOR'])) {
      foreach ( array_reverse(explode(',', $HTTP_SERVER_VARS['HTTP_X_FORWARDED_FOR'])) as $x_ip ) {
        $x_ip = trim($x_ip);

        if (tep_validate_ip_address($x_ip)) {
          $ip_addresses[] = $x_ip;
        }
      }
    }

    if (isset($HTTP_SERVER_VARS['HTTP_CLIENT_IP']) && !empty($HTTP_SERVER_VARS['HTTP_CLIENT_IP'])) {
      $ip_addresses[] = $HTTP_SERVER_VARS['HTTP_CLIENT_IP'];
    }

    if (isset($HTTP_SERVER_VARS['HTTP_X_CLUSTER_CLIENT_IP']) && !empty($HTTP_SERVER_VARS['HTTP_X_CLUSTER_CLIENT_IP'])) {
      $ip_addresses[] = $HTTP_SERVER_VARS['HTTP_X_CLUSTER_CLIENT_IP'];
    }

    if (isset($HTTP_SERVER_VARS['HTTP_PROXY_USER']) && !empty($HTTP_SERVER_VARS['HTTP_PROXY_USER'])) {
      $ip_addresses[] = $HTTP_SERVER_VARS['HTTP_PROXY_USER'];
    }

    $ip_addresses[] = $HTTP_SERVER_VARS['REMOTE_ADDR'];

    foreach ( $ip_addresses as $ip ) {
      if (!empty($ip) && tep_validate_ip_address($ip)) {
        $ip_address = $ip;
        break;
      }
    }

    return $ip_address;
  }

////
// Wrapper function for is_writable() for Windows compatibility
  function tep_is_writable($file) {
    if (strtolower(substr(PHP_OS, 0, 3)) === 'win') {
      if (file_exists($file)) {
        $file = realpath($file);
        if (is_dir($file)) {
          $result = @tempnam($file, 'osc');
          if (is_string($result) && file_exists($result)) {
            unlink($result);
            return (strpos($result, $file) === 0) ? true : false;
          }
        } else {
          $handle = @fopen($file, 'r+');
          if (is_resource($handle)) {
            fclose($handle);
            return true;
          }
        }
      } else{
        $dir = dirname($file);
        if (file_exists($dir) && is_dir($dir) && tep_is_writable($dir)) {
          return true;
        }
      }
      return false;
    } else {
      return is_writable($file);
    }
  }
  
  // Returns an array with day_schools
// TABLES: schools
  function tep_get_day_schools( ) {
    $day_schools_array = array();
      $day_schools = tep_db_query("select day_schools_id, day_schools_name from day_schools where school_status='Active' order by day_schools_name");
      while ($day_schools_values = tep_db_fetch_array($day_schools)) {
        $day_schools_array[] = array('day_schools_id' => $day_schools_values['day_schools_id'],
                                   'day_schools_name' => $day_schools_values['day_schools_name']);
      }

    return $day_schools_array;
  }

   function tep_get_day_school($day_schools_id ) {
    $day_schools_array = array();
      $day_schools = tep_db_query("select day_schools_id, day_schools_name from day_schools order by day_schools_name where day_schools_id='".$day_schools_id."'");
      $day_schools_values = tep_db_fetch_array($day_schools);
    return $day_schools_values['day_schools_name'];
  }
    // Returns an array with family names
// TABLES: families
  function tep_get_family_names( ) {
    $name_array = array();
      $families = tep_db_query("select * from families order by families_name");
      while ($families_values = tep_db_fetch_array($families)) {
        $name_array[] = array('families_id' => $families_values['families_id'],
		'families_address' => $families_values['families_address'],
                                   'families_name' => $families_values['families_name']);
      }

    return $name_array;
  }
    
  function tep_get_family($families_id) {
    $array = array();
	
     $query = tep_db_query("select* from families where families_id='".$families_id."' ");
      while ($info = tep_db_fetch_array($query)) {
        $array[] = array('families_id' => $info['families_id'],
						'families_name' => $info['families_name'],
						'families_address' => $info['families_address'],
						'families_city' => $info['families_city'],
						'families_state' => $info['families_state'],
						'families_zip' => $info['families_zip'],
						'home_phone' => $info['home_phone'],
						'health_insurance' => $info['health_insurance'],						
                        'lead_resources' => $info['lead_resources']
								   );
      }

    return $array;
  }	
	
   function tep_get_schedule_types() {
	 
    $product_query = tep_db_query("SELECT * from schedule_types");
  while (  $product = tep_db_fetch_array($product_query)) {
        $day_schools_products_array[] = array('schedule_types_id' => $product['schedule_types_id'],
											'schedule_types' => $product['schedule_types']);
      }
    return $day_schools_products_array;
  
  }
  // Returns an array with categories
// Tables: caegories
function tep_get_categories( ){
	  $day_schools_array = array();
      $day_schools = tep_db_query("select classes_categories_id, classes_categories from classes_categories");
      while ($day_schools_values = tep_db_fetch_array($day_schools)) {
        $day_schools_array[] = array('classes_categories_id' => $day_schools_values['classes_categories_id'],
                                   'classes_categories' => $day_schools_values['classes_categories']);
      }

    return $day_schools_array;
}


  // Returns announcements
// Tables: announcements
function tep_get_announcements( ){
	 
      $info = tep_db_fetch_array(tep_db_query("select announcements from announcements where announcements_id=1"));
    return $info['announcements'];

}

function getDay($meeting_days){

$mds="";
 foreach ($meeting_days as $d){
		//echo $d;
		switch($d){
		case 1:
		$md='M';
		break;
		case 2:
		$md='T';
		break;
		case 3:
		$md='W';
		break;
		case 4:
		$md='TH';
		break;
		case 5:
		$md='F';
		break;
		case 6:
		$md='Sat';
		break;
		case 7:
		$md='Sun';
		break;
		}
		$mds=($mds==""?$md:($mds.','.$md));
	//$mds =$mds.' '.$md.' ';	
		
 }
 return $mds; 
}

// Return a student's name
// TABLES: students

  function tep_get_student($students_id) {

	$student_array= array();
	
    $student_query = tep_db_query("select * from  students, families, customers 
where students.families_id=families.families_id
and customers.families_id=families.families_id
and students_id = " . (int)$students_id );
if( $student_query !="") {
 while ($student_values = tep_db_fetch_array($student_query)) {

		 $student_array[] = array(
		 'day_schools_id' => $student_values['day_schools_id'],
		 'grade' => $student_values['grade'],
		'families_id' => $student_values['families_id'],
		 'students_first_name' => $student_values['students_first_name'],		
		'students_last_name' => $student_values['students_last_name'],
		'gender' => $student_values['gender'],
		'students_status' => $student_values['students_status'],
		'disabilities' => $student_values['disabilities'],
		'allergies' => $student_values['allergies'],
		'medications' => $student_values['medications'],
		'doctor' => $student_values['doctor'],
		'doctor_phone' => $student_values['doctor_phone'],
		'doctor_address' => $student_values['doctor_address'],
		'registration_fee_paid' => $student_values['registration_fee_paid'],
		'register_status' => $student_values['register_status'],
		'birthday' => $student_values['birthday'],
		'agreement_link' => $student_values['agreement_link'],
		'registration_status' => $student_values['registration_status'],
		'media_release' => $student_values['media_release'],
		
		) ;

			 }

    return $student_array;
}
else {
	return 0;
	
}



  }
  	  //get customer first name
    function tep_get_customers_first_name($students_id){
	 $info = tep_db_fetch_array (tep_db_query("SELECT customers_firstname FROM `students`, customers WHERE students.families_id=customers.families_id and students_id='".$students_id ."'"));
	  return $info['customers_firstname'];
	  }
  //get customer email
    function tep_get_customers_email($students_id){
	 $info = tep_db_fetch_array (tep_db_query("SELECT customers_email_address FROM `students`, customers WHERE students.families_id=customers.families_id and students_id='".$students_id ."'"));
	  return $info['customers_email_address'];
	  }
	  //get customer first name
    function tep_get_ecustomers_first_name($enrollments_id){
	 $info = tep_db_fetch_array (tep_db_query("SELECT customers_firstname FROM `students`, customers,enrollments WHERE enrollments.students_id =students.students_id and students.families_id=customers.families_id and enrollments_id='".$enrollments_id ."'"));
	  return $info['customers_firstname'];
	  }
	  //get customer first name
    function tep_get_ecustomers_classes_id($enrollments_id){
	 $info = tep_db_fetch_array (tep_db_query("SELECT classes_id FROM  enrollments WHERE enrollments_id='".$enrollments_id ."'"));
	  return $info['classes_id'];
	  }
  //get customer email
    function tep_eget_customers_email($enrollments_id){
	 $info = tep_db_fetch_array (tep_db_query("SELECT customers_email_address FROM `students`, customers,enrollments WHERE enrollments.students_id =students.students_id and students.families_id=customers.families_id and enrollments_id='".$enrollments_id ."'"));
	  return $info['customers_email_address'];
	  }  
	    //get customer first name
    function tep_get_students_first_name($enrollments_id){
	 $info = tep_db_fetch_array (tep_db_query("SELECT students_first_name
FROM `students` , enrollments
WHERE enrollments.students_id = students.students_id
AND enrollments_id ='".$enrollments_id ."'"));
	  return $info['students_first_name'];
	  }  
	  //get contact
	 function tep_get_contact($families_id){
		  $array = array();
      $query = tep_db_query("select* from contacts where families_id='".$families_id."' order by contact_type desc");
      while ($info = tep_db_fetch_array($query)) {
        $array[] = array('families_id' => $info['families_id'],
						'contacts_work_phone' => $info['contacts_work_phone'],
						'relationship' => $info['relationship'],
						'contacts_cell_phone' => $info['contacts_cell_phone'],
						'contacts_email' => $info['contacts_email'],
						'contact_type' => $info['contact_type'],
						'contacts_last_name' => $info['contacts_last_name'],
                        'contacts_first_name' => $info['contacts_first_name']);
      }

    return $array;

		 }

		 
	   //check if a date is vacation date
    function check_vacation_date($d){
	 $row = tep_db_num_rows (tep_db_query("SELECT * FROM vacation_dates WHERE vacation_dates='".$d."'"));
	  if($row>0)
	  return 1;
	  else
	  return 0;
	  }
  //check if a date is full date
    function check_full_date($d){
	 $row = tep_db_num_rows (tep_db_query("SELECT * FROM full_dates WHERE full_dates='".$d."'"));
	  if($row>0)
	  return 1;
	  else
	  return 0;
	  }
		  
	  //check if a date is short date
    function check_short_date($day_schools_id,$d){
	 $info = tep_db_fetch_array (tep_db_query("SELECT schools_short_day  FROM day_schools WHERE short_day_charge ='Y' and  day_schools_id='".$day_schools_id."'"));
	 $day=date('l',strtotime($d));
	 //if (date('D',strtotime('2012-08-26')) =='Sun')
	 if ($day==$info['schools_short_day'])
	 return 1;
	 else
	 return 0;
	  }  
  function tep_get_afterschool_programs() {
	//$today= date('Y-m-d');
	   $month=date('Y-m-01' );
			  $product_query = tep_db_query("SELECT classes_name, classes_id FROM classes where classes_categories_id=1 and end_date>='". $month."'");
    
  while (  $product = tep_db_fetch_array($product_query)) {
        $day_schools_products_array[] = array('classes_id' => $product['classes_id'],
											'classes_name' => $product['classes_name']);
      }
    return $day_schools_products_array;
  
  }
  function tep_get_summer_week_description($week){
      $query = tep_db_query("SELECT summer_week_description FROM summer_weeks WHERE summer_week=".$week);
	  
     $info = tep_db_fetch_array($query) 	;
      $summer_week_description =$info['summer_week_description'];
	      return $summer_week_description;
		 } 	
function tep_get_summer_weeks_days($week,$locations_id){
$firstdate=date('Y-m-d', strtotime("first day of january " . date('Y')));
	 $array = array();
  
      $query = tep_db_query("SELECT * FROM `summer_weeks_days` WHERE summer_week=".$week." and locations_id=".$locations_id." 
	  and `summer_date` >= '".$firstdate."' order by summer_date");
// $query = tep_db_query("SELECT * FROM `summer_weeks_days` WHERE summer_week=".$week." and status='Y' order by summer_date");
      while ($info = tep_db_fetch_array($query)) {

        $array[] = array('summer_day_id' => $info['summer_day_id'],

						'summer_day' => $info['summer_day'],

						'summer_date' => $info['summer_date'],

						'status' => $info['status']

						);

      }

    return $array;

		 }

function tep_get_selected_summer_day($summer_day_id){

	

      $query = tep_db_query("SELECT * FROM `summer_weeks_days` WHERE summer_day_id=".$summer_day_id." order by summer_date");

     $info = tep_db_fetch_array($query) 	;

      $summer_day =$info['summer_day'];

	      return $summer_day;

		 }
		 
		 
function tep_get_selected_summer_date($summer_day_id){

      $query = tep_db_query("SELECT * FROM `summer_weeks_days` WHERE summer_day_id=".$summer_day_id." order by summer_date");

     $info = tep_db_fetch_array($query) 	;

      $summer_date =$info['summer_date'];

	      return $summer_date;

		 }
function tep_get_selected_summer_day_id($summer_date,$lcoations_id=1){
	 $sql="SELECT * FROM `summer_weeks_days` WHERE summer_date='".$summer_date."' and locations_id=".$lcoations_id;
      $query = tep_db_query($sql);

     $info = tep_db_fetch_array($query) 	;

      $summer_day_id =$info['summer_day_id'];

	      return $summer_day_id;

		 }	
	
		
function tep_get_first_summer_day_week($week){
	
      $query = tep_db_query("SELECT min(summer_date) as m FROM summer_weeks_days WHERE summer_week=".$week." and status='Y'");
     $info = tep_db_fetch_array($query) 	;
      $summer_date =$info['m'];
	      return $summer_date;
		 } 
		 
  function tep_get_summer_programs(){
	 $array = array();
	/*   $query = tep_db_query("select* from classes where classes_categories_id =6 ");
      while ($info = tep_db_fetch_array($query)) {
        $array[] = array('classes_id' => $info['classes_id'],
						'classes_name' => $info['classes_name']
						);
      } */
      $query = tep_db_query("select* from summer_programs ");
      while ($info = tep_db_fetch_array($query)) {
        $array[] = array('summer_programs_id' => $info['summer_programs_id'],
						'summer_program' => $info['summer_program'],
						'weekly_cost' => $info['weekly_cost'],
						'weekly_cost_sports' => $info['weekly_cost_sports']
						);
      }
	 
    return $array;
		 }
	 function tep_get_summer_sports($week,$summer_class_level_id){
	 $array = array();
	 /* echo "select* from summer_sports where summer_class_level_id='".$summer_class_level_id  ."' and (summer_week=0 or summer_week=".$week.") order by summer_sport";*/
if ($summer_class_level_id==8)
	$query = tep_db_query("select* from summer_sports where (summer_week=0 or summer_week=".$week.") and year='2018' order by summer_sport,summer_class_level_id ");
else
	$query = tep_db_query("select* from summer_sports where summer_class_level_id='".$summer_class_level_id  ."' and (summer_week=0 or summer_week=".$week.") and year='2018' order by summer_sport");

	
      while ($info = tep_db_fetch_array($query)) {
        $array[] = array('summer_sports_id' => $info['summer_sports_id'],
						'summer_sport' => $info['summer_sport']
						);
      }
    return $array;
		 }


	function tep_get_summer_schedule($enrollments_id){

	 $array = array();


      $query = tep_db_query("select * from enrollments as en, students as stu where en.students_id=stu.students_id and  en.enrollments_id=".$enrollments_id);

      while ($info = tep_db_fetch_array($query)) {

        $array[] = array('tuition' => $info['tuition'],
						'enrollment_date' => $info['enrollment_date'],
						'classes_id' => $info['classes_id'],	
						'customers_id' => $info['customers_id'],
						'students_id' => $info['students_id'],
						'enrollments_status' => $info['enrollments_status'],
						'meeting_days' => $info['meeting_days'],
						'students_last_name' => $info['students_last_name'],
						'students_first_name' => $info['students_first_name'],
						'disabilities' => $info['disabilities'],
						'allergies' => $info['allergies'],
						'medications' => $info['medications'],
						'total' => $info['total'], 	
						'lunch_total' => $info['lunch_total'],
						'material_fee' => $info['material_fee'],
						'material_fee_waived' => $info['material_fee_waived'],
						'tuition_paid' => $info['tuition_paid'],
                         'order_all_lunches' => $info['order_all_lunches'],
						'discount' => $info['discount'], 
						'promotion_discount' => $info['promotion_discount'], 
						'other_discount' => $info['other_discount'], 
						'early_bird_discount' => $info['early_bird_discount'], 
					    'sibling_discount' => $info['sibling_discount'], 
						'registration_fee' => $info['registration_fee'],
						'registration_fee_waived' => $info['registration_fee_waived'],						
						'summer_pickup_locations_id' => $info['summer_pickup_locations_id'],							   
						'locations_id' => $info['locations_id'],
						'cancellation_fee' => $info['cancellation_fee'],							
						'year' => $info['year']
						);
      }
    return $array;
	}
	


	
	 function tep_get_summer_enrollment_schedule_lunch($enrollments_id, $week){
      $query = tep_db_query("select summer_day_id  from summer_enrollments_schedules  where lunch_ordered=1 and enrollments_id=".$enrollments_id." and summer_week=".$week);
      while ($info = tep_db_fetch_array($query)) {
        $array[] =  $info['summer_day_id'];
      }
    return $array;
	}
	function tep_get_summer_enrollment_schedule_array($enrollments_id, $week){
      $query = tep_db_query("select *  from summer_enrollments_schedules  where enrollments_id=".$enrollments_id." and summer_week=".$week);
      while ($info = tep_db_fetch_array($query)) {
        $array[] = array( 'summer_programs_id' => $info['summer_day_id'],
		'lunch_ordered' => $info['lunch_ordered']
		);
      }
    return $array;
	}
function tep_get_summer_sport($summer_sports_id){
	
      $query = tep_db_query("SELECT * FROM  summer_sports WHERE summer_sports_id=".$summer_sports_id);
     $info = tep_db_fetch_array($query) 	;
    
	      return  $info['summer_sport'];
		 }
function tep_get_summer_program($summer_programs_id){
      $query = tep_db_query("SELECT * FROM  summer_programs WHERE summer_programs_id=".$summer_programs_id);
     $info = tep_db_fetch_array($query) 	;
	      return  $info['summer_program'];
		 }
		 
 function tep_get_summer_class_levels($summer_class_level_id=0){

	 $array = array();
		if($summer_class_level_id==0){
      $query = tep_db_query("select* from summer_class_levels where (summer_class_level_id< 10 and summer_class_level_id>1) and summer_class_level_id!=5");
		}
		else
		$query = tep_db_query("select* from summer_class_levels where summer_class_level_id=".$summer_class_level_id);	

      while ($info = tep_db_fetch_array($query)) {

        $array[] = array('summer_class_level_id' => $info['summer_class_level_id'],

						'summer_class_level' => $info['summer_class_level'],

						);

      }



    return $array;



		 }
 /*function tep_get_summer_art_class($summer_class_levels_id,$week){


	 $info = tep_db_fetch_array (tep_db_query("SELECT * FROM summer_art_classes WHERE summer_class_levels_id ='".$summer_class_levels_id ."' and (summer_week=0 or summer_week='".$week ."')"));

	  return $info['summer_art_class'];

	  }
	   function tep_get_summer_art_class_id($summer_class_levels_id,$week){


	 $info = tep_db_fetch_array (tep_db_query("SELECT * FROM summer_art_classes WHERE summer_class_levels_id ='".$summer_class_levels_id ."' and (summer_week=0 or summer_week='".$week ."')"));

	  return $info['summer_art_classes_id'];

	  }
	  */
	  function tep_get_summer_art_class($summer_class_levels_id,$week){
	 $array = array();

//echo "SELECT summer_art_classes_id,summer_art_class FROM summer_art_classes WHERE summer_week='".$week ."'  and year='2018' group by summer_art_class ,summer_class_levels_id ";
 if ($summer_class_levels_id==8){
 $query = tep_db_query("SELECT summer_art_classes_id,summer_art_class FROM summer_art_classes WHERE summer_week='".$week ."'  and year='2018' group by summer_art_classes_id,summer_art_class");
 }else{
 $query = tep_db_query("SELECT summer_art_classes_id,summer_art_class FROM summer_art_classes WHERE summer_class_levels_id ='".$summer_class_levels_id ."' and summer_week='".$week ."'  and year='2018' group by summer_art_classes_id,summer_art_class");
 }    while ($info = tep_db_fetch_array($query)) {
        $array[] = array('summer_art_classes_id' => $info['summer_art_classes_id'],
						'summer_art_class' => $info['summer_art_class'],
						);
      }
    return $array;
		 }
function tep_get_day_in_week($summer_day_id){

	

      $query = tep_db_query("SELECT summer_week FROM `summer_weeks_days` WHERE summer_day_id=".$summer_day_id);

     $info = tep_db_fetch_array($query) 	;

      $summer_week =$info['summer_week'];

	      return $summer_week;

		 }	 

//function tep_get_summer_camp_tuition($week,$days_in_week,$summer_programs,$summer_sports,$summer_art_classes,$lunch=0,$lunch_day=0){
//function tep_get_summer_camp_tuition($week,$days_in_week,$summer_programs,$summer_class_levels_id){
//function tep_get_summer_camp_tuition($week,$days_in_week,$summer_programs,$summer_sports,$summer_art_classes,$summer_class_levels_id)


function tep_get_summer_camp_tuition2018($week,$days_in_week,$summer_sports,$summer_art_classes,$language,$summer_class_levels_id,$lunch){
	//lunch cost
	//if ($lunch!="")
	//$lunch=1;
$tuition=0;
	/*if($summer_class_levels_id==1){
	$dailyLunch=4;
	$weeklyLunch=20;
	}
	if($summer_class_levels_id>=2){
	$dailyLunch=5;
	$weeklyLunch=25;
	}
	*/
	//check programs
	//if morning, afternoon camp and aftercamp classes are selected => full
	if($summer_sports!=""&&$summer_art_classes!=""&&$language!="")
	$summer_programs=1;
	//if morning, afternoon camp  are selected or afternoon camp and aftercamp classes are selected=> short
	elseif(($summer_sports!=""&&$summer_art_classes!=""&&$language=="")||($summer_sports==""&&$summer_art_classes!=""&&$language!=""))
	$summer_programs=2;

	//if morning camp  or afternoon camp or aftercamp classes is selected=> half
	elseif($summer_sports!=""||$summer_art_classes!=""||$language!="")
     $summer_programs=4;
//	 echo $summer_sports."---".is_morning_addon($summer_sports)."--".$summer_art_classes."---".is_afternoon_addon($summer_art_classes)."*";
	 	 if (is_morning_addon($summer_sports)==1 && is_afternoon_addon($summer_art_classes)==1)
	   $summer_programs=1;

	if ($days_in_week<5){         
         
          $query = tep_db_query("SELECT `daily_cost` FROM `summer_program_tuition` WHERE `summer_programs_id`='".$summer_programs."' and summer_class_levels_id='".$summer_class_levels_id."'");
          $info = tep_db_fetch_array($query) 	;
	  $daily_tuition = $info['daily_cost'];
	 // $daily_tuition = tep_get_summer_daily_tuition($summer_programs);
	 $lunchCost=$dailyLunch*$days_in_week;
	   $tuition=$daily_tuition*$days_in_week+$lunchCost*$lunch;


if ($week==3 && $days_in_week==4){
      if ($summer_programs==4||$summer_programs==5||$summer_programs==6){
 $tuition= $tuition-20;
}
}

	}
		
		
	if ($days_in_week==5){
              //calculate regular
			// echo "SELECT `weekly_cost`  FROM `summer_program_tuition` WHERE `summer_programs_id`='".$summer_programs."' and summer_class_levels_id='".$summer_class_levels_id."'";
            $query = tep_db_query("SELECT `weekly_cost`  FROM `summer_program_tuition` WHERE `summer_programs_id`='".$summer_programs."' and summer_class_levels_id='".$summer_class_levels_id."'");
			$info = tep_db_fetch_array($query) 	;
			 $tuition=$info['weekly_cost']; 
			
            //calculate addon

            $query = tep_db_query("SELECT `morning_addon_full`,`morning_addon_short`,`morning_addon_half` FROM `summer_sports` WHERE (`morning_addon_full`>0 or `morning_addon_short`>0 or `morning_addon_half`>0) and `summer_sports_id`='".$summer_sports."'");
			$info = tep_db_fetch_array($query) 	;
			 //$morning_addon_full=$info['morning_addon_full']; 
			// $morning_addon_short=$info['morning_addon_short']; 
			// $morning_addon_half=$info['morning_addon_half'];
			$morning_addon=$info['morning_addon_full']; 
			 $morning_addon=$info['morning_addon_short']; 
			 $morning_addon=$info['morning_addon_half']; 
			 
		/*	if ($summer_programs==1)
               $tuition=$tuition+$morning_addon_full;
          if ($summer_programs==2||$summer_programs==3)
              $tuition=$tuition+$morning_addon_short;
          if ($summer_programs==4||$summer_programs==5||$summer_programs==6)
              $tuition=$tuition+$morning_addon_half;
*/
              $query = tep_db_query("SELECT `afternoon_addon_all`,`afternoon_addon_full`,`afternoon_addon_short`,`afternoon_addon_half` FROM `summer_art_classes` WHERE (`afternoon_addon_full`>0 or `afternoon_addon_short`>0 or`afternoon_addon_half`>0) 
and `summer_art_classes_id`='".$summer_art_classes."'");
			$info = tep_db_fetch_array($query) 	;
			 //$afternoon_addon_full=$info['afternoon_addon_full']; 
			 //$afternoon_addon_short=$info['afternoon_addon_short']; 
			// $afternoon_addon_half=$info['afternoon_addon_half'];
			$afternoon_addon=$info['afternoon_addon_full']; 
			$afternoon_addon=$info['afternoon_addon_short']; 
			$afternoon_addon=$info['afternoon_addon_half']; 
		
		/*
		if ($summer_programs==1)
               $tuition=$tuition+$morning_addon+$afternoon_addon;
          if ($summer_programs==2||$summer_programs==3)
              $tuition=$tuition+$morning_addon+$afternoon_addon;
          if ($summer_programs==4||$summer_programs==5||$summer_programs==6)
              $tuition=$tuition;
		 */ 
		  
		  	if ($summer_programs==1){
			if((is_morning_addon($summer_sports)==1&&is_afternoon_addon($summer_art_classes)==1))
			 $tuition=$tuition+$morning_addon+$afternoon_addon; 
			else if((is_morning_addon($summer_sports)==1||is_afternoon_addon($summer_art_classes)==1))
			$tuition=$tuition+$morning_addon+$afternoon_addon; 	
			else{}
		}
	
             
          if ($summer_programs==2||$summer_programs==3){
		  if((is_morning_addon($summer_sports)==1&&is_afternoon_addon($summer_art_classes)==1))
				$tuition=$tuition+$morning_addon+$afternoon_addon; 
			else if((is_morning_addon($summer_sports)==1||is_afternoon_addon($summer_art_classes)==1))
			$tuition=$tuition+$morning_addon+$afternoon_addon; 
			else{}
		  }
          if ($summer_programs==4||$summer_programs==5||$summer_programs==6){
			  $g="";
			  if($summer_art_classes!="")
			   $g= tep_get_summer_art_class_name($summer_art_classes );
			  if((is_morning_addon($summer_sports)==1||is_afternoon_addon($summer_art_classes)==1)&&$g=="Rhythmic Gymnastics*")
			$tuition=$tuition+$morning_addon+$afternoon_addon;
				if((is_morning_addon($summer_sports)==1||is_afternoon_addon($summer_art_classes)==1)&&$g!="Rhythmic Gymnastics*")
				$tuition=285;
          }
		  
/*

		if ($summer_programs==1){
			if((is_morning_addon($summer_sports)==1&&is_afternoon_addon($summer_art_classes)==1))
			 $tuition=$tuition+225; 
			else if((is_morning_addon($summer_sports)==1||is_afternoon_addon($summer_art_classes)==1))
			$tuition=$tuition+225; 	
			else{}
		}
              
          if ($summer_programs==2||$summer_programs==3){
		  if((is_morning_addon($summer_sports)==1&&is_afternoon_addon($summer_art_classes)==1))
				$tuition=$tuition+225; 
			else if((is_morning_addon($summer_sports)==1||is_afternoon_addon($summer_art_classes)==1))
			$tuition=$tuition+225; 
			else{}
		  }
          if ($summer_programs==4||$summer_programs==5||$summer_programs==6){
			  if((is_morning_addon($summer_sports)==1||is_afternoon_addon($summer_art_classes)==1))
			$tuition=285;
          }
*/		
		 // $today = date("m-d-y");   
		//if(($today < date( "Y-m-d", strtotime("04-25-16")))&&$summer_programs==1){
	  //	$tuition =$tuition*.95;
		
		// }
		  
		   $tuition=$tuition+$weeklyLunch*$lunch;
	}
	/*if($lunch==20)
	$lunch_day=1;
    $tuition =$tuition +$lunch*$lunch_day;*/
   //check if sibling discount applies, 5%
   //1. check if another kid in the same family exists in enrollments where classes_id=11 or 12
   
   //2. compare two tuition, apply 5% to lower one
   
   //apply 5% early reg  before apr 12 execpt lego only
  
  	
	      return $tuition;
		 }
	
 function add_summer_enrollment_schedule($enrollments_id, $summer_week,$summer_day_id,$summer_class_levels_id) {

			tep_db_query("insert into summer_enrollments_schedules (enrollments_id, summer_week, summer_day_id,summer_class_levels_id) values ( '" . tep_db_input($enrollments_id) . "', '" . $summer_week .   "', '".$summer_day_id .   "', '".$summer_class_levels_id .   "')");

    } 


	

	
function update_tuition_total($enrollments_id){	 
	$query = tep_db_query("SELECT orders_id FROM   orders_enrollments  WHERE  enrollments_id=".$enrollments_id);
     $info = tep_db_fetch_array($query) 	;
	 $orders_id=$info['orders_id'];
	$query = tep_db_query("SELECT sum(tuition) as s FROM `orders_enrollments`, orders, enrollments WHERE enrollments.enrollments_id=orders_enrollments.enrollments_id and orders_enrollments.orders_id=orders.orders_id and orders.orders_id=".$orders_id);
     $info = tep_db_fetch_array($query) 	;
	 $tuition=$info['s'];
	 tep_db_query("update orders set total=".$tuition." where orders_id=".$orders_id);
	}

  function tep_get_summer_art_class_name($summer_art_classes_id ){
 
	 $info = tep_db_fetch_array (tep_db_query("SELECT * FROM summer_art_classes WHERE summer_art_classes_id  =".$summer_art_classes_id ));

	  return $info['summer_art_class'];

	  }

	  
	function tep_get_summer_art_class_box($summer_class_levels_id,$week){
 
	 $array = array();
	 $query = tep_db_query("SELECT summer_art_classes_id,summer_art_class FROM summer_art_classes WHERE summer_class_levels_id ='".$summer_class_levels_id ."' and summer_week='".$week ."' group by summer_art_classes_id,summer_art_class");
      while ($info = tep_db_fetch_array($query)) {
        $array[] = array('summer_art_classes_id' => $info['summer_art_classes_id'],
						'summer_art_class' => $info['summer_art_class']
						);
      }
	//  print_r($array);
    return $array;

	  }
	  
	 
  function tep_get_students() {
    $family_students_array = array();
      $family_students = tep_db_query("select * from   students  where  students_status ='Active' order by students_last_name");

      while ($family_students_values = tep_db_fetch_array($family_students)) {

        $family_students_array[] = array('families_id' => $family_students_values['families_id'],
										'students_first_name' => $family_students_values['students_first_name'],
										'students_last_name' => $family_students_values['students_last_name'],
									   'students_id' => $family_students_values['students_id']);
      }
    return $family_students_array;
  }
  
  

	
  //get customer first name

    function tep_get_customer($students_id){

	 $info = tep_db_fetch_array (tep_db_query("SELECT customers_id FROM `students`, customers WHERE students.families_id=customers.families_id and students_id='".$students_id ."'"));

	  return $info['customers_id'];

	  }
	  		//check registration fee paid

	function check_student_registration_fee_paid($students_id){

		

		$query=tep_db_query("SELECT registration_fee_paid FROM students where students_id='".$students_id ."'");

		$info= tep_db_fetch_array ($query);

		 $flag=$info['registration_fee_paid'];	

		
		return $flag;

		}
 function tep_get_summer_language_class($summer_class_level_id, $language){
	
      $query = tep_db_query("select* from summer_class_levels where summer_class_level_id='".$summer_class_level_id."'");

       $info = tep_db_fetch_array($query) 	;
       if($language=="ch")
	 $summer_language_class=$info['summer_chinese_classes'];
       if($language=="sp")
	 $summer_language_class=$info['summer_spanish_classes'];
    return $summer_language_class;
		 }
  function tep_get_summer_days($year){
	 $array = array();
	 $d=$year.'-01-01';
      $query = tep_db_query("select* from summer_weeks_days where  summer_date >'".$d."'");
      while ($info = tep_db_fetch_array($query)) {
        $array[] = array('summer_day_id' => $info['summer_day_id'],
						'summer_date' => $info['summer_date'],
						'summer_day' => $info['summer_day'],
						'summer_week' => $info['summer_week'],
						'status' => $info['status']
						);
      }
	 
    return $array;
		 }
		 
		  function tep_get_summer_week_days($year,$summer_week){
	 $array = array();
	 $d=$year.'-01-01';
	 //echo "select* from summer_weeks_days where  summer_date >'".$d."' and summer_week=".$summer_week;
      $query = tep_db_query("select* from summer_weeks_days where  summer_date >'".$d."' and summer_week=".$summer_week);
      while ($info = tep_db_fetch_array($query)) {
        $array[] = array('summer_day_id' => $info['summer_day_id'],
						'summer_date' => $info['summer_date'],
						'summer_day' => $info['summer_day'],
						'status' => $info['status']
						);
      }
	 
    return $array;
		 }
		 
		  function tep_get_summer_week_day_id($year,$summer_week,$summer_day){
	 $array = array();
	 $d=$year.'-01-01';
	
      $query = tep_db_query("select* from summer_weeks_days where  summer_date >'".$d."' and summer_week=".$summer_week." and summer_day='".$summer_day."'");
      while ($info = tep_db_fetch_array($query)) {
        $array[] = array('summer_day_id' => $info['summer_day_id'],
						'summer_date' => $info['summer_date'],
						'status' => $info['status']
						);
      }
	 
    return $array;
		 }
		 	 function tep_get_summer_sports_name($summer_sports_id){
	 
	 // "select* from summer_sports where summer_sports_id='".$summer_sports_id."' ";
	
$query = tep_db_query("select* from summer_sports where summer_sports_id='".$summer_sports_id."' ");

      $info = tep_db_fetch_array($query);
      
    return $info['summer_sport'];
		 }

		 
		 function tep_get_family_contact_phone($families_id){
   $s="";
	// $array = array();
	 $query = tep_db_query("SELECT * FROM contacts WHERE families_id='".$families_id."' and (contact_type='Primary' or contact_type='Secondary')");
      
      while ($info = tep_db_fetch_array($query)) {
        //$array[] = array('contacts_cell_phone' => $info['contacts_cell_phone'],'summer_art_class' => $info['summer_art_class']);
        $s .=$info['contacts_cell_phone'].", ";
      }
	//  print_r($array);
    return $s;

	  }
	  	 function tep_get_family_contact_email($families_id){
   $s="";
	// $array = array();
	 $query = tep_db_query("SELECT * FROM contacts WHERE families_id='".$families_id."' and (contact_type='Primary' or contact_type='Secondary')");
      
      while ($info = tep_db_fetch_array($query)) {
        //$array[] = array('contacts_cell_phone' => $info['contacts_cell_phone'],'summer_art_class' => $info['summer_art_class']);
        $s .=$info['contacts_email']." , ";
      }
	//  print_r($array);
    return $s;

	  }
	  
/*	 function tep_get_classes($classes_id){
 
	 $array = array();
	 $query = tep_db_query("SELECT * FROM classes WHERE classes_id ='".$classes_id ."'");
      while ($info = tep_db_fetch_array($query)) {
        $array[] = array('classes_id' => $info['classes_id'],
						'classes_name' => $info['classes_name'],
						'classes_description' => $info['classes_description'],
						'classes_start_date' => $info['classes_start_date'],
						'classes_end_date' => $info['classes_end_date'],
						'min_capacity' => $info['min_capacity'],
						'max_capacity' => $info['max_capacity']
						);
      }
	//  print_r($array);
    return $array;

	  }*/
	 function tep_get_day_school_info($day_schools_id) {
    $day_schools_array = array();
      $day_schools = tep_db_query("select * from day_schools  where day_schools_id='".$day_schools_id."'");
     while($info =  tep_db_fetch_array($day_schools)){
	   $array[] = array('day_schools_id' => $info['day_schools_id'],
						'day_schools_name' => $info['day_schools_name'],
						'schools_short_day' => $info['schools_short_day'],
						'short_day_charge' => $info['short_day_charge']
						);
	 }
      return $array;
  }  
  
   function tep_get_daily_tuition($daily_tuition_name){

	 $info = tep_db_fetch_array (tep_db_query("SELECT daily_tuition FROM daily_tuition WHERE daily_tuition_name ='".$daily_tuition_name ."'"));

	  return $info['daily_tuition'];

	  }

	    //daily_school_tuition

    function tep_get_daily_school_tuition($day_schools_id, $d){

	 $info = tep_db_fetch_array (tep_db_query("SELECT daily_tuition FROM daily_school_tuition WHERE day_schools_id='".$day_schools_id."' and date='".$d."'"));

	  return $info['daily_tuition'];

	  }
	  
	    function add_schedule($classes_id,$students_id,$schedule_types_id,$mds) {
			$stu_info=tep_get_student($students_id);
		 //$families_id=$stu_info[0]['families_id'];
		  $customer_id=tep_get_customer($students_id);
      // $customer_info=tep_get_family_customer($families_id);
		// $customer_id=$customer_info[0]['customers_id'];
	  $tuition=get_tuition($classes_id);
	  
	  
 tep_db_query("insert into enrollments(customers_id, classes_id,students_id,  enrollment_date,schedule_types_id,meeting_days,enrollments_status) values ('" . (int)$customer_id . "', '" . tep_db_input($classes_id) . "', '" . tep_db_input($students_id) . "',  '"  . date('Ymd') . "','". tep_db_input($schedule_types_id)."', '" . tep_db_input($mds) . "', 'Processing ')");
 return $enrollments_id = tep_db_insert_id();
    }
 function add_enrollment_schedule($enrollments_id, $meeting_date,$t) {
 tep_db_query("insert into enrollments_schedules (enrollments_id, schedules_date,daily_tuition) values ( '" . tep_db_input($enrollments_id) . "', '" . $meeting_date .   "', '".$t ."')");
    }
	function get_tuition($classes_id){

		  $check_query = tep_db_query("select tuition from classes where classes_id = '" . $classes_id . "'");

    	 $check = tep_db_fetch_array($check_query);

		 return $check['tuition'];

		}
			
  
    function tep_get_family_customer($families_id){

	 $array = array();

      $query = tep_db_query("select * from customers where families_id=".$families_id);

      while ($info = tep_db_fetch_array($query)) {

        $array[] = array('customers_id' => $info['customers_id'],

						'customers_firstname' => $info['customers_firstname'],

						'customers_lastname' => $info['customers_lastname'],
						
						'customers_email_address' => $info['customers_email_address']

						);

      }

    return $array;

	}
	
	
    function tep_get_enrollment_schedule($enrollments_id){

	 $array = array();

      $query = tep_db_query("select * from enrollments, enrollments_schedules  where enrollments.enrollments_id=enrollments_schedules.enrollments_id and enrollments.enrollments_id=".$enrollments_id);

      while ($info = tep_db_fetch_array($query)) {

        $array[] = array('enrollments_id' => $info['enrollments_id'],

						'schedules_date' => $info['schedules_date'],

						'daily_tuition' => $info['daily_tuition'],
						'students_id' => $info['students_id'],
						'customers_id' => $info['customers_id'],
						'tuition' => $info['tuition'],
 						'enrollments_status' => $info['enrollments_status'],
						'meeting_days' => $info['meeting_days'],						
						'classes_id' => $info['classes_id']

						);

      }

    return $array;

	}
	    function tep_get_orders_enrollments($enrollments_id){

	 $array = array();

      $query = tep_db_query("SELECT * FROM orders_enrollments, orders WHERE orders_enrollments.orders_id=orders.orders_id and orders_enrollments.enrollments_id=".$enrollments_id);

      while ($info = tep_db_fetch_array($query)) {

        $array[] = array('enrollments_id' => $info['enrollments_id'],

						'orders_id' => $info['orders_id'],

						'tuition_paid' => $info['tuition_paid'],
						'payment_method' => $info['payment_method'],
						'customers_id' => $info['customers_id'],
						'date_purchased' => $info['date_purchased'],
 						'orders_status' => $info['orders_status'],
						'total' => $info['total'],	
						'tuition_total' => $info['tuition_total'],
                        'lunch_total' => $info['lunch_total'],
						'registration_fee' => $info['registration_fee'],
						'material_fee_total' => $info['material_fee_total'],				
						'classes_id' => $info['classes_id']

						);

      }

    return $array;

	}

	function check_material_fee($students_id){
 
	    $query = tep_db_query("SELECT material_fee_paid FROM `students_material_fee` where `students_id`='".$students_id."'");
	 $info = tep_db_fetch_array($query) 	;
	 $fee=$info['material_fee_paid'];
	 if ($info!="")
     return $fee;
	 else
	 return 0;		

	}
				//check registration fee paid

	function check_student_status($students_id){

		"SELECT students_status FROM students where students_id='".$students_id ."'";

		$query=tep_db_query("SELECT students_status FROM students where students_id='".$students_id ."'");

		$info= tep_db_fetch_array ($query);

		 $flag=$info['students_status'];	

		
		return $flag;

		}
		function tep_get_summer_weekly_lunch($days_in_week,$summer_class_levels_id,$lunch){
	//lunch cost
	if ($lunch!="")
	$lunch=1;
	if($summer_class_levels_id==1){
	$dailyLunch=4;
	$weeklyLunch=20;
	}
	if($summer_class_levels_id>=2){
	$dailyLunch=5;
	$weeklyLunch=25;
	}
	
	if ($days_in_week<5){    
         
	 $lunchCost=$dailyLunch*$days_in_week;

	}
	if ($days_in_week==5){
             
			 $lunchCost=$weeklyLunch;
		
	}
	return $lunchCost;
	
}

function get_current_year_customers_enrollments($customer_id,$year=''){

	//$year=date('Y');

$start_date=$year.'-01-01';
	$start_date=date('Y-m-d',strtotime($start_date));
	$end_date=$year.'-12-31';
	$end_date=date('Y-m-d',strtotime($end_date));


 $sql="SELECT enrollments.enrollments_id,  enrollments_status,enrollments.tuition, tuition_paid, meeting_days, students_first_name, 
students_last_name,  orders_status, orders.total,enrollments.total as etotal, enrollments.locations_id

FROM enrollments, customers, students, families, orders,  orders_enrollments

WHERE enrollments.students_id = students.students_id 

AND enrollments.customers_id = customers.customers_id 

AND families.families_id = students.families_id 

AND customers.customers_id=orders.customers_id 

AND orders_enrollments.enrollments_id=enrollments.enrollments_id

AND orders.orders_id=orders_enrollments.orders_id
and enrollments_status='Accepted'

and (enrollment_date>='".$start_date."' and enrollment_date<='".$end_date."')

AND (orders_status='Card Payment Completed' or orders_status='Check Received') 

AND orders.date_purchased <='".$end_date."'
AND orders.date_purchased >='".$start_date."'

AND enrollments.customers_id = '" . $customer_id . "' 

group by enrollments.enrollments_id,  enrollments_status,enrollments.tuition, tuition_paid, meeting_days, students_first_name, 
students_last_name,  orders_status, orders.total,enrollments.total, enrollments.locations_id ";

	$enrollment_query = tep_db_query($sql);

   $row= tep_db_num_rows($enrollment_query);     

    



while ($enrollment_info = tep_db_fetch_array($enrollment_query)) {

        $enrollment_array[] = array( 'enrollments_id'=> $enrollment_info['enrollments_id'],

										'enrollments_status' => $enrollment_info['enrollments_status'],

										'tuition' => $enrollment_info['tuition'],
										'total' => $enrollment_info['total'],
										'etotal' => $enrollment_info['etotal'],
										'locations_id' => $enrollment_info['locations_id'],

										'meeting_days' => $enrollment_info['meeting_days'],

										'day_schools_name' => $enrollment_info['day_schools_name'],

										'students_first_name' => $enrollment_info['students_first_name'],
										'tuition_paid'=>$enrollment_info['tuition_paid'],
										'students_last_name' => $enrollment_info['students_last_name'],
										);
      }
return $enrollment_array;	

	}

 
		 function tep_check_full_week_full_day($week,$days_in_week,$summer_sports,$summer_art_classes,$language){
	//check programs
	//if morning, afternoon camp and aftercamp classes are selected => full
	if($summer_sports!=""&&$summer_art_classes!=""&&$language!="")
	 $summer_programs=1;
	//if morning, afternoon camp  are selected or afternoon camp and aftercamp classes are selected=> short
	elseif(($summer_sports!=""&&$summer_art_classes!=""&&$language=="")||($summer_sports==""&&$summer_art_classes!=""&&$language!=""))
	$summer_programs=2;
	//if morning camp  or afternoon camp or aftercamp classes is selected=> half
	elseif($summer_sports!=""||$summer_art_classes!=""||$language!="")
     $summer_programs=4;
	 
	 	 if (is_morning_addon($summer_sports)==1 && is_afternoon_addon($summer_art_classes)==1)
	  $summer_programs=1;
  return $summer_programs;
		 }
function add_summer_enrollment_schedule_lunch_pickup($enrollments_id, $summer_week,$summer_day_id,$summer_class_levels_id,$lunch_ordered,$summer_pickup_locations_id) {
			tep_db_query("insert into summer_enrollments_schedules (enrollments_id, summer_week, summer_day_id,summer_class_levels_id,lunch_ordered,summer_pickup_locations_id) 
			values ( '" . tep_db_input($enrollments_id) . "', '" . $summer_week .   "', '".$summer_day_id .   "', '".$summer_class_levels_id . "', '".$lunch_ordered .   "', '".$summer_pickup_locations_id .  "')");
    } 


	 function add_summer_schedule($customers_id,$classes_id,$students_id,$mds,$tuition,$lunchTotal,$material_fee,$schedule_types_id,$total,$summer_pickup_locations_id,$discount,$sibling_discount,$registration_fee) {

    
	
if ($lunchTotal>0) 
               $order_all_lunches='Y';
          else
                 $order_all_lunches='N';

				tep_db_query("insert into enrollments(customers_id, classes_id,students_id, tuition,lunch_total,material_fee, enrollment_date,meeting_days,schedule_types_id,enrollments_status,total,order_all_lunches,summer_pickup_locations_id,discount,sibling_discount,registration_fee) 
				values ('" . (int)$customers_id . "', '" . tep_db_input($classes_id) . "', '" . tep_db_input($students_id) . "',  
				'" . tep_db_input($tuition) . "','" . tep_db_input($lunchTotal) . "','" . tep_db_input($material_fee) . "',
				
				'" . date('Ymd') . "', '" . tep_db_input($mds) . "', '" . tep_db_input($schedule_types_id) . "','Processing', 
				'" . tep_db_input($total) . "', '" . tep_db_input($order_all_lunches) . "', '" . tep_db_input($summer_pickup_locations_id) . "', 
				'" . tep_db_input($discount) . "','" . tep_db_input($sibling_discount) . "','" . tep_db_input($registration_fee) . "')");


 return $enrollments_id = tep_db_insert_id();

    }
	
/*function add_summer_enrollment($enrollments_id,$week,$days_in_week,$summer_programs_id,$summer_class_levels_id,$summer_sports_id,$summer_art_classes_id,$summer_language_class,
$summer_enrollments_weekly_total,$lunch)
 {
     
 $weekly_tuition=$summer_enrollments_weekly_total-$lunch;
	 if (tep_session_is_registered('customer_id')) 
$summer_noon_classes="Noon".$summer_class_levels_id;
	 tep_db_query("insert into summer_enrollments(enrollments_id,summer_week,days_in_week,summer_programs_id, summer_class_levels_id, summer_sports_id,summer_noon_classes,
	 summer_art_classes_id,summer_language_class,summer_enrollments_weekly_total,lunch,weekly_tuition) 
	 values ('" . (int)$enrollments_id . "', '" . tep_db_input($week) . "', '" . tep_db_input($days_in_week) . "', '" . tep_db_input($summer_programs_id) . "', 
	 '" . tep_db_input($summer_class_levels_id) . "', '" . tep_db_input($summer_sports_id) . "', '" . tep_db_input($summer_noon_classes) . "', 
	 '" . tep_db_input($summer_art_classes_id) . "','" . tep_db_input($summer_language_class) . "',   '" . tep_db_input($summer_enrollments_weekly_total) . "',  
	 '" . tep_db_input($lunch) . "',   '" . tep_db_input($weekly_tuition) . "')");

		

 return $enrollments_id = tep_db_insert_id();

    }	
	*/
function add_summer_enrollment($enrollments_id,$week,$days_in_week,$summer_programs_id,$summer_class_levels_id,$summer_sports_id,$summer_art_classes_id,$summer_language_class,
$summer_enrollments_weekly_total,$lunch,$aftercamp1,$aftercamp2,$aftercamp3)
 {
      global  $customer_id;
 $weekly_tuition=$summer_enrollments_weekly_total-$lunch;
	 if (tep_session_is_registered('customer_id')) 
$summer_noon_classes="Noon".$summer_class_levels_id;
	 tep_db_query("insert into summer_enrollments(enrollments_id,summer_week,days_in_week,summer_programs_id, summer_class_levels_id, summer_sports_id,summer_noon_classes,
	 summer_art_classes_id,summer_language_class,summer_enrollments_weekly_total,lunch,weekly_tuition,aftercamp1,aftercamp2,aftercamp3) 
	 values ('" . (int)$enrollments_id . "', '" . tep_db_input($week) . "', '" . tep_db_input($days_in_week) . "', '" . tep_db_input($summer_programs_id) . "', 
	 '" . tep_db_input($summer_class_levels_id) . "', '" . tep_db_input($summer_sports_id) . "', '" . tep_db_input($summer_noon_classes) . "', 
	 '" . tep_db_input($summer_art_classes_id) . "','" . tep_db_input($summer_language_class) . "',   '" . tep_db_input($summer_enrollments_weekly_total) . "',  
	 '" . tep_db_input($lunch) . "',   '" . tep_db_input($weekly_tuition) . "',   '" . tep_db_input($aftercamp1) . "',   '" . tep_db_input($aftercamp2) . "',   
	 '" . tep_db_input($aftercamp3) . "')");

		

 return $enrollments_id = tep_db_insert_id();

    }	

	
	function tep_get_summer_enrollments_orders($enrollments_id){

	 $array = array();

$current_year_first_day=date('Y-m-d', strtotime('first day of january this year'));
      $query = tep_db_query("select orders.orders_id from enrollments, orders, orders_enrollments 
	  where enrollments.enrollments_id=orders_enrollments.enrollments_id
		and orders_enrollments.orders_id=orders.orders_id
		and enrollment_date >'".$current_year_first_day."' and enrollments.enrollments_id=".$enrollments_id);

     $info= tep_db_fetch_array ($query);

		 $orders_id=$info['orders_id'];	

		
		return $orders_id;

	}
function tep_get_summer_enrollments_orders_payments($orders_id){
		
 $array = array();
    
      $query = tep_db_query("SELECT * 
FROM orders_payments
WHERE orders_id =".$orders_id);

      while ($info = tep_db_fetch_array($query)) {
$orders_payments_notes=$orders_payments_info['orders_payments_notes'];			$transaction_id=$orders_payments_info['transaction_id'];				$auth_code=$orders_payments_info['auth_code'];				$response_message=$orders_payments_info['response_message'];
        $array[] = array(
						'orders_id' => $info['orders_id'],						'payment_amount' => $info['payment_amount'],						'transaction_id' => $info['transaction_id'],						'auth_code' => $info['auth_code'],
						'response_message' => $info['response_message'],
						'payment_method' => $info['payment_method'],
						'payment_date' => $info['payment_date'],
						'check_number' => $info['check_number'],						'orders_payments_notes'=>$info['orders_payments_notes']
						);

      }

    return $array;
	}
	
	

	function tep_get_summer_enrollments_orders_refunds($orders_id){
	
 $array = array();
    
      $query = tep_db_query("SELECT * 
FROM orders_refunds
WHERE orders_id =".$orders_id);

      while ($info = tep_db_fetch_array($query)) {

        $array[] = array(
						'orders_id' => $info['orders_id'],
						'refund_amount' => $info['refund_amount'],
						'refund_method' => $info['refund_method'],
						'refund_date' => $info['refund_date'],
						'transaction_id' => $info['transaction_id'],
						'refund_check_number' => $info['refund_check_number']

						);

      }

    return $array;
	}


function get_current_year_enrollment($enrollments_id){

 $array = array();


      $query = tep_db_query("select * from enrollments, orders, orders_enrollments 
	  where enrollments.enrollments_id=orders_enrollments.enrollments_id
		and orders_enrollments.orders_id=orders.orders_id
		and enrollment_date >'2018-01-01' and enrollments.enrollments_id=".$enrollments_id);

while ($info = tep_db_fetch_array($query)) {

        $array[] = array(
						
						'classes_id' => $info['classes_id'],
						'total' => $info['total']

						);

      }

		
		 return $array;

}
function tep_get_pickup_location($summer_pickup_locations_id){
      $query = tep_db_query("SELECT * FROM `summer_pickup_locations` WHERE summer_pickup_locations_id=".$summer_pickup_locations_id);
     $info = tep_db_fetch_array($query) 	;
	      return  $info['summer_pickup_locations'];
		 }
function tep_get_summer_morning_classroom($summer_sports_id){
      $query = tep_db_query("SELECT * FROM `summer_room_assignments` WHERE summer_sports_id=".$summer_sports_id);
     $info = tep_db_fetch_array($query) 	;
	      return  $info['room'];
		 }
function tep_get_summer_afternoon_classroom($summer_art_classes_id){
      $query = tep_db_query("SELECT * FROM `summer_room_assignments` WHERE summer_art_classes_id=".$summer_art_classes_id);
     $info = tep_db_fetch_array($query) 	;
	      return  $info['room'];
		 }
function tep_get_customer_info($customers_id){     $array = array();     
 $query = tep_db_query("SELECT * FROM `customers` WHERE customers_id=".$customers_id);
 while ($info = tep_db_fetch_array($query)) {        
 $array[] = array(											
 'customers_firstname' => $info['customers_firstname'],						
 'customers_lastname' => $info['customers_lastname'],						
 'customers_email_address' => $info['customers_email_address'],					
 'families_id' => $info['families_id']				
 );     
 }		
 return $array;		
 }

function tep_get_summer_family_enrollments_total($customers_id, $year){	   
$start_date=$year.'-01-01';
	$start_date=date('Y-m-d',strtotime($start_date));
	$end_date=$year.'-12-31';
	$end_date=date('Y-m-d',strtotime($end_date));
  
		
		 $sql="SELECT enrollments.enrollments_id,enrollments.tuition,enrollments.lunch_total, enrollments.registration_fee,enrollments.discount,
enrollments.total, enrollments.material_fee, 	 students_first_name, students_last_name, sibling_discount
FROM enrollments,   customers, families, students
WHERE 
 enrollments.customers_id = customers.customers_id
AND enrollments.students_id = students.students_id
AND families.families_id = customers.families_id
AND families.families_id = students.families_id 
and (enrollments_status='Accepted')
and enrollment_date  <='".$end_date."'
AND enrollment_date >='".$start_date."'
and enrollments.customers_id=".$customers_id;

		$result=tep_db_query($sql);	
$enrollment_total=0;		
					while($row=tep_db_fetch_array($result))
			{$enrollment_total+=$row['total'];}
		return $enrollment_total;
	}



	function tep_get_summer_family_payments_total($customers_id,$year){	
	$start_date=$year.'-01-01';
	$start_date=date('Y-m-d',strtotime($start_date));
	$end_date=$year.'-12-31';
	$end_date=date('Y-m-d',strtotime($end_date));
	$sql1="SELECT payment_date, payment_amount, orders_payments.payment_method, transaction_id, orders_payments.check_number,orders_payments.orders_id
FROM orders, customers, orders_payments
WHERE orders.customers_id = customers.customers_id
AND orders_payments.orders_id = orders.orders_id

and payment_date  <='".$end_date."'
AND payment_date >='".$start_date."'
AND (
orders_status = 'Card Payment Completed'
OR orders_status = 'Check Received'
)
AND orders.customers_id =".$customers_id."
order by payment_date
";
		$result1=tep_db_query($sql1);
		
$payment_total=0;		
					while($row1=tep_db_fetch_array($result1))
			{  
			 $payment_total+= $row1['payment_amount'];}
			
			return $payment_total;
	}
	
	function tep_get_summer_family_refunds_total($customers_id,$year){	
		$start_date=$year.'-01-01';
	$start_date=date('Y-m-d',strtotime($start_date));
	$end_date=$year.'-12-31';
	$end_date=date('Y-m-d',strtotime($end_date));
	
		 $sql2="SELECT orders_refunds_id,refund_amount
FROM orders,customers, orders_refunds
WHERE orders.customers_id = customers.customers_id
AND orders.orders_id = orders_refunds.orders_id
and `refund_date` >'".$start_date."'
AND orders.customers_id =".$customers_id;
	
$result2=tep_db_query($sql2);	
$refund_total=0;	
			while($row2=tep_db_fetch_array($result2))
			{
			$refund_total+=$row2['refund_amount'];			
			}
			
			return $refund_total;
	}
	

	function tep_get_summer_family_refunds($customers_id,$year){	
		$start_date=$year.'-01-01';
	$start_date=date('Y-m-d',strtotime($start_date));
	$end_date=$year.'-12-31';
	$end_date=date('Y-m-d',strtotime($end_date));
	 $array = array();
		 $sql="SELECT *
		FROM orders,customers, orders_refunds
		WHERE orders.customers_id = customers.customers_id
		AND orders.orders_id = orders_refunds.orders_id
		and `refund_date` >'".$start_date."'
		AND orders.customers_id =".$customers_id;			

       $query = tep_db_query($sql);

      while ($info = tep_db_fetch_array($query)) {
        $array[] = array('orders_id' => $info['orders_id'],
						'orders_refunds_id' => $info['orders_refunds_id'],
						'refund_date' => $info['refund_date'],
						'refund_amount' => $info['refund_amount'],
						'refund_method' => $info['refund_method'],
						'refund_check_number' => $info['refund_check_number'],
						'transaction_id' => $info['transaction_id'],
						'auth_code' => $info['auth_code']
						
						);
	}
	   return $array;
	}
	
	function tep_get_summer_family_cancellation_fee_total($customers_id,$year){	
	$start_date=$year.'-01-01';
	$start_date=date('Y-m-d',strtotime($start_date));
	$end_date=$year.'-12-31';
	$end_date=date('Y-m-d',strtotime($end_date));
	
	$sql2="SELECT cancellation_fee
FROM enrollments
WHERE 
 `enrollment_date` >'".$start_date."'
and enrollment_date  <='".$end_date."'
AND customers_id =".$customers_id;
	$result2=tep_db_query($sql2);	
$cancellation_fee_total=0;		
					while($row2=tep_db_fetch_array($result2))
			{
			$cancellation_fee_total+=$row2['cancellation_fee'];}
	
	return $cancellation_fee_total;
	}
	
	    function tep_get_morning_room_assingments($summer_sports_id,$sessions_id){

	 $array = array();
		$sql="SELECT * FROM summer_room_assignments, employees, rooms
	  WHERE summer_room_assignments.employees_id=employees.employees_id
	  and summer_room_assignments.rooms_id=rooms.rooms_id
	  and summer_sports_id='".$summer_sports_id."' and sessions_id='".$sessions_id."'";
      $query = tep_db_query($sql);

      while ($info = tep_db_fetch_array($query)) {

        $array[] = array('summer_room_assignments_id' => $info['summer_room_assignments_id'],

						'summer_week' => $info['summer_week'],

						'summer_sports' => $info['summer_sports'],
						'summer_language' => $info['summer_language'],
						'summer_art_classes_id' => $info['summer_art_classes_id'],
						'summer_class_levels_id' => $info['summer_class_levels_id'],
 						'employees_id' => $info['employees_id'],
						'rooms_id' => $info['rooms_id'],	
						'employees_first_name' => $info['employees_first_name'],
						 'employees_last_name' => $info['employees_last_name'],
						  'employees_full_name'=>$info['employees_first_name']." ".$info['employees_last_name'],
						'rooms_number' => $info['rooms_number'],
						'rooms_id' => $info['rooms_id'],
						'year' => $info['year'],
                       // 'lunch_total' => $info['lunch_total'],
						//'registration_fee' => $info['registration_fee'],
						//'material_fee_total' => $info['material_fee_total'],				
						'sessions_id' => $info['sessions_id'],
						//'classes_id' => $info['classes_id']
						);
      }

    return $array;

	}
	
 function tep_get_morning_room_assingments_by_class($summer_sports,$sessions_id,$locations_id,$year,$summer_week){

	 $array = array();
	 $sql="SELECT * FROM summer_room_assignments, employees, rooms
	  WHERE summer_room_assignments.employees_id=employees.employees_id
	  and summer_room_assignments.rooms_id=rooms.rooms_id
	  and summer_sports='".$summer_sports."' and sessions_id='".$sessions_id
	  ."' and year='".$year
	    ."' and summer_week='".$summer_week."'
		and summer_room_assignments.locations_id='".$locations_id."'
	  order by summer_room_assignments_id desc";


      $query = tep_db_query($sql);

      while ($info = tep_db_fetch_array($query)) {

        $array[] = array('summer_room_assignments_id' => $info['summer_room_assignments_id'],

						'summer_week' => $info['summer_week'],

						'summer_sports' => $info['summer_sports'],
						'summer_language' => $info['summer_language'],
						'summer_art_classes_id' => $info['summer_art_classes_id'],
						'summer_class_levels_id' => $info['summer_class_levels_id'],
 						'employees_id' => $info['employees_id'],
						'rooms_id' => $info['rooms_id'],	
						'employees_first_name' => $info['employees_first_name'],
						 'employees_last_name' => $info['employees_last_name'],
						  'employees_full_name'=>$info['employees_first_name']." ".$info['employees_last_name'],
						'rooms_number' => $info['rooms_number'],
						'rooms_id' => $info['rooms_id'],
						'year' => $info['year'],
                        'lunch_total' => $info['lunch_total'],
						'registration_fee' => $info['registration_fee'],
						'material_fee_total' => $info['material_fee_total'],				
						'sessions_id' => $info['sessions_id'],
						'nick_name' => $info['nick_name'],
						'classes_id' => $info['classes_id']
						);
      }

    return $array;

	}
	
	
	 function tep_get_morning_room_teacher_assingments($summer_sports_id,$sessions_id,$employees_id){

	 $array = array();
 
      $query = tep_db_query("SELECT * FROM summer_room_assignments, employees, rooms
	  WHERE summer_room_assignments.employees_id=employees.employees_id
	  and summer_room_assignments.rooms_id=rooms.rooms_id
	  and summer_sports_id='".$summer_sports_id."' and sessions_id='".$sessions_id."' and summer_room_assignments.employees_id='".$employees_id."'");

      while ($info = tep_db_fetch_array($query)) {

        $array[] = array('summer_room_assignments_id' => $info['summer_room_assignments_id'],

						'summer_week' => $info['summer_week'],

						'summer_sports' => $info['summer_sports'],
						'summer_language' => $info['summer_language'],
						'summer_art_classes_id' => $info['summer_art_classes_id'],
						'summer_class_levels_id' => $info['summer_class_levels_id'],
 						'employees_id' => $info['employees_id'],
						'rooms_id' => $info['rooms_id'],	
						'employees_first_name' => $info['employees_first_name'],
						 'employees_last_name' => $info['employees_last_name'],
						  'employees_full_name'=>$info['employees_first_name']." ".$info['employees_last_name'],
						'rooms_number' => $info['rooms_number'],
						'rooms_id' => $info['rooms_id'],
						'year' => $info['year'],
                        'lunch_total' => $info['lunch_total'],
						'registration_fee' => $info['registration_fee'],
						'material_fee_total' => $info['material_fee_total'],				
						'sessions_id' => $info['sessions_id'],
						'classes_id' => $info['classes_id']
						);
      }

    return $array;

	}
	
	function tep_get_afternoon_room_assingments($summer_art_classes_id,$sessions_id){

	 $array = array();
	 $sql="SELECT * FROM summer_room_assignments, employees, rooms
	  WHERE summer_room_assignments.employees_id=employees.employees_id
	  and summer_room_assignments.rooms_id=rooms.rooms_id
	  and summer_art_classes_id='".$summer_art_classes_id."' and sessions_id='".$sessions_id."'";
      $query = tep_db_query($sql);
	  
      while ($info = tep_db_fetch_array($query)) {

        $array[] = array('summer_room_assignments_id' => $info['summer_room_assignments_id'],

						'summer_week' => $info['summer_week'],
'summer_art_class' => $info['summer_art_class'],
						'summer_sports' => $info['summer_sports'],
						'summer_language' => $info['summer_language'],
						'summer_art_classes_id' => $info['summer_art_classes_id'],
						'summer_class_levels_id' => $info['summer_class_levels_id'],
 						'employees_id' => $info['employees_id'],
						'rooms_id' => $info['rooms_id'],	
						'employees_first_name' => $info['employees_first_name'],
						 'employees_last_name' => $info['employees_last_name'],
						  'employees_full_name'=>$info['employees_first_name']." ".$info['employees_last_name'],
						'rooms_number' => $info['rooms_number'],
						'rooms_id' => $info['rooms_id'],
						'year' => $info['year'],
                       // 'lunch_total' => $info['lunch_total'],
						//'registration_fee' => $info['registration_fee'],
						//'material_fee_total' => $info['material_fee_total'],				
						'sessions_id' => $info['sessions_id'],
						//'classes_id' => $info['classes_id']
						);
      }

    return $array;

	}
	
	
	function tep_get_afternoon_room_assingments_by_class($summer_art_class,$sessions_id,$locations_id,$year,$summer_week){

	 $array = array();
		 $sql="SELECT * FROM summer_room_assignments, employees, rooms
	  WHERE summer_room_assignments.employees_id=employees.employees_id
	  and summer_room_assignments.rooms_id=rooms.rooms_id
	  and summer_art_class='".$summer_art_class."' and sessions_id='".$sessions_id
		."' and year='".$year
		 ."' and summer_week='".$summer_week."'
	  and summer_room_assignments.locations_id=".$locations_id." order by summer_room_assignments_id desc";
      $query = tep_db_query($sql);
	  
      while ($info = tep_db_fetch_array($query)) {

        $array[] = array('summer_room_assignments_id' => $info['summer_room_assignments_id'],

						'summer_week' => $info['summer_week'],
'summer_art_class' => $info['summer_art_class'],
						'summer_sports' => $info['summer_sports'],
						'summer_language' => $info['summer_language'],
						'summer_art_class' => $info['summer_art_class'],
						'summer_art_classes_id' => $info['summer_art_classes_id'],
						'summer_class_levels_id' => $info['summer_class_levels_id'],
 						'employees_id' => $info['employees_id'],
						'rooms_id' => $info['rooms_id'],	
						'employees_first_name' => $info['employees_first_name'],
						 'employees_last_name' => $info['employees_last_name'],
						  'employees_full_name'=>$info['employees_first_name']." ".$info['employees_last_name'],
						'rooms_number' => $info['rooms_number'],
						'rooms_id' => $info['rooms_id'],
						'year' => $info['year'],
                        'lunch_total' => $info['lunch_total'],
						'registration_fee' => $info['registration_fee'],
						'material_fee_total' => $info['material_fee_total'],				
						'sessions_id' => $info['sessions_id'],
						'nick_name' => $info['nick_name'],
						'classes_id' => $info['classes_id']
						);
      }

    return $array;

	}
	
		function tep_get_afternoon_room_teacher_assingments($summer_art_classes_id,$sessions_id,$employees_id){

	 $array = array();
   
      $query = tep_db_query("SELECT * FROM summer_room_assignments, employees, rooms
	  WHERE summer_room_assignments.employees_id=employees.employees_id
	  and summer_room_assignments.rooms_id=rooms.rooms_id
	  and summer_art_classes_id='".$summer_art_classes_id."' and sessions_id='".$sessions_id."' and  summer_room_assignments.employees_id='".$employees_id."'");
	  
      while ($info = tep_db_fetch_array($query)) {

        $array[] = array('summer_room_assignments_id' => $info['summer_room_assignments_id'],

						'summer_week' => $info['summer_week'],
'summer_art_class' => $info['summer_art_class'],
						'summer_sports' => $info['summer_sports'],
						'summer_language' => $info['summer_language'],
						'summer_art_classes_id' => $info['summer_art_classes_id'],
						'summer_class_levels_id' => $info['summer_class_levels_id'],
 						'employees_id' => $info['employees_id'],
						'rooms_id' => $info['rooms_id'],	
						'employees_first_name' => $info['employees_first_name'],
						 'employees_last_name' => $info['employees_last_name'],
						  'employees_full_name'=>$info['employees_first_name']." ".$info['employees_last_name'],
						'rooms_number' => $info['rooms_number'],
						'rooms_id' => $info['rooms_id'],
						'year' => $info['year'],
                        'lunch_total' => $info['lunch_total'],
						'registration_fee' => $info['registration_fee'],
						'material_fee_total' => $info['material_fee_total'],				
						'sessions_id' => $info['sessions_id'],
						'classes_id' => $info['classes_id']
						);
      }

    return $array;

	}
	
		function tep_get_aftercamp_room_assingments($summer_classes_id,$sessions_id){

	 $array = array();
	 $sql="SELECT * FROM summer_room_assignments, employees, rooms
	  WHERE summer_room_assignments.employees_id=employees.employees_id
	  and summer_room_assignments.rooms_id=rooms.rooms_id
	  and summer_art_classes_id='".$summer_classes_id."' and sessions_id='".$sessions_id."'";
      $query = tep_db_query($sql);
	  
      while ($info = tep_db_fetch_array($query)) {

        $array[] = array('summer_room_assignments_id' => $info['summer_room_assignments_id'],

						'summer_week' => $info['summer_week'],
'summer_art_class' => $info['summer_art_class'],
						'summer_sports' => $info['summer_sports'],
						'summer_language' => $info['summer_language'],
						'summer_art_classes_id' => $info['summer_art_classes_id'],
						'summer_class_levels_id' => $info['summer_class_levels_id'],
 						'employees_id' => $info['employees_id'],
						'rooms_id' => $info['rooms_id'],	
						'employees_first_name' => $info['employees_first_name'],
						 'employees_last_name' => $info['employees_last_name'],
						  'employees_full_name'=>$info['employees_first_name']." ".$info['employees_last_name'],
						'rooms_number' => $info['rooms_number'],
						'rooms_id' => $info['rooms_id'],
						'year' => $info['year'],
                        'lunch_total' => $info['lunch_total'],
						'registration_fee' => $info['registration_fee'],
						'material_fee_total' => $info['material_fee_total'],				
						'sessions_id' => $info['sessions_id'],
						'classes_id' => $info['classes_id']
						);
      }

    return $array;

	}
	
	function tep_get_aftercamp_room_assingments_by_class($aftercamp1,$sessions_id,$locations_id,$year){

	 $array = array();
		 $sql="SELECT * FROM summer_room_assignments, employees, rooms
	  WHERE summer_room_assignments.employees_id=employees.employees_id
	  and summer_room_assignments.rooms_id=rooms.rooms_id
	  and summer_art_class='".$summer_art_class."' and sessions_id='".$sessions_id
		."' and year='".$year."'
	  and summer_room_assignments.locations_id=".$locations_id." order by summer_room_assignments_id desc";
      $query = tep_db_query($sql);
	  
      while ($info = tep_db_fetch_array($query)) {

        $array[] = array('summer_room_assignments_id' => $info['summer_room_assignments_id'],

						'summer_week' => $info['summer_week'],
'summer_art_class' => $info['summer_art_class'],
						'summer_sports' => $info['summer_sports'],
						'summer_language' => $info['summer_language'],
						'summer_art_class' => $info['summer_art_class'],
						'summer_art_classes_id' => $info['summer_art_classes_id'],
						'summer_class_levels_id' => $info['summer_class_levels_id'],
 						'employees_id' => $info['employees_id'],
						'rooms_id' => $info['rooms_id'],	
						'employees_first_name' => $info['employees_first_name'],
						 'employees_last_name' => $info['employees_last_name'],
						  'employees_full_name'=>$info['employees_first_name']." ".$info['employees_last_name'],
						'rooms_number' => $info['rooms_number'],
						'rooms_id' => $info['rooms_id'],
						'year' => $info['year'],
                        'lunch_total' => $info['lunch_total'],
						'registration_fee' => $info['registration_fee'],
						'material_fee_total' => $info['material_fee_total'],				
						'sessions_id' => $info['sessions_id'],
						'classes_id' => $info['classes_id']
						);
      }

    return $array;

	}
	
function tep_get_employees(){

	 $array = array();

      $query = tep_db_query("SELECT * from employees where employees_status='Active' order by employees_first_name");

      while ($info = tep_db_fetch_array($query)) {

        $array[] = array('employees_id' => $info['employees_id'],
						'employees_first_name' => $info['employees_first_name'],
						'employees_last_name' => $info['employees_last_name'],
						'employees_phone' => $info['employees_phone'],
						'employees_email' => $info['employees_email'],
						'employees_street_addres' => $info['employees_street_addres'],
 						'employees_city' => $info['employees_city'],
						'employees_state' => $info['employees_state'],	
						'employees_zip' => $info['employees_zip'],
                        'employees_hourly_rate' => $info['employees_hourly_rate'],
						'employees_weekly_salary' => $info['employees_weekly_salary'],
						'employees_status' => $info['employees_status'],				
						'employees_monthly_salary' => $info['employees_monthly_salary'],
						'employees_full_name'=>($info['employees_first_name']." ".$info['employees_last_name'])
						);
      }

    return $array;

	}	
	
	function tep_get_rooms($locations_id){

	 $array = array();
	// echo "SELECT * from rooms where locations_id='".$locations_id."'";
	// $Sql="SELECT * from rooms where locations_id='".$locations_id."'";
	  $Sql="SELECT * from rooms";
      $query = tep_db_query($Sql);

      while ($info = tep_db_fetch_array($query)) {

        $array[] = array('rooms_id' => $info['rooms_id'],
						'rooms_number' => $info['rooms_number'],
						'locations_id' => $info['locations_id']	
						);
      }

    return $array;

	}	
	
		function tep_get_morning_sessions($summer_sports_id){
			
//echo "SELECT * from summer_class_sessions where summer_sports_id='".$summer_sports_id."' and  ` summer_class_sessions_status` = 'Active'";
	 $array = array();
      $query = tep_db_query("SELECT * from summer_class_sessions where summer_sports_id='".$summer_sports_id."' and  `summer_class_sessions_status` = 'Active'");

      while ($info = tep_db_fetch_array($query)) {

        $array[] = array('summer_class_sessions_id' => $info['summer_class_sessions_id'],
						'summer_class_sessions' => $info['summer_class_sessions']
						);
      }

    return $array;

	}	
function	tep_get_afternoon_sessions($summer_art_classes_id)
{
	 $array = array();
      $query = tep_db_query("SELECT * from summer_class_sessions where summer_art_classes_id='".$summer_art_classes_id."' and  `summer_class_sessions_status` = 'Active'");

      while ($info = tep_db_fetch_array($query)) {

        $array[] = array('summer_class_sessions_id' => $info['summer_class_sessions_id'],
						'summer_class_sessions' => $info['summer_class_sessions']
						);
      }

    return $array;

	}	
	
	function tep_get_morning_sessions_students($summer_sports_id,$morning_session){

	 $array = array();
	 $class_info=tep_get_class($summer_sports_id);
	 $class= $class_info[0]['summer_class_name'];
	  $sql="
SELECT students.students_id,enrollments.enrollments_id, summer_enrollments_id, enrollments.discount,
 students_first_name, students_last_name, allergies,
 enrollments_status ,grade,enrollments.`discount`,enrollments.lunch_total,enrollments.material_fee,enrollments.registration_fee

FROM summer_class_sessions, summer_enrollments, enrollments,students,summer_classes
WHERE summer_class_sessions.summer_sports_id = summer_enrollments.summer_sports_id
AND enrollments.enrollments_id = summer_enrollments.enrollments_id
and enrollments.students_id=students.students_id
AND summer_enrollments.`summer_sports_id`= summer_classes.`summer_classes_id`
AND `summer_class_sessions_status` = 'Active'
And morning_session='".$morning_session."' 
And  summer_classes.`summer_class_name`='".$class."'
AND enrollments.enrollments_status = 'Accepted'
GROUP BY summer_enrollments_id";
	
      $query = tep_db_query($sql);

      while ($info = tep_db_fetch_array($query)) {

        $array[] = array('summer_enrollments_id' => $info['summer_enrollments_id'],
						'students_first_name' => $info['students_first_name'],
						'students_last_name' => $info['students_last_name']
						
						
						);
      }

    return $array;

	}	
	
	function tep_get_afternoon_sessions_students($summer_art_classes_id,$afternoon_session){

	 $array = array();
	 $sql="
SELECT students.students_id,enrollments.enrollments_id, summer_enrollments_id, enrollments.discount,
 students_first_name, students_last_name, allergies,
 enrollments_status ,grade,enrollments.`discount`,enrollments.lunch_total,enrollments.material_fee,enrollments.registration_fee

FROM summer_class_sessions, summer_enrollments, enrollments,students
WHERE summer_class_sessions.summer_art_classes_id = summer_enrollments.summer_art_classes_id
AND enrollments.enrollments_id = summer_enrollments.enrollments_id
and enrollments.students_id=students.students_id
and summer_enrollments.summer_art_classes_id='".$summer_art_classes_id."' 
AND `summer_class_sessions_status` = 'Active'
And afternoon_session='".$afternoon_session."' 
AND enrollments.enrollments_status = 'Accepted'
GROUP BY summer_enrollments_id";
      $query = tep_db_query($sql);

      while ($info = tep_db_fetch_array($query)) {

        $array[] = array('summer_enrollments_id' => $info['summer_enrollments_id'],
						'students_first_name' => $info['students_first_name'],
						'students_last_name' => $info['students_last_name']
						
						
						);
      }

    return $array;

	}	
	
	
		function tep_get_sessions_students($summer_class_name,$session,$locations_id,$class_period,$summer_week,$summer_class_levels_id){

	 $array = array();
	 if($class_period=="Morning"){
		 $session_string="morning_session=".$session ;
		 $class_id_type="summer_sports_id";
	 }
	 if($class_period=="Afternoon"){
		  $session_string="afternoon_session=".$session ;
		  $class_id_type="summer_art_classes_id";
	 }
	 if($class_period=="Aftercamp1"){
		  $session_string="aftercamp1_session=".$session ;
		  $class_id_type="aftercamp1";
	 }
	if($class_period=="Aftercamp2"){
		  $session_string="aftercamp2_session=".$session ;
		  $class_id_type="aftercamp2";
	 }
		
	if($class_period=="Aftercamp3"){
		  $session_string="aftercamp3_session=".$session ;
		  $class_id_type="aftercamp3";
	 }
				
	 $sql=" SELECT students.students_id,enrollments.enrollments_id, summer_enrollments_id, enrollments.discount, students_first_name, students_last_name, allergies, enrollments_status ,grade,enrollments.`discount`,enrollments.lunch_total,enrollments.material_fee,enrollments.registration_fee,summer_classes.summer_classes_id
FROM summer_class_sessions, summer_enrollments, enrollments,students,summer_classes
WHERE summer_enrollments.".$class_id_type." =summer_classes.summer_classes_id
and summer_class_sessions.".$class_id_type." = summer_enrollments.".$class_id_type."
and summer_classes.summer_class_name='".$summer_class_name."'
AND enrollments.enrollments_id = summer_enrollments.enrollments_id 
and enrollments.students_id=students.students_id
 AND `summer_class_sessions_status` = 'Active' 
and summer_enrollments.`summer_class_levels_id`='".$summer_class_levels_id."'
and `enrollments_status`='Accepted'
 And ".$session_string."
  And summer_classes.locations_id='".$locations_id."' 
   And summer_classes.summer_week='".$summer_week."' 
 AND enrollments.enrollments_status = 'Accepted' GROUP BY summer_enrollments_id ";

	
      $query = tep_db_query($sql);

      while ($info = tep_db_fetch_array($query)) {

        $array[] = array('summer_enrollments_id' => $info['summer_enrollments_id'],
						'students_first_name' => $info['students_first_name'],
						'students_last_name' => $info['students_last_name']
						
						
						);
      }

    return $array;

	}
	
	
	 //get contact
	 function tep_get_authorizaedpickup($families_id){
		  $array = array();
		
      $query = tep_db_query("select* from contacts where families_id='".$families_id."' and contact_type like '%AuthorizedPickup%' order by contact_type");
      while ($info = tep_db_fetch_array($query)) {
        $array[] = array('families_id' => $info['families_id'],
						'contacts_work_phone' => $info['contacts_work_phone'],
						'relationship' => $info['relationship'],
						'contacts_cell_phone' => $info['contacts_cell_phone'],
						'contacts_email' => $info['contacts_email'],
						'contact_type' => $info['contact_type'],
						'contacts_last_name' => $info['contacts_last_name'],
                        'contacts_first_name' => $info['contacts_first_name']);
      }

    return $array;

		 }
		 
		 ///////////////////////////2019////////////////////
 function tep_get_summer_enrollment($enrollments_id,$week){
	 $array = array();

      $query = tep_db_query("select * from summer_enrollments, summer_class_levels where summer_enrollments.summer_class_levels_id=summer_class_levels.summer_class_level_id 
and enrollments_id=".$enrollments_id." and summer_week=".$week);
      while ($info = tep_db_fetch_array($query)) {
        $array[] = array('summer_programs_id' => $info['summer_programs_id'],
						'summer_class_levels_id' => $info['summer_class_levels_id'],
						'summer_class_level' => $info['summer_class_level'],
						'summer_enrollments_weekly_total' => $info['summer_enrollments_weekly_total'],
						'days_in_week' => $info['days_in_week'],
						'summer_week' => $info['summer_week'],
						'lunch' => $info['lunch'],
						'weekly_tuition' => $info['weekly_tuition'],
						'summer_afternoon_classes' => $info['summer_art_classes_id'],
						'summer_language_class' => $info['summer_language_class'],
						'morning_session' => $info['morning_session'],	
						'afternoon_session' => $info['afternoon_session'],	
						'summer_morning_classes' => $info['summer_sports_id']
						);
      }
    return $array;
	}
	
	
	
 function tep_get_summer_enrollment_schedule($enrollments_id, $week){
      $query = tep_db_query("select summer_day_id  from summer_enrollments_schedules  where enrollments_id=".$enrollments_id." and summer_week=".$week);
      while ($info = tep_db_fetch_array($query)) {
        $array[] =  $info['summer_day_id'];
      }
    return $array;
	}
	
	function tep_get_summer_week ($locations_id,$year){
		$array= array();
		 $sql="select * from  summer_weeks
where locations_id = '" . (int)$locations_id ."' 
and summer_year = '" . (int)$year ."' ";

    $query = tep_db_query($sql);
if( $query !="") {
 while ($values = tep_db_fetch_array($query)) {

		 $array[] = array(
		 'summer_week' => $values['summer_week'],
		'summer_week_id' => $values['summer_week_id'],
		'summer_week_description' => $values['summer_week_description'],
		'camp_days' => $values['camp_days'],
		'summer_year' => $values['summer_year']
		) ;

			 }

    return $array;
	}
	}
	
		function tep_get_summer_week_by_date ($locations_id,$summer_date){
		$array= array();
		 $sql="select * from  summer_weeks_days
where locations_id = '" . (int)$locations_id ."' 
and summer_date = '" . $summer_date ."' ";

    $query = tep_db_query($sql);
if( $query !="") {
 while ($values = tep_db_fetch_array($query)) {

		 $array[] = array(
		 'summer_week' => $values['summer_week'],
		'summer_week_id' => $values['summer_week_id'],
		'summer_week_description' => $values['summer_week_description'],
		'camp_days' => $values['camp_days'],
		'summer_year' => $values['summer_year'],
		'locations_id' => $values['locations_id']
		) ;

			 }

    return $array;
	}
	} 

	  
  function tep_format_number($number,$digit=2) {
	      return   number_format($number,$digit, '.', '') ;
  }
//  function tep_add_enrollment($students_id,$mds,$tuition,$total, $material_fee=0, $registration_fee=0,$year,$locations_id) 
 function tep_add_enrollment($students_id,$mds,$tuitionOnly,$total,$lunchtotal,$material_fee, 
		$discount,$registration_fee,$year,$locations_id,$early_bird_discount,
		$sibling_discount,$material_fee_waived,
		$registration_fee_waived,$promotion_discount,$other_discount,$enrollments_status)
  {
      global  $customer_id;
    $sql_data_array = array(
                               'customers_id' => $customer_id,
                              'students_id' => $students_id,
                              'tuition' => $tuitionOnly,
							  'total' => $total,
							  'lunch_total'=>$lunchtotal,
                              'material_fee' => $material_fee,
							  'registration_fee' => $registration_fee, 
							  'discount' =>$discount,
							  'enrollment_date ' => date("Y-m-d H:i:s"),
                              'meeting_days' => $mds,
                              'enrollments_status' => $enrollments_status,
							  'early_bird_discount'=>$early_bird_discount,
							  'sibling_discount'=>$sibling_discount,
							  'material_fee_waived'=>$material_fee_waived,
							  'registration_fee_waived'=>$registration_fee_waived,
							  'promotion_discount'=>$promotion_discount,
							  'other_discount'=>$other_discount,
							  'year' => $year,  
							  'locations_id' => $locations_id,
							  'last_modified'	=> date("Y-m-d H:i:s")
							  );
		 tep_db_perform('enrollments', $sql_data_array);	
		

 return $enrollments_id = tep_db_insert_id();

    }
	 function tep_get_summer_classes($summer_class_level_id,$week,$class_period,$locations_id,$year){
	 $array = array();

if ($summer_class_level_id==8){
 $sql="SELECT summer_classes_id,summer_class_name FROM summer_classes WHERE summer_week='".$week ."' and locations_id='".$locations_id."' 
 and class_period='".$class_period ."'    and year='".$year."' and status='Active' group by summer_classes_id,summer_class_name";

 }else{

  $sql="
SELECT summer_classes_id,class_period,summer_classes.summer_week,summer_class_name,class_description,addon_status,summer_classes.summer_class_level_id, summer_week_description
FROM summer_classes, summer_class_levels, summer_weeks
WHERE summer_classes.year =".$year."
AND class_period =  '".$class_period."'
AND summer_weeks.summer_week = summer_classes.`summer_week` 
and summer_weeks.summer_year= summer_classes.`year` 
and summer_weeks.locations_id= summer_classes.`locations_id` 
AND summer_class_levels.summer_class_level_id = summer_classes.`summer_class_level_id`
AND summer_classes.`summer_week` =".$week."
and class_status='Y' 
and status='Active'
AND summer_classes.`summer_class_level_id` =".$summer_class_level_id."
and summer_classes.locations_id=".$locations_id."
GROUP BY summer_classes_id,class_period,summer_classes.summer_week,summer_class_name,class_description,addon_status,summer_classes.summer_class_level_id, summer_week_description
ORDER BY summer_classes.`summer_class_level_id` 
";

 }   

 //}   
 $query = tep_db_query($sql);
 //if($class_period=="Aftercamp1"||$class_period=="Aftercamp2"||$class_period=="Aftercamp3"){
	// if(tep_db_num_rows($query)>1)
 //echo "**";}

 while ($info = tep_db_fetch_array($query)) {
        $array[] = array('summer_classes_id' => $info['summer_classes_id'],
						'summer_class_name' => $info['summer_class_name'],
						'summer_week' => $info['summer_week'],
						'class_period' => $info['class_period'],
						'class_description' => $info['class_description'],
						'addon_status' => $info['addon_status'],
						'summer_class_level_id 	' => $info['summer_classes.summer_class_level_id'],
						'summer_week_description' => $info['summer_week_description'],
											
						);
      }
    return $array;
		 }
 function tep_get_summer_classes_admin($summer_class_level_id,$week,$class_period,$locations_id,$year){
	 $array = array();

if ($summer_class_level_id==8){
 $sql="SELECT summer_classes_id,summer_class_name, summer_class_level 
 FROM summer_classes,summer_class_levels
 WHERE  summer_class_levels.summer_class_level_id = summer_classes.`summer_class_level_id`
and summer_week='".$week ."' and summer_classes.locations_id='".$locations_id."' 
 and class_period='".$class_period ."'    and summer_classes.year='".$year."' and status='Active' group by summer_classes_id,summer_class_name";


 }else{

  $sql="
SELECT summer_classes_id,summer_week_description,class_period, class_description,addon_status,summer_classes.summer_class_level_id,summer_classes.`summer_week` , `summer_class_name` , `summer_class_level` 

FROM summer_classes, summer_class_levels, summer_weeks
WHERE summer_classes.year =".$year."
AND class_period =  '".$class_period."'
AND summer_weeks.summer_week = summer_classes.`summer_week` 
and summer_weeks.summer_year= summer_classes.`year` 
and summer_weeks.locations_id= summer_classes.`locations_id` 
AND summer_class_levels.summer_class_level_id = summer_classes.`summer_class_level_id`
and status='Active'
AND summer_classes.`summer_week` =".$week."
AND summer_classes.`summer_class_level_id` =".$summer_class_level_id."
and summer_classes.locations_id=".$locations_id."
GROUP BY summer_classes_id,summer_week_description,class_period, class_description,addon_status,summer_classes.summer_class_level_id,summer_classes.`summer_week` , `summer_class_name` , `summer_class_level` 
ORDER BY summer_classes.`summer_class_level_id` 

";

 }   

 $query = tep_db_query($sql);
 //if($class_period=="Aftercamp1"||$class_period=="Aftercamp2"||$class_period=="Aftercamp3"){
	// if(tep_db_num_rows($query)>1)
 //echo "**";}

 while ($info = tep_db_fetch_array($query)) {
        $array[] = array('summer_classes_id' => $info['summer_classes_id'],
						'summer_class_name' => $info['summer_class_name'],
						'summer_week' => $info['summer_week'],
						'class_period' => $info['class_period'],
						'class_description' => $info['class_description'],
						'addon_status' => $info['addon_status'],
						'summer_class_level_id 	' => $info['summer_classes.summer_class_level_id'],
						'summer_week_description' => $info['summer_week_description'],
						'summer_class_level'	=> $info['summer_class_level']				
						);
      }
    return $array;
		 }

function tep_get_one_summer_class($summer_classes_id){
	 $array = array();
      $query = tep_db_query("SELECT * FROM  summer_classes WHERE summer_classes_id=".$summer_classes_id);
      while ($info = tep_db_fetch_array($query)) {
			$array[] = array(
			'summer_class_name' => $info['summer_class_name'],
			'summer_week' => $info['summer_week'],
			'class_period' => $info['class_period'],
			'class_description' => $info['class_description'],
			'addon_status' => $info['addon_status'],
			'class_status'=> $info['class_status'],
			'summer_class_level_id 	' => $info['summer_classes.summer_class_level_id'],
			'summer_week_description' => $info['summer_week_description']
			);
	  }
	 //$info = tep_db_fetch_array($query) 	;
	   // return  $info['summer_class_name'];
		return $array;
		 }
	function is_morning_addon($summer_sports) {
//echo "SELECT `addon_status` FROM summer_classes WHERE summer_classes_id='".$summer_sports."'";
	$query = tep_db_query("SELECT `addon_status` FROM summer_classes WHERE summer_classes_id='".$summer_sports."'");

         $info = tep_db_fetch_array($query) 	;
	
	 if ($info['addon_status']=='Y')
     return 1;	

	}  
function is_afternoon_addon($summer_art_classes){

 
	    $query = tep_db_query("SELECT `addon_status` FROM summer_classes WHERE summer_classes_id='".$summer_art_classes."'");
	 $info = tep_db_fetch_array($query) 	;
	 if ($info['addon_status']=='Y')
     return 1;		

	}	 
	
	
  function tep_get_summer_camp_tuition($week,$days_in_week,$summer_sports,$summer_art_classes,$language,$summer_class_levels_id,$lunch){

$tuition=0;
$m=0;$a=0;$l=0;
$addon=126;
	//check programs
	if($summer_sports!="")
		$m=1;
	if($summer_art_classes!="")
		 $a=1;
	if($language!="")
		 $l=1;
	 $p=$m+$a+$l;

	if($p==3)
		$summer_programs=1;
	if($p==2)
		$summer_programs=2;
	if($p==1)
		$summer_programs=4;
	 $summer_programs;

	//if (is_morning_addon($summer_sports)==1 && is_afternoon_addon($summer_art_classes)==1)
	 //  $summer_programs=1;
	//echo $summer_sports."---".is_morning_addon($summer_sports)."--".$summer_art_classes."---".is_afternoon_addon($summer_art_classes)."*".$summer_programs."<br>";
	
//////////////////// July 4th week, 4 days tuition, before 2022
/*	
	if ($days_in_week<5){         
         
          $query = tep_db_query("SELECT `daily_cost` FROM `summer_program_tuition` WHERE `summer_programs_id`='".$summer_programs."' and summer_class_levels_id='".$summer_class_levels_id."'");
          $info = tep_db_fetch_array($query) 	;
	  $daily_tuition = $info['daily_cost'];
	 // $daily_tuition = tep_get_summer_daily_tuition($summer_programs);
	 $lunchCost=$dailyLunch*$days_in_week;
	   $tuition=$daily_tuition*$days_in_week+$lunchCost*$lunch;

		if ($days_in_week==4){
			  if ($summer_programs==4||$summer_programs==5||$summer_programs==6){
		 //$tuition= $tuition-20;
		 if($summer_class_levels_id==7)
			 $tuition= 220;
		 else
		 $tuition= 180;
		}
		}
	}
	*/
//////////////////////////////////////////////
/////2024 tuitions: $219/$369/$439//////////
/////2025 tuitions: $229/$399/$469//////////
/////////////// prorate tuition////////////////
if ($days_in_week<5){        
         
       if ($summer_programs==1){ 
		   $daily_tuition =469/5;
		   if((is_morning_addon($summer_sports)==1&&is_afternoon_addon($summer_art_classes)==1)){				
						$daily_tuition=(469+$addon+$addon)/5;//469+126+126=691
				}			
			else if((is_morning_addon($summer_sports)==1||is_afternoon_addon($summer_art_classes)==1)){				
			$daily_tuition=(469+$addon)/5; //469+126=565
			}		
			else{
				
			}
	    
	   }
	   if ($summer_programs==2||$summer_programs==3){
		    $daily_tuition =399/5;
			if((is_morning_addon($summer_sports)==1&&is_afternoon_addon($summer_art_classes)==1)){
			   $daily_tuition=(399+$addon+$addon)/5;	//399+126+126	  
		  }				
			else if((is_morning_addon($summer_sports)==1||is_afternoon_addon($summer_art_classes)==1)){			
	
			$daily_tuition=(399+$addon)/5;//399+126
			}			
			else{}
	   }
	   if ($summer_programs==4||$summer_programs==5||$summer_programs==6){	
	    $daily_tuition =229/5;
		if((is_morning_addon($summer_sports)==1||is_afternoon_addon($summer_art_classes)==1)&&$g!="Rhythmic Gymnastics*")
				 $daily_tuition=(229+$addon)/5;
	   }
				
				$tuition=$daily_tuition*$days_in_week;
	}
/////////////// prorate tuition////////////////

	if ($days_in_week==5){
              //calculate regular
/*        
		$query = tep_db_query("SELECT `weekly_cost`  FROM `summer_program_tuition` WHERE `summer_programs_id`='".$summer_programs."' and summer_class_levels_id='".$summer_class_levels_id."'");
			$info = tep_db_fetch_array($query) 	;
			 $tuition=$info['weekly_cost']; 
		*/
			// hardcode tuition cost
			 if($summer_programs==1)
				$tuition=469;
			if($summer_programs==2)
				$tuition=399;
			if($summer_programs==4)
				$tuition=229;
			
            //calculate addon	

			$g="";
			  if($summer_art_classes!=""){
			  $g=tep_get_summer_art_class_name($summer_art_classes);
			  }
		   
		  	if ($summer_programs==1){ 
			if((is_morning_addon($summer_sports)==1&&is_afternoon_addon($summer_art_classes)==1)){				
					$tuition=469+$addon+$addon; //449+126+126=691
			}
			 //$tuition=$tuition+$morning_addon+$afternoon_addon; 
			else if((is_morning_addon($summer_sports)==1||is_afternoon_addon($summer_art_classes)==1)){
					$tuition=469+$addon; //449+126=565
			}		
			else{}
		}
            
         if ($summer_programs==2||$summer_programs==3){
		  if((is_morning_addon($summer_sports)==1&&is_afternoon_addon($summer_art_classes)==1)){
			   $tuition=399+$addon+$addon;//369+126+126=621	  
		  }				
			else if((is_morning_addon($summer_sports)==1||is_afternoon_addon($summer_art_classes)==1)){				
				$tuition=399+$addon;//369+126=495
			}			
			else{}
		  } 	
          if ($summer_programs==4||$summer_programs==5||$summer_programs==6){			  
			
			 // if((is_morning_addon($summer_sports)==1||is_afternoon_addon($summer_art_classes)==1)&&$g=="Rhythmic Gymnastics*")
			 // $tuition=$tuition+$morning_addon+$afternoon_addon;
				if((is_morning_addon($summer_sports)==1||is_afternoon_addon($summer_art_classes)==1)&&$g!="Rhythmic Gymnastics*")
				 $tuition=229+$addon;
          }  
 
		   $tuition=$tuition+$weeklyLunch*$lunch;
	}   
		////////////// July 4-day week///////////////////
		// in 2025, it is week 5 //
		// 2024 tuition: $180/$300/$350 
		// 2025 tuition: $190/$320/$380 
		if ($week==5){         
			$addon=100;
				   if ($summer_programs==4)	{	
				   $tuition= 190;
				   	if((is_morning_addon($summer_sports)==1||is_afternoon_addon($summer_art_classes)==1))
						$tuition=190+$addon;//290
				   }
					if ($summer_programs==2){	
						$tuition= 320;
						if((is_morning_addon($summer_sports)==1||is_afternoon_addon($summer_art_classes)==1))
						$tuition=320+$addon;//420
					}
					if ($summer_programs==1){		
						$tuition= 380;	
						if((is_morning_addon($summer_sports)==1||is_afternoon_addon($summer_art_classes)==1))
						$tuition=380+$addon;//480						
					}
					
					if ($days_in_week<4){                 
				   if ($summer_programs==4)	{	
				   $daily_tuition= 190/4;
				   	if((is_morning_addon($summer_sports)==1||is_afternoon_addon($summer_art_classes)==1))
						$daily_tuition=(180+$addon)/4;
				   }
					if ($summer_programs==2){	
						$daily_tuition= 320/4;
						if((is_morning_addon($summer_sports)==1||is_afternoon_addon($summer_art_classes)==1))
						$daily_tuition=(300+$addon)/4;//
					}
					if ($summer_programs==1){		
						$daily_tuition= 380/4;	
						if((is_morning_addon($summer_sports)==1||is_afternoon_addon($summer_art_classes)==1))
						$daily_tuition=(380+$addon)/4;//					
					}
					$tuition=$daily_tuition*$days_in_week;
				}
					
				}
					   
	
	      return $tuition;
		 }
		 
		 function tep_get_summer_customers_payments($customers_id){
		   $current_year_first_day=date('Y-m-d', strtotime('first day of january this year'));
 $array = array();
    /*echo "SELECT * 
FROM orders_payments, orders
WHERE orders_payments.orders_id=orders.orders_id
and payment_date>'".$current_year_first_day."'
and customers_id =".$customers_id;*/
      $query = tep_db_query("SELECT orders.orders_id, orders_payments.payment_amount,
	  transaction_id,auth_code,response_message,orders_payments.payment_method,orders_payments.payment_date,
	  orders_payments_notes,orders_payments.check_number
FROM orders_payments, orders
WHERE orders_payments.orders_id=orders.orders_id
and payment_date>'".$current_year_first_day."'
and customers_id =".$customers_id);

      while ($info = tep_db_fetch_array($query)) {
$orders_payments_notes=$orders_payments_info['orders_payments_notes'];			
$transaction_id=$orders_payments_info['transaction_id'];				
$auth_code=$orders_payments_info['auth_code'];				
$response_message=$orders_payments_info['response_message'];
        $array[] = array(
						'orders_id' => $info['orders_id'],						
						'payment_amount' => $info['payment_amount'],						
						'transaction_id' => $info['transaction_id'],						
						'auth_code' => $info['auth_code'],
						'response_message' => $info['response_message'],
						'payment_method' => $info['payment_method'],
						'payment_date' => $info['payment_date'],
						'check_number' => $info['check_number'],						
						'orders_payments_notes'=>$info['orders_payments_notes']
						);
      }
    return $array;
	}
	
		 function tep_get_summer_enrollments_lunches($enrollments_id,$summer_day_id=0){
	
	if($summer_day_id==0)
	$sql="SELECT * FROM summer_enrollments_lunches WHERE enrollments_id=".$enrollments_id ;
else 
	$sql="SELECT * FROM summer_enrollments_lunches WHERE enrollments_id=".$enrollments_id." and summer_day_id= ". $summer_day_id;
//echo $sql;	
	$array = array();
	 $query = tep_db_query($sql);
	 while ($info = tep_db_fetch_array($query)) {
        $array[] = array('summer_class_level_id' => $info['summer_class_level_id'],
						'summer_day_id' => $info['summer_day_id'],
						'lunch_notes' => $info['lunch_notes'],
						'year' => $info['year'],
						'lunch_amount' => $info['lunch_amount']
						);
      }
    return $array;
		 }
 function tep_get_summer_lunch_costs($summer_class_level_id,$year){		
//echo "SELECT daily_lunch_amount  FROM lunch_costs  WHERE summer_class_level_id ='".$summer_class_level_id."' and year=".$year;
      $query = tep_db_query("SELECT daily_lunch_amount  FROM lunch_costs  WHERE summer_class_level_id ='".$summer_class_level_id."' and year=".$year);
     $info = tep_db_fetch_array($query) ;
    return $info['daily_lunch_amount'];
	}
	
    function tep_get_action_logs($customers_id) {

	$array= array();

    $query = tep_db_query("SELECT * FROM `action_logs` WHERE customers_id='" . (int)$customers_id ."'");
	 while ($values = tep_db_fetch_array($query)) {
		  $array[] = array(
		  'logs_id' => $values['logs_id'],
		  'administrators_id' => $values['administrators_id'],
		  'change_datetime' => $values['change_datetime'],
		  'notes' => $values['notes'],
		  'customers_signature' => $values['customers_signature'],
		  'page' => $values['page']
		  );
	 }
	  return $array;
	
	}	
	
		 function tep_get_locations($locations_id=0){
	 $array = array();
	 if($locations_id==0){
		 $sql="SELECT * FROM locations";		 
	 }
	 else{
		 $sql="SELECT * FROM locations where locations_id=".$locations_id;
	 }
	 $query = tep_db_query($sql );
	 while ($info = tep_db_fetch_array($query)) {
        $array[] = array('locations_id' => $info['locations_id'],
						'locations_name'=> $info['locations_name'],
						'locations_short_name'=> $info['locations_short_name'],
						 	
						'locations_street_address'=> $info['locations_street_address'],
						'locations_city'=> $info['locations_city'],
						'locations_state'=> $info['locations_state'],
						'locations_zipcode'=> $info['locations_zipcode'],
						'locations_phone'=> $info['locations_phone'],
						'map_link'=> $info['map_link'],
						'area'=> $info['area']
						);
      }
    return $array;
		 }
		 
		  function tep_get_class($summer_classes_id=0){
	 $array = array();
	 if($summer_classes_id==0){
		 $sql="SELECT * FROM summer_classes";		 
	 }
	 else{
		 $sql="SELECT * FROM summer_classes where summer_classes_id=".$summer_classes_id;
	 }
	
	 $query = tep_db_query($sql );
	 while ($info = tep_db_fetch_array($query)) {
        $array[] = array(		
						'summer_classes_id'=>$info['summer_classes_id'],
						'summer_class_name'=> $info['summer_class_name'],
						'summer_week'=> $info['summer_week'],
						'summer_class_level_id'=> $info['summer_class_level_id'],
						'class_period'=> $info['class_period'],
						'addon_status'=> $info['addon_status'],
						'addon_full'=> $info['addon_full'],
						'addon_short'=> $info['addon_short'],
						'addon_half'=> $info['addon_half'],
						'addon_all'=> $info['addon_all'],
						'year'=> $info['year'],
						'class_status'=> $info['class_status'],
						'class_description'=> $info['class_description'],
						'courses_id'=> $info['courses_id'],
						'locations_id'=> $info['locations_id'],
						'min_capacity'=> $info['min_capacity'],
						'max_capacity'=> $info['max_capacity'],
						'weekly_enrollment_required'=> $info['weekly_enrollment_required']
						);
      }
    return $array;
		 }
	
			  function tep_get_classes_by_name($summer_class_name,$summer_week,$year,$sessions_id,$locations_id,$class_period,$summer_class_levels_id){
	 $array = array();
	
	 if($class_period=="Morning")
		$summer_class_name_string=" summer_sports='".$summer_class_name."'";
	 if($class_period=="Afternoon")
		$summer_class_name_string=" summer_art_class='".$summer_class_name."'" ;
	 if($class_period=="Aftercamp1")
		$summer_class_name_string=" summer_aftercamp1='".$summer_class_name."'" ;
	 if($class_period=="Aftercamp2")
		$summer_class_name_string=" summer_aftercamp2='".$summer_class_name."'" ;
	 if($class_period=="Aftercamp3")
		$summer_class_name_string=" summer_aftercamp3='".$summer_class_name."'";
	  $sql= "SELECT * FROM summer_room_assignments 
				where". $summer_class_name_string
				." and summer_week=".$summer_week
				." and locations_id=".$locations_id
				." and year=".$year
				." and sessions_id=".$sessions_id
				." and summer_class_levels_id=".$summer_class_levels_id;
				
				
				
	 $query = tep_db_query($sql);
	 while ($info = tep_db_fetch_array($query)) {
        $array[] = array(		
						'summer_room_assignments_id'=>$info['summer_room_assignments_id'],
						'summer_week'=> $info['summer_week'],
						'locations_id'=> $info['locations_id'],
						'summer_sports_id'=> $info['summer_sports_id'],
						'summer_art_classes_id'=> $info['summer_art_classes_id'],
						'summer_aftercamp_id'=> $info['summer_aftercamp_id'],
						'summer_art_class'=> $info['summer_art_class'],
						'summer_sports'=> $info['summer_sports'],
						'summer_language'=> $info['summer_language'],
						'summer_aftercamp1'=> $info['summer_aftercamp1'],
						'summer_aftercamp2'=> $info['summer_aftercamp2'],
						'summer_aftercamp3'=> $info['summer_aftercamp3'],						
						'summer_class_levels_id'=> $info['summer_class_levels_id'],
						'employees_id'=> $info['employees_id'],
						'rooms_id'=> $info['rooms_id'],
						'year'=> $info['year'],
						'sessions_id'=> $info['sessions_id']
						);
      }
    return $array;
		 }
		 
		 	  function tep_get_course_change_request($course_change_request_id=0){
	 $array = array();
	  $current_year_first_day=date('Y-m-d', strtotime('first day of january this year'));
	 if($course_change_request_id==0){
		 $sql="SELECT * FROM course_change_request where course_change_request_id>=648 order by course_change_request_id Desc";		 
	 }
	 else{
		 $sql="SELECT * FROM course_change_request where course_change_request_id=".$course_change_request_id." and course_change_request_id>=307 order by course_change_request_id Desc";
	 }
	 $query = tep_db_query($sql );
	 while ($info = tep_db_fetch_array($query)) {
        $array[] = array(						
						'course_change_request_id'=> $info['course_change_request_id'],
						'students_first_name'=> $info['students_first_name'],
						'students_last_name'=> $info['students_last_name'],
						'course_change_message'=> $info['course_change_message'],
						'customers_id'=> $info['customers_id'],
						'enrollments_id'=> $info['enrollments_id'],						
						'status'=> $info['status'],
						'last_modified'=> $info['last_modified'],
						'last_modified_by'=> $info['last_modified_by'],
						'notes'=> $info['notes']
						);
      }
    return $array;
		 }
		 
			 
		 	  function tep_get_enrollment_course_change_request($enrollments_id){
	 $array = array();
	  $current_year_first_day=date('Y-m-d', strtotime('first day of january this year'));
	
		 $sql="SELECT * FROM course_change_request where enrollments_id=".$enrollments_id." and  course_change_request_id>=648 and status !='Canceled' order by course_change_request_id Desc";
	
	 $query = tep_db_query($sql );
	 while ($info = tep_db_fetch_array($query)) {
        $array[] = array(						
						'course_change_request_id'=> $info['course_change_request_id'],
						'students_first_name'=> $info['students_first_name'],
						'students_last_name'=> $info['students_last_name'],
						'course_change_message'=> $info['course_change_message'],
						'customers_id'=> $info['customers_id'],
						'enrollments_id'=> $info['enrollments_id'],						
						'status'=> $info['status'],
						'last_modified'=> $info['last_modified'],
						'last_modified_by'=> $info['last_modified_by'],
						'notes'=> $info['notes']
						);
      }
    return $array;
		 }
		 
		 
		 function tep_get_summer_week_day($week,$locations_id,$summer_day){
$firstdate=date('Y-m-d', strtotime("first day of january " . date('Y')));
	 $array = array();
       
      $query = tep_db_query("SELECT * FROM `summer_weeks_days` WHERE summer_week=".$week." and locations_id=".$locations_id." 
	  and summer_day='".$summer_day."' 
	  and `summer_date` >= '".$firstdate."'
	
	  order by summer_date");
	  

   while ($info = tep_db_fetch_array($query)) {

        $array[] = array('summer_day_id' => $info['summer_day_id'],

						'summer_day' => $info['summer_day'],

						'summer_date' => $info['summer_date'],

						'status' => $info['status']

						);

      }
	  return $array;
//$info = tep_db_fetch_array($query);
 //   return $info['summer_date'];

		 }
		 
		 function tep_get_room_assingments($class_period,$summer_classes_id,$sessions_id){

	 $array = array();
	 
	if($class_period=="Aftercamp1"||$class_period=="Aftercamp2"||$class_period=="Aftercamp3"){	
		$col_name="summer_aftercamp_id";
	}
	if($class_period=="Morning"){
		$col_name="summer_sports_id";
	}
	if($class_period=="Afternoon"){
		$col_name="summer_art_classes_id";
	}
	
	  $sql="SELECT * FROM summer_room_assignments, employees, rooms
	  WHERE summer_room_assignments.employees_id=employees.employees_id
	  and summer_room_assignments.rooms_id=rooms.rooms_id
	 and ".$col_name." ='".$summer_classes_id."' and sessions_id='".$sessions_id."'";
	 
	 
	 
	/* if($class_period=="Aftercamp1"){
	echo $sql="SELECT * FROM summer_room_assignments, employees, rooms
	  WHERE summer_room_assignments.employees_id=employees.employees_id
	  and summer_room_assignments.rooms_id=rooms.rooms_id
	  and summer_aftercamp1='".$summer_classes_id."' and sessions_id='".$sessions_id."'";
	 }
	 if($class_period=="Aftercamp2"){
	 $sql="SELECT * FROM summer_room_assignments, employees, rooms
	  WHERE summer_room_assignments.employees_id=employees.employees_id
	  and summer_room_assignments.rooms_id=rooms.rooms_id
	  and summer_aftercamp2='".$summer_classes_id."' and sessions_id='".$sessions_id."'";
	 }
	 if($class_period=="Aftercamp3"){
	 $sql="SELECT * FROM summer_room_assignments, employees, rooms
	  WHERE summer_room_assignments.employees_id=employees.employees_id
	  and summer_room_assignments.rooms_id=rooms.rooms_id
	  and summer_aftercamp3='".$summer_classes_id."' and sessions_id='".$sessions_id."'";
	 }
	 */
	 
      $query = tep_db_query($sql);
	  
      while ($info = tep_db_fetch_array($query)) {

        $array[] = array('summer_room_assignments_id' => $info['summer_room_assignments_id'],

						'summer_week' => $info['summer_week'],
						'summer_art_class' => $info['summer_art_class'],
						'summer_sports' => $info['summer_sports'],
						'summer_language' => $info['summer_language'],
						'summer_art_classes_id' => $info['summer_art_classes_id'],
						'summer_class_levels_id' => $info['summer_class_levels_id'],
 						'employees_id' => $info['employees_id'],
						'rooms_id' => $info['rooms_id'],	
						'employees_first_name' => $info['employees_first_name'],
						 'employees_last_name' => $info['employees_last_name'],
						  'employees_full_name'=>$info['employees_first_name']." ".$info['employees_last_name'],
						'rooms_number' => $info['rooms_number'],
						'rooms_id' => $info['rooms_id'],
						'year' => $info['year'],
                        //'lunch_total' => $info['lunch_total'],
						//'registration_fee' => $info['registration_fee'],
						//'material_fee_total' => $info['material_fee_total'],				
						'sessions_id' => $info['sessions_id'],
						'nick_name' => $info['nick_name'],
						//'classes_id' => $info['classes_id']
						);
      }

    return $array;

	}
	
	function	tep_get_class_sessions($class_period,$summer_classes_id)
{
	
	 $array = array();
	 $class_period=strtolower($class_period);
	 if ($class_period=="morning" ||$class_period=="Morning")
		$sql= "SELECT * from summer_class_sessions where summer_sports_id='".$summer_classes_id."' and  `summer_class_sessions_status` = 'Active'";
	else if ($class_period=="afternoon"||$class_period=="Afternoon")
		 $sql="SELECT * from summer_class_sessions where summer_art_classes_id='".$summer_classes_id."' and  `summer_class_sessions_status` = 'Active'";
	 else if($class_period=="aftercamp1"||$class_period=="aftercamp2"||$class_period=="aftercamp3")
		 $sql="SELECT * from summer_class_sessions where ".$class_period."='".$summer_classes_id."' and  `summer_class_sessions_status` = 'Active'";

      $query = tep_db_query($sql);

      while ($info = tep_db_fetch_array($query)) {

        $array[] = array('summer_class_sessions_id' => $info['summer_class_sessions_id'],
						'summer_class_sessions' => $info['summer_class_sessions']
						);
      }

    return $array;

	}	
	
			 
function tep_get_summer_one_week ($locations_id,$year,$week){
		$array= array();
		 $sql="select * from  summer_weeks
where locations_id = '" . (int)$locations_id ."' 
and summer_year = '" . (int)$year ."' and summer_week=".$week;

    $query = tep_db_query($sql);
if( $query !="") {
 while ($values = tep_db_fetch_array($query)) {

		 $array[] = array(
		 'summer_week' => $values['summer_week'],
		'summer_week_id' => $values['summer_week_id'],
		'summer_week_description' => $values['summer_week_description'],
		'camp_days' => $values['camp_days'],
		'summer_year' => $values['summer_year']
		) ;

			 }

    return $array;
	}
	}
	function tep_get_week_by_summer_day_id($summer_day_id,$lcoations_id=1){
      $query = tep_db_query("SELECT * FROM `summer_weeks_days` WHERE summer_day_id='".$summer_day_id."' and locations_id=".$lcoations_id);

     $info = tep_db_fetch_array($query) 	;

      $week =$info['summer_week'];

	      return $week;

		 }	
			  function tep_get_summer_week_days_location($year,$summer_week,$locations_id){
	 $array = array();
	 $d=$current_year_first_day;
	 //echo "select* from summer_weeks_days where  summer_date >'".$d."' and summer_week=".$summer_week;
      $query = tep_db_query("select* from summer_weeks_days where  summer_date >'".$d."' and summer_week=".$summer_week."  and locations_id=".$locations_id);
      while ($info = tep_db_fetch_array($query)) {
        $array[] = array('summer_day_id' => $info['summer_day_id'],
						'summer_date' => $info['summer_date'],
						'summer_day' => $info['summer_day'],
						'status' => $info['status']
						);
      }
	 
    return $array;
		 }
		 
	function tep_get_timesheets_by_id($timesheet_id){
			 
			  $array = array();
	 $d=$current_year_first_day;
	
		 $sql="select* from timesheets where  timesheet_id =".$timesheet_id;
	  $sql;
      $query = tep_db_query($sql);
      while ($info = tep_db_fetch_array($query)) {
        $array[] = array('timesheet_id' => $info['timesheet_id'],
						'weekly_admin_hours' => $info['weekly_admin_hours'],
						'employees_id' => $info['employees_id'],
						'weekly_teaching_hours' => $info['weekly_teaching_hours'],
						'weekly_tutorial_hours' => $info['weekly_tutorial_hours'],
						'weekly_supervision_hours' => $info['weekly_supervision_hours'],
						'weekly_total' => $info['weekly_total'],
						'summer_week' => $info['summer_week'],
						'year' => $info['year'],
						'check_number' => $info['check_number'],
						'notes' => $info['notes'],
						'approval_notes' => $info['approval_notes'],
						'approval_time' => $info['approval_time'],
						'approver' => $info['approver'],
						'approval_status' => $info['approval_status'],
						'type' => $info['type']
						);
      }
	 
    return $array;
		 }
		 
	function tep_get_timesheets($year,$employees_id=0){
	 $array = array();
	 $d=$current_year_first_day;
	 //echo "select* from summer_weeks_days where  summer_date >'".$d."' and summer_week=".$summer_week;
	 if($employees_id>0)
		 $sql="select* from timesheets where  year =".$year."  and employees_id=".$employees_id." and status ='Active' order by timesheet_id desc";
	else
		 $sql="select* from timesheets where  year =".$year." and status ='Active'  order by timesheet_id desc";
	  $sql;
      $query = tep_db_query($sql);
      while ($info = tep_db_fetch_array($query)) {
        $array[] = array('timesheet_id' => $info['timesheet_id'],
						'weekly_admin_hours' => $info['weekly_admin_hours'],
						'employees_id' => $info['employees_id'],
						'weekly_teaching_hours' => $info['weekly_teaching_hours'],
						'weekly_tutorial_hours' => $info['weekly_tutorial_hours'],
						'weekly_supervision_hours' => $info['weekly_supervision_hours'],
						'weekly_total' => $info['weekly_total'],
						'summer_week' => $info['summer_week'],
						'year' => $info['year'],
						'check_number' => $info['check_number'],
						'notes' => $info['notes'],
						'approval_notes' => $info['approval_notes'],	
						'approver'=>$info['approver'],
						'approval_time'=>$info['approval_time'],
						'approval_status'=>$info['approval_status'],
						'type' => $info['type']
						);
      }
	 
    return $array;
		 }
	function tep_get_timesheets_by_week($year,$week,$employees_id=0){
	 $array = array();
	 $d=$current_year_first_day;
	 //echo "select* from summer_weeks_days where  summer_date >'".$d."' and summer_week=".$summer_week;
	 if($employees_id>0)
		 $sql="select* from timesheets where  year =".$year."  and employees_id=".$employees_id." and summer_week=".$week." and status ='Active' order by timesheet_id desc";
	else
		 $sql="select* from timesheets where  year =".$year." and summer_week=".$week." and status ='Active'  order by timesheet_id desc";
	  $sql;
      $query = tep_db_query($sql);
      while ($info = tep_db_fetch_array($query)) {
        $array[] = array('timesheet_id' => $info['timesheet_id'],
						'weekly_admin_hours' => $info['weekly_admin_hours'],
						'employees_id' => $info['employees_id'],
						'weekly_teaching_hours' => $info['weekly_teaching_hours'],
						'weekly_tutorial_hours' => $info['weekly_tutorial_hours'],
						'weekly_supervision_hours' => $info['weekly_supervision_hours'],
						'weekly_total' => $info['weekly_total'],
						'summer_week' => $info['summer_week'],
						'year' => $info['year'],
						'check_number' => $info['check_number'],
						'notes' => $info['notes'],
						'approval_notes' => $info['approval_notes'],	
						'approver'=>$info['approver'],
						'approval_time'=>$info['approval_time'],
						'approval_status'=>$info['approval_status'],
						'type' => $info['type']
						);
      }
	 
    return $array;
		 }	

	function tep_get_timesheets_name_by_week($year,$week,$employees_id=0){
	 $array = array();
	 $d=$current_year_first_day;
	 //echo "select* from summer_weeks_days where  summer_date >'".$d."' and summer_week=".$summer_week;
	 if($employees_id>0)
		 $sql="select* from timesheets, employees where  year =".$year."  and employees_id=".$employees_id." and summer_week=".$week." and status ='Active' and timesheets.`employees_id`=employees.employees_id
order by employees.employees_last_name;";
	else
		 $sql="select* from timesheets, employees where  year =".$year." and summer_week=".$week." and status ='Active'  and timesheets.`employees_id`=employees.employees_id
order by employees.employees_last_name";

      $query = tep_db_query($sql);
      while ($info = tep_db_fetch_array($query)) {
        $array[] = array('timesheet_id' => $info['timesheet_id'],
						'weekly_admin_hours' => $info['weekly_admin_hours'],
						'employees_id' => $info['employees_id'],
						'employees_first_name' => $info['employees_first_name'],
						'employees_last_name' => $info['employees_last_name'],
						'weekly_teaching_hours' => $info['weekly_teaching_hours'],
						'weekly_tutorial_hours' => $info['weekly_tutorial_hours'],
						'weekly_supervision_hours' => $info['weekly_supervision_hours'],
						'weekly_total' => $info['weekly_total'],
						'summer_week' => $info['summer_week'],
						'year' => $info['year'],
						'check_number' => $info['check_number'],
						'notes' => $info['notes'],
						'approval_notes' => $info['approval_notes'],	
						'approver'=>$info['approver'],
						'approval_time'=>$info['approval_time'],
						'approval_status'=>$info['approval_status'],
						'type' => $info['type']
						);
      }
	 
    return $array;
		 }	
	
	function tep_get_timesheets_detail($timesheet_id=0){
	 $array = array();
	 $d=$current_year_first_day;
		if($timesheet_id>0)
		 $sql="select* from timesheets_detail where  timesheet_id =".$timesheet_id;
	else
		 $sql="select* from timesheets_detail";
      $query = tep_db_query($sql);
      while ($info = tep_db_fetch_array($query)) {
        $array[] = array('timesheet_id' => $info['timesheet_id'],
						'timesheets_detail_id' => $info['timesheets_detail_id'],
						'teaching_hours' => $info['teaching_hours'],
						'teaching_hours_morning' => $info['teaching_hours_morning'],
						'teaching_hours_afternoon' => $info['teaching_hours_afternoon'],
						'tutorial_hours' => $info['tutorial_hours'],
						'supervision_hours' => $info['supervision_hours'],
						'supervision_hours_morning' => $info['supervision_hours_morning'],
						'supervision_hours_lunch' => $info['supervision_hours_lunch'],
						'supervision_hours_aftercamp' => $info['supervision_hours_aftercamp'],
						'camp_assistant_hours' => $info['camp_assistant_hours'],
						'start_time' => $info['start_time'],
						'end_time' => $info['end_time'],
						'lunch_break_time' => $info['lunch_break_time'],
						'notes' => $info['notes'],
						'summer_days_id' => $info['summer_days_id'],
						'summer_week' => $info['summer_week'],
						'year' => $info['year'],
						'submitted_time' => $info['submitted_time']
						);
      }
	 
    return $array;
		 }
		 
		 
		 	function tep_get_lesson_plans($year=0){
	 $array = array();
	 $d=$current_year_first_day;
		if($year>0)
		 $sql="select* from lesson_plans,employees, summer_classes where employees.employees_id=lesson_plans.employees_id
				and lesson_plans.summer_classes_id=summer_classes.summer_classes_id and lesson_plans.year =".$year." 
				order by summer_classes.summer_week,class_name";
	else
		 $sql="select* from lesson_plans order by class_name";
	  $sql;
      $query = tep_db_query($sql);
      while ($info = tep_db_fetch_array($query)) {
        $array[] = array('lesson_plan_id' => $info['lesson_plan_id'],
						'lesson_plan' => $info['lesson_plan'],
						'class_name' => $info['class_name'],
						
						'class_name alternate' => $info['class_name alternate'],
						'course_objectives' => $info['course_objectives'],
						'resources' => $info['resources'],
						'lesson_plan_outline' => $info['lesson_plan_outline'],
						'materials_by_teacher' => $info['materials_by_teacher'],
						'materials_by_school' => $info['materials_by_school'],
						'year' => $info['year'],
						'employees_id' => $info['employees_id'],
						'summer_classes_id' => $info['summer_classes_id'],
						'employees_username' => $info['employees_username'], 
						'employees_first_name' => $info['employees_first_name'],						
						'employees_last_name' => $info['employees_last_name'],
						'employees_email' => $info['employees_email'],
						'employees_phone' => $info['employees_phone'],
						'summer_week' => $info['summer_week'],
						'locations_id' => $info['locations_id']
						);
      }
	 
    return $array;
		 }
		 
	function tep_get_room($rooms_id){
	 $array = array();
	 
		 $sql="select* from rooms where rooms_id=".$rooms_id;
	
      $query = tep_db_query($sql);
      while ($info = tep_db_fetch_array($query)) {
        $array[] = array('rooms_id' => $info['rooms_id'],
						'rooms_number' => $info['rooms_number'],
						'locations_id' => $info['locations_id'],						
						'nick_name' => $info['nick_name']
						);
      }
	 
    return $array;
		 }	 
		 
	
	function tep_get_employee_by_id($employees_id){

	 $array = array();

      $query = tep_db_query("SELECT * from employees where employees_status='Active' and employees_id=".$employees_id." order by employees_first_name");

      while ($info = tep_db_fetch_array($query)) {

        $array[] = array('employees_id' => $info['employees_id'],
						'employees_first_name' => $info['employees_first_name'],
						'employees_last_name' => $info['employees_last_name'],
						'employees_phone' => $info['employees_phone'],
						'employees_email' => $info['employees_email'],
						'employees_street_addres' => $info['employees_street_addres'],
 						'employees_city' => $info['employees_city'],
						'employees_state' => $info['employees_state'],	
						'employees_zip' => $info['employees_zip'],
                        'employees_hourly_rate' => $info['employees_hourly_rate'],
						'employees_weekly_salary' => $info['employees_weekly_salary'],
						'employees_status' => $info['employees_status'],				
						'employees_monthly_salary' => $info['employees_monthly_salary'],
						'employees_full_name'=>($info['employees_first_name']." ".$info['employees_last_name'])
						);
      }

    return $array;

	}	
	 function tep_get_enrollments_notes($enrollments_id=0){
	 $array = array();
	 if($enrollments_id>0)
	 $sql="select * from enrollments_notes where enrollments_id=".$enrollments_id;
	else
		$sql="select * from enrollments_notes";
	      $query = tep_db_query($sql);
      while ($info = tep_db_fetch_array($query)) {
        $array[] = array('enrollments_notes_id' => $info['enrollments_notes_id'],
						'enrollments_id' => $info['enrollments_id'],
						'enrollments_notes' => $info['enrollments_notes'],
						'input_time' => $info['input_time'],
						'input_user' => $info['input_user']
						);
      }
	 
    return $array;
		 }
	
			 function tep_get_admin_notes($locations_id,$year,$category='',$submitted_by=''){
		 $query="";		
	 $array = array();
		 
	  $sql="select * from admin_notes where locations_id=".$locations_id." and year=".$year." order by admin_notes_id DESC";
	if($category!="" && $submitted_by=="")
	 $sql="select * from admin_notes where locations_id=".$locations_id." and year=".$year." and category='".$category."'  order by admin_notes_id DESC";
	if($submitted_by!="" && $category=="")
	 $sql="select * from admin_notes where locations_id=".$locations_id." and year=".$year." and submitted_by='".$submitted_by."'  order by admin_notes_id DESC";
	 if($submitted_by!="" && $category!="")
	 $sql="select * from admin_notes where locations_id=".$locations_id." and year=".$year." and submitted_by='".$submitted_by."' and category='".$category."' order by admin_notes_id DESC";
	
	 //echo $sql;
	
		
	      $query = tep_db_query($sql);
      while ($info = tep_db_fetch_array($query)) {
        $array[] = array('admin_notes_id' => $info['admin_notes_id'],
						'message' => $info['message'],
						'locations_id' => $info['locations_id'],
						'submitted_time' => $info['submitted_time'],
						'submitted_by' => $info['submitted_by'],
						'category' => $info['category'],
						'year' => $info['year'],
						'approver' => $info['approver'],						
						'approval_time' => $info['approval_time'],						
						'approval_status' => $info['approval_status'],						
						'approval_notes' => $info['approval_notes']
						
						);
      }
	 
    return $array;
		 }
		 
		 	 function tep_get_incident_reports($locations_id=0){
	 $array = array();
$current_year_first_day=date('Y-m-d', strtotime('first day of january this year'));
	 if($locations_id>0)
	 $sql="select * from incident_reports where locations_id=".$locations_id." and incident_date >'".$current_year_first_day."' and status !='Deleted' order by incident_reports_id DESC";
	else
		$sql="select * from incident_reports where incident_date >'".$current_year_first_day."' and status !='Deleted' order by incident_reports_id DESC";
	
	
	      $query = tep_db_query($sql);
      while ($info = tep_db_fetch_array($query)) {
        $array[] = array('incident_reports_id' => $info['incident_reports_id'],
						'incident_date'=> $info['incident_date'],
						'incident_details' => $info['incident_details'],
						'locations_id' => $info['locations_id'],
						'students_id' => $info['students_id'],
						'students_last_name' => $info['students_last_name'],
						'students_first_name' => $info['students_first_name'],
						'grade' => $info['grade'],
						'submitted_time' => $info['submitted_time'],
						'submitted_by' => $info['submitted_by'],
						'status' => $info['status'],
						'last_modified' => $info['last_modified'],
						'last_modified_by' => $info['last_modified_by']
						);
      }
	 
    return $array;
		 }
	////////////////////////////// update or new 2020//////////////////////////
 function tep_get_courses( $summer_class_level_id=0){
	 $array = array();
	 if( $summer_class_level_id==0){
		 $sql="SELECT * FROM courses order by courses_name";		 
	 }
	 else {
		  $sql="SELECT * FROM courses where summer_class_level_id=".$summer_class_level_id. " order by courses_name";
	 }
	 $query = tep_db_query($sql );
	 while ($info = tep_db_fetch_array($query)) {
        $array[] = array(		
						'courses_id'=>$info['courses_id'],
						'courses_name'=> $info['courses_name'],
						'courses_short_name'=> $info['courses_short_name'],
						'courses_description'=> $info['courses_description'],
						'addon_status'=> $info['addon_status'],
						'summer_class_level_id'=> $info['summer_class_level_id'],						
						'class_level'=> $info['class_level']);
      }
    return $array;
		 }	
function tep_get_one_course( $courses_id=0){
	 $array = array();
	
		 $sql="SELECT *
FROM `courses`
WHERE `courses_id` =".$courses_id;
	
	 $query = tep_db_query($sql );
	 while ($info = tep_db_fetch_array($query)) {
        $array[] = array(		
						'courses_id'=>$info['courses_id'],
						'courses_name'=> $info['courses_name'],
						'courses_short_name'=> $info['courses_short_name'],
						'courses_description'=> $info['courses_description'],
						'addon_status'=> $info['addon_status'],
						'summer_class_level_id'=> $info['summer_class_level_id'],						
						'class_level'=> $info['class_level']);
      }
    return $array;
		 }		
	
	function check_course_assigned($courses_id, $summer_week, $year, $class_period, $locations_id)	{
		 $array = array();
		 $sql="SELECT * FROM summer_classes where courses_id=".$courses_id.
		 " and summer_week=".$summer_week.
		 " and year=".$year.
		" and class_period='".$class_period."'".
		 " and locations_id=".$locations_id ;
		  $query = tep_db_query($sql );
		  while ($info = tep_db_fetch_array($query)) {
        $array[] = array(		
						'summer_classes_id'=>$info['summer_classes_id']
						);
						
      }
    return $array;
	 }

function tep_get_summer_class_levels_2020(){

	 $array = array();

      $query = tep_db_query("select* from summer_class_levels_2020 where summer_class_level_id< 10");

      while ($info = tep_db_fetch_array($query)) {

        $array[] = array('summer_class_level_id' => $info['summer_class_level_id'],
						'summer_class_level' => $info['summer_class_level'],
						);
      }
    return $array;

		 }
		 
	function get_get_matching_Lessonplan($course_name)	{
		 $array = array();
		 $sql="SELECT * FROM lesson_plans WHERE class_name='".$course_name."'";
		  $query = tep_db_query($sql );
		  while ($info = tep_db_fetch_array($query)) {
        $array[] = array(		
						'lesson_plan_id'=>$info['lesson_plan_id']
						);
						
      }
    return $array;
	 }
	 
	  function tep_get_friends_requests($enrollments_id=0){
	 $array = array();
	 if($enrollments_id>0)
	 $sql="select * from enrolllments_friend_requests where enrollments_id=".$enrollments_id;
	else
		$sql="select * from enrolllments_friend_requests";
	      $query = tep_db_query($sql);
      while ($info = tep_db_fetch_array($query)) {
        $array[] = array('friend_requests_id' => $info['friend_requests_id'],
						'enrollments_id' => $info['enrollments_id'],
						'friends_names' => $info['friends_names'],
						'input_time' => $info['input_time'],
						'input_user' => $info['input_user']
						);
      }
	 
    return $array;
		 }
		 
		 function tep_get_enrollment_refund_requests($customers_id=0){
	 $array = array();
	  $current_year_first_day=date('Y-m-d', strtotime('first day of january this year'));
			 if($customers_id>0)
		 $sql="SELECT * FROM refund_requests where customers_id=".$customers_id." and  refund_requests_date>='". $current_year_first_day."'  order by refund_requests_id Desc";
		else
			 $sql="SELECT * FROM refund_requests where refund_requests_date>='". $current_year_first_day."'  order by refund_requests_id Desc";
		
	 $query = tep_db_query($sql );
	 while ($info = tep_db_fetch_array($query)) {
        $array[] = array(						
						'refund_requests_id'=> $info['refund_requests_id'],
						'students_first_name'=> $info['students_first_name'],
						'students_last_name'=> $info['students_last_name'],
						'refund_requests_status'=> $info['refund_requests_status'],
						'customers_id'=> $info['customers_id'],
						'enrollments_id'=> $info['enrollments_id'],						
						'refund_requests_amount'=> $info['refund_requests_amount'],
						'refund_requests_date'=> $info['refund_requests_date'],
						'input_user'=> $info['input_user'],
						'refund_requests_notes'=> $info['refund_requests_notes']
						);
      }
    return $array;
		 }
		 
	////////////////update for 2023 /////////////////
 function tep_get_room_assingments_by_classname($class_period,$class_name,$year,$week,$locations_id=1){

	 $array = array();
	
	if($class_period=="Aftercamp1")
		$col_name="summer_aftercamp1";
	if($class_period=="Aftercamp2")
		$col_name="summer_aftercamp2";
	if($class_period=="Aftercamp2")
		$col_name="summer_aftercamp2";
	if($class_period=="Morning"){
		$col_name="summer_sports";
	}
	if($class_period=="Afternoon"){
		$col_name="summer_art_class";
	}
	

	 $class_name = str_replace("'","\'",$class_name);
	 
	  $sql="SELECT * FROM summer_room_assignments, employees, rooms
	  WHERE summer_room_assignments.employees_id=employees.employees_id
	  and summer_room_assignments.rooms_id=rooms.rooms_id
	 and ".$col_name." ='".$class_name."' and year ='".$year."' and summer_week='".$week."' and summer_room_assignments.locations_id='".$locations_id."'";
	 	 
      $query = tep_db_query($sql);	  
      while ($info = tep_db_fetch_array($query)) {
        $array[] = array('summer_room_assignments_id' => $info['summer_room_assignments_id'],

						'summer_week' => $info['summer_week'],
						'summer_art_class' => $info['summer_art_class'],
						'summer_sports' => $info['summer_sports'],
						'summer_sports_id' => $info['summer_sports_id'],
						'summer_language' => $info['summer_language'],
						'summer_art_classes_id' => $info['summer_art_classes_id'],
						'summer_class_levels_id' => $info['summer_class_levels_id'],
						'summer_aftercamp_id' => $info['summer_aftercamp_id'],
						'summer_aftercamp1' => $info['summer_aftercamp1'],
						'summer_aftercamp2' => $info['summer_aftercamp2'],
						'summer_aftercamp3' => $info['summer_aftercamp3'],
						'aftercamp1' => $info['aftercamp1'],
						'aftercamp2' => $info['aftercamp2'],
						'aftercamp3' => $info['aftercamp3'],
 						'employees_id' => $info['employees_id'],
						'employees_first_name' => $info['employees_first_name'],
						'employees_last_name' => $info['employees_last_name'],
						'employees_full_name'=>$info['employees_first_name']." ".$info['employees_last_name'],
						'rooms_number' => $info['rooms_number'],
						'rooms_id' => $info['rooms_id'],
						'year' => $info['year'],		
						'sessions_id' => $info['sessions_id'],
						'nick_name' => $info['nick_name'],
						);
      }

    return $array;

	}	
	
	function tep_get_summer_family_enrollments($customers_id, $year,$status){	   
	 $start_date=$year.'-01-01';
	 $start_date=date('Y-m-d',strtotime($start_date));
	 $end_date=$year.'-12-31';
	  $end_date=date('Y-m-d',strtotime($end_date));
  
		 $array = array();	
		 if ($status=="All"){
		  $sql="SELECT enrollments.enrollments_id,enrollments.tuition,enrollments.lunch_total, enrollments.registration_fee,enrollments.discount,
				enrollments.total, enrollments.material_fee, enrollments.locations_id,	 students_first_name, students_last_name, sibling_discount,promotion_discount,other_discount,enrollments_status
				FROM enrollments,   customers, families, students
				WHERE enrollments.customers_id = customers.customers_id
				AND enrollments.students_id = students.students_id
				AND families.families_id = customers.families_id
				AND families.families_id = students.families_id 
				and enrollment_date  <='".$end_date."'
				AND enrollment_date >='".$start_date."'
				and enrollments.customers_id=".$customers_id;
		 }
		 if ($status=="Accepted"){
		  $sql="SELECT enrollments.enrollments_id,enrollments.tuition,enrollments.lunch_total, enrollments.registration_fee,enrollments.discount,
				enrollments.total, enrollments.material_fee, enrollments.locations_id,	 students_first_name, students_last_name, sibling_discount,promotion_discount,other_discount,enrollments_status
				FROM enrollments,   customers, families, students
				WHERE enrollments.customers_id = customers.customers_id
				AND enrollments.students_id = students.students_id
				AND families.families_id = customers.families_id
				AND families.families_id = students.families_id 
				and (enrollments_status='Accepted')
				and enrollment_date  <='".$end_date."'
				AND enrollment_date >='".$start_date."'
				and enrollments.customers_id=".$customers_id;
		 }
		 if ($status=="Processing"){
		  $sql="SELECT enrollments.enrollments_id,enrollments.tuition,enrollments.lunch_total, enrollments.registration_fee,enrollments.discount,
				enrollments.total, enrollments.material_fee, enrollments.locations_id,	 students_first_name, students_last_name, sibling_discount,promotion_discount,other_discount,enrollments_status
				FROM enrollments,   customers, families, students
				WHERE enrollments.customers_id = customers.customers_id
				AND enrollments.students_id = students.students_id
				AND families.families_id = customers.families_id
				AND families.families_id = students.families_id 
				and (enrollments_status ='Processing' or enrollments_status='Cart Processing' )
				and enrollment_date  <='".$end_date."'
				AND enrollment_date >='".$start_date."'
				and enrollments.customers_id=".$customers_id;
		 }
		 
		 if ($status=="Not Draft"){
		  $sql="SELECT enrollments.enrollments_id,enrollments.tuition,enrollments.lunch_total, enrollments.registration_fee,enrollments.discount,
				enrollments.total, enrollments.material_fee, enrollments.locations_id,	 students_first_name, students_last_name, sibling_discount,promotion_discount,other_discount,enrollments_status
				FROM enrollments,   customers, families, students
				WHERE enrollments.customers_id = customers.customers_id
				AND enrollments.students_id = students.students_id
				AND families.families_id = customers.families_id
				AND families.families_id = students.families_id 
				and (enrollments_status ='Processing' or enrollments_status='Cart Processing' or enrollments_status='Accepted')
				and enrollment_date  <='".$end_date."'
				AND enrollment_date >='".$start_date."'
				and enrollments.customers_id=".$customers_id;
		 }
		 
		 
		  if ($status=="Refund Request"){
		  $sql="SELECT enrollments.enrollments_id,enrollments.tuition,enrollments.lunch_total, enrollments.registration_fee,enrollments.discount,
				enrollments.total, enrollments.material_fee, enrollments.locations_id,	 students_first_name, students_last_name, sibling_discount,promotion_discount,other_discount,enrollments_status
				FROM enrollments,   customers, families, students
				WHERE enrollments.customers_id = customers.customers_id
				AND enrollments.students_id = students.students_id
				AND families.families_id = customers.families_id
				AND families.families_id = students.families_id 
				and (enrollments_status ='Canceled' or enrollments_status='Accepted')
				and enrollment_date  <='".$end_date."'
				AND enrollment_date >='".$start_date."'
				and enrollments.customers_id=".$customers_id;
		 }

		$query=tep_db_query($sql);	
     while ($info = tep_db_fetch_array($query)) {
		  $array[] = array(
			'enrollments_id' => $info['enrollments_id'],
			'enrollments_status'=> $info['enrollments_status'],
			'tuition' => $info['tuition'],
			'registration_fee' => $info['registration_fee'],
			'discount' => $info['discount'],
			'lunch_total' => $info['lunch_total'],
			'material_fee' => $info['material_fee'],
			'tuition_paid' => $info['tuition_paid'],
			'locations_id' => $info['locations_id'],
			'students_first_name' => $info['students_first_name'],
			'students_last_name' => $info['students_last_name'],
			'sibling_discount' => $info['sibling_discount'],
			'promotion_discount' => $info['promotion_discount'],
			'other_discount' => $info['other_discount']
			);
	 }
	 return $array;
	}
// TABLES: students families customers

  function tep_get_family_students($families_id ) {

    $family_students_array = array();
	
      $family_students = tep_db_query("select * from customers, families, students where customers.families_id=families.families_id and students.families_id=families.families_id  and  customers.families_id='" .$families_id . "'");

      while ($family_students_values = tep_db_fetch_array($family_students)) {

        $family_students_array[] = array('families_id' => $family_students_values['families_id'], 

										'families_name' => $family_students_values['families_name'],

										'students_first_name' => $family_students_values['students_first_name'],

										'students_last_name' => $family_students_values['students_last_name'],

										'grade' => $family_students_values['grade'],

										'day_schools_name' => $family_students_values['day_schools_name'],

										 'students_status' => $family_students_values['students_status'],
										
										 'agreement_link' => $family_students_values['agreement_link'],
										 'registration_fee_paid' => $family_students_values['registration_fee_paid'],

									   'students_id' => $family_students_values['students_id']);
      }
    return $family_students_array;
  }
  
   function tep_get_summer_classes_2023($summer_class_levels_id,$grade,$week,$class_period,$locations_id,$year,$class_status=''){
	 $array = array();  
	$classname="";
	/*if($summer_class_levels_id==2)
		$str_summer_class_level=" summer_classes.summer_class_level_id=2 ";
	if($summer_class_levels_id==3)
		$str_summer_class_level=" summer_classes.summer_class_level_id=3 ";
	if($summer_class_levels_id==4)
		$str_summer_class_level=" summer_classes.summer_class_level_id=4 ";
	if($summer_class_levels_id==5)
		$str_summer_class_level=" summer_classes.summer_class_level_id=4 ";
	if($summer_class_levels_id==6)
		$str_summer_class_level=" summer_classes.summer_class_level_id=6 ";	
	if($summer_class_levels_id==7)
		$str_summer_class_level="  summer_classes.summer_class_level_id=7";
	if($summer_class_levels_id==9)
		$str_summer_class_level=" (summer_classes.summer_class_level_id=6 or summer_classes.summer_class_level_id=7)";
	*/
	if($grade==1)
		$str_summer_class_level=" summer_classes.summer_class_level_id=2 ";
	if($grade==2)
		$str_summer_class_level=" summer_classes.summer_class_level_id=3 ";
	if($grade==3)
		$str_summer_class_level=" summer_classes.summer_class_level_id=4 ";
	if($grade==4)
		$str_summer_class_level=" summer_classes.summer_class_level_id=4 ";
	if($grade==5)
		$str_summer_class_level=" summer_classes.summer_class_level_id=6 ";
	if($grade==6)
		$str_summer_class_level=" summer_classes.summer_class_level_id=6 ";	
	if($grade==7)
		$str_summer_class_level=" (summer_classes.summer_class_level_id=6 or summer_classes.summer_class_level_id=7)";
	if($grade>=8)
		$str_summer_class_level=" summer_classes.summer_class_level_id=7";
	
	 if ($class_status=='Y'){
		 $sql="
SELECT summer_classes_id,summer_week_description,courses_name, summer_classes.`summer_week` , `summer_class_name` , `summer_class_level` ,class_status
FROM summer_classes, summer_class_levels, summer_weeks, courses
WHERE summer_classes.year =".$year."
AND class_period =  '".$class_period."'
and summer_classes.courses_id=courses.courses_id
AND summer_weeks.summer_week = summer_classes.`summer_week` 
and summer_weeks.summer_year= summer_classes.`year` 
and summer_weeks.locations_id= summer_classes.`locations_id` 
AND summer_class_levels.summer_class_level_id = summer_classes.`summer_class_level_id`
AND summer_classes.`summer_week` =".$week."
and class_status='Y' 
and status='Active'
AND ".$str_summer_class_level."
and summer_classes.locations_id=".$locations_id."
GROUP BY summer_classes_id,summer_week_description,courses_name, summer_classes.`summer_week` , `summer_class_name` , `summer_class_level` 
 ORDER BY summer_classes.`summer_class_level_id` 
	 ";}
else{
  $sql="
SELECT summer_classes_id,summer_week_description,courses_name, summer_classes.`summer_week` , `summer_class_name` , `summer_class_level` ,class_status
FROM summer_classes, summer_class_levels, summer_weeks, courses
WHERE summer_classes.year =".$year."
AND class_period =  '".$class_period."'
and summer_classes.courses_id=courses.courses_id
AND summer_weeks.summer_week = summer_classes.`summer_week` 
and summer_weeks.summer_year= summer_classes.`year` 
and summer_weeks.locations_id= summer_classes.`locations_id` 
AND summer_class_levels.summer_class_level_id = summer_classes.`summer_class_level_id`
AND summer_classes.`summer_week` =".$week."
and status='Active'
AND ".$str_summer_class_level."
and summer_classes.locations_id=".$locations_id."
GROUP BY summer_classes_id,summer_week_description,courses_name, summer_classes.`summer_week` , `summer_class_name` , `summer_class_level` 
 ORDER BY summer_classes.`summer_class_level_id` 
";
}

 $query = tep_db_query($sql);
 //if($class_period=="Aftercamp1"||$class_period=="Aftercamp2"||$class_period=="Aftercamp3"){
	// if(tep_db_num_rows($query)>1)
 //echo "**";}

 while ($info = tep_db_fetch_array($query)) {
	 
	if($summer_class_levels_id==6)
		$classname= $info['summer_class_name']." (".$info['summer_class_level'].")";
	else
		$classname= $info['summer_class_name'];
        $array[] = array('summer_classes_id' => $info['summer_classes_id'],
						'summer_class_name' => $classname,	
						'courses_name' => $info['courses_name'],						
						'summer_week' => $info['summer_week'],
						'class_period' => $info['class_period'],
						'class_description' => $info['class_description'],
						'addon_status' => $info['addon_status'],
						'class_status' => $info['class_status'],						
						'summer_class_level_id 	' => $info['summer_classes.summer_class_level_id'],
						'summer_week_description' => $info['summer_week_description'],
											
						);
      }
    return $array;
		 }
	
	  // Returns enrollment count of a class
// Tables:  `summer_enrollments` , summer_classes, summer_class_levels, enrollments
//`enrollments_status`='Accepted'
function tep_get_enrollment_count( $summer_classes_id,$locations_id,$year,$class_period=''){
	$d=date($year ) . '-01-01';
	 $sql="SELECT count(summer_enrollments.`enrollments_id`) as num, summer_enrollments.`summer_week` ,  
`summer_class_level`,`summer_class_name` , 	 class_status,     enrollments.locations_id
FROM  `summer_enrollments` , summer_classes, summer_class_levels, enrollments
WHERE  ( `summer_enrollments`.summer_sports_id = summer_classes.`summer_classes_id` or `summer_enrollments`.summer_art_classes_id = summer_classes.`summer_classes_id` )
AND summer_class_levels.summer_class_level_id = summer_classes.`summer_class_level_id` 
AND enrollments.`enrollments_id` = summer_enrollments.`enrollments_id` 
and summer_classes.`summer_classes_id` =".$summer_classes_id."
and `enrollments_status`='Accepted'
and enrollment_date>".$d."
and enrollments.locations_id=".$locations_id."
GROUP BY  summer_enrollments.`summer_week` ,  `summer_class_level`, `summer_class_name` , 
		   class_status,     enrollments.locations_id
order by summer_class_levels.summer_class_level_id";

$query=tep_db_query($sql);	
 $info = tep_db_fetch_array($query);
 
 return  $info ['num'];
	
}
function tep_get_summer_schedule_version($enrollments_id,$version=0){
	
	 $array = array();
	 if($version==0){
		 $sql="select * from enrollments_history  as en, students as stu where en.students_id=stu.students_id and  en.enrollments_id=".$enrollments_id.
	  " ORDER BY `versions` DESC";
	 }
	 else if($version==9999){
		 $sql="select * from enrollments_history  as en, students as stu where en.students_id=stu.students_id and  en.enrollments_id=".$enrollments_id.
	  " ORDER BY `versions` DESC LIMIT 0, 1";     
	 }
	  else {
		  $sql="select * from enrollments_history  as en, students as stu where en.students_id=stu.students_id and  en.enrollments_id=".$enrollments_id.
	  " and versions=".$version;	
	  }

	   $query = tep_db_query( $sql);
      while ($info = tep_db_fetch_array($query)) {
        $array[] = array('tuition' => $info['tuition'],
						'enrollment_date' => $info['enrollment_date'],
						'classes_id' => $info['classes_id'],	
						'customers_id' => $info['customers_id'],
						'students_id' => $info['students_id'],
						'enrollments_status' => $info['enrollments_status'],
						'meeting_days' => $info['meeting_days'],
						'students_last_name' => $info['students_last_name'],
						'students_first_name' => $info['students_first_name'],
						'disabilities' => $info['disabilities'],
						'allergies' => $info['allergies'],
						'medications' => $info['medications'],
						'total' => $info['total'], 	
						'lunch_total' => $info['lunch_total'],
						'material_fee' => $info['material_fee'],
						'material_fee_waived' => $info['material_fee_waived'],
						'tuition_paid' => $info['tuition_paid'],
                         'order_all_lunches' => $info['order_all_lunches'],
						'discount' => $info['discount'], 
						'promotion_discount' => $info['promotion_discount'], 
						'other_discount' => $info['other_discount'], 
						'early_bird_discount' => $info['early_bird_discount'], 
					    'sibling_discount' => $info['sibling_discount'], 
						'registration_fee' => $info['registration_fee'],
						'registration_fee_waived' => $info['registration_fee_waived'],						
						'summer_pickup_locations_id' => $info['summer_pickup_locations_id'],							   
						'locations_id' => $info['locations_id'],
						'cancellation_fee' => $info['cancellation_fee'],							
						'year' => $info['year'],
						'versions' => $info['versions'],
						'histroy_last_modified'=> $info['histroy_last_modified']
						);
      }
    return $array;
}
function tep_get_inventory_items($inventory_items_id=0){
	 $array = array();
	 if($inventory_items_id>0)
	 $sql="select * from inventory_items where inventory_items_id='".$inventory_items_id."'";
	else
		 $sql="select * from inventory_items";
	 $query = tep_db_query( $sql);
      while ($info = tep_db_fetch_array($query)) {
        $array[] = array('inventory_items_id' => $info['inventory_items_id'],
						'items_name'=> $info['items_name'],
						'items_description'=> $info['items_description'],
						'items_category'=> $info['items_category']
						);
		
	  }
	      return $array;
}
function tep_get_inventory($locations_id=0,$inventory_id=0){
	 $array = array();
	 if($inventory_id>0)
	 $sql="select * from inventory,  inventory_items
 where  inventory_items. inventory_items_id=inventory. inventory_items_id
  and locations_id='".$locations_id."'
 and inventory.inventory_id='".$inventory_id."'";
	else
		 $sql="select * from inventory,  inventory_items
 where  inventory_items. inventory_items_id=inventory. inventory_items_id
  and locations_id='".$locations_id."'";

//echo $sql;
	 $query = tep_db_query($sql);
      while ($info = tep_db_fetch_array($query)) {  
        $array[] = array('inventory_id' => $info['inventory_id'],
						'inventory_items_id' => $info['inventory_items_id'],
						'items_name'=> $info['items_name'],
						'items_description'=> $info['items_description'],
						'items_category'=> $info['items_category'],
						'quantity'=> $info['quantity'],
						'storage'=> $info['storage'],
						'locations_id'=> $info['locations_id'],
						'last_modified'=> $info['last_modified'],
						'submitted_by'=> $info['submitted_by'],
						'notes'=> $info['notes']
						);
		
	  }
	      return $array;
	  }
	  
	   function tep_get_admin_notes_by_id($admin_notes_id){
		 $query="";		
	 $array = array();
		 
	  $sql="select * from admin_notes where admin_notes_id=".$admin_notes_id;
	
	
		
	      $query = tep_db_query($sql);
      while ($info = tep_db_fetch_array($query)) {
        $array[] = array('admin_notes_id' => $info['admin_notes_id'],
						'message' => $info['message'],
						'locations_id' => $info['locations_id'],
						'submitted_time' => $info['submitted_time'],
						'submitted_by' => $info['submitted_by'],
						'category' => $info['category'],
						'year' => $info['year'],						 
						'approver' => $info['approver'],						
						'approval_time' => $info['approval_time'],						
						'approval_status' => $info['approval_status'],						
						'approval_notes' => $info['approval_notes']
						);
      }
	 
    return $array;
		 }
		 
		  function tep_get_summer_pickup_notes($summer_pickup_notes_id=0){
		 $query="";		
	 $array = array();
	/* if($year==0)
		 $year_str=" ";
	 else 
		 $year_str=" and year=". $year;
	 */
	 
		 if($summer_pickup_notes_id!=0||$summer_pickup_notes_id!="")
	  $sql="select * from summer_pickup_notes where summer_pickup_notes=".$summer_pickup_notes_id;
		else
			$sql="select * from summer_pickup_notes";
		
	      $query = tep_db_query($sql);
      while ($info = tep_db_fetch_array($query)) {
        $array[] = array('summer_pickup_notes_id' => $info['summer_pickup_notes_id'],
						'enrollments_id' => $info['enrollments_id'],
						'students_id' => $info['students_id'],
						'locations_id' => $info['locations_id'],
						'submitted_time' => $info['submitted_time'],
						'submitted_by' => $info['submitted_by'],
						'summer_days_id' => $info['catsummer_days_idegory'],
						//'year' => $info['year'],						 
						'summer_pickup_notes' => $info['summer_pickup_notes'],						
						'status' => $info['status'],						
						'admin_comment' => $info['admin_comment']
						
						);
      }
	 
    return $array;
		 }
		 
		  function tep_get_students_enrollment($enrollments_id){
			   $array = array();
			   $sql="SELECT *
			FROM `students` , enrollments
			WHERE enrollments.students_id = students.students_id
			AND enrollments_id ='".$enrollments_id ."'";
			    $query = tep_db_query($sql);
				 while ($info = tep_db_fetch_array($query)) {
        $array[] = array('enrollments_id' => $info['enrollments_id'],
					'students_id' => $info['students_id'],
					'students_first_name' => $info['students_first_name'],
					'students_last_name' => $info['students_last_name'],
					'grade' => $info['grade'],
					'families_id' => $info['families_id'],
					'customers_id' => $info['customers_id'],
					'students_status' => $info['students_status'],
					'disabilities' => $info['disabilities'],
					'allergies' => $info['allergies'],
					'medications' => $info['medications']
					
		
				 );
				 }
				 
		   return $array;
	  } 
	  
	  function tep_get_incident_report($incident_reports_id){
	 $array = array();
	
	 $sql="select * from incident_reports where incident_reports_id=".$incident_reports_id;	
	
	      $query = tep_db_query($sql);
      while ($info = tep_db_fetch_array($query)) {
        $array[] = array('incident_reports_id' => $info['incident_reports_id'],
						'incident_details' => $info['incident_details'],
						'locations_id' => $info['locations_id'],
						'students_id' => $info['students_id'],
						'incident_date' => $info['incident_date'],
						'incident_time' => $info['incident_time'],
						'incident_location' => $info['incident_location'],
						'students_last_name' => $info['students_last_name'],
						'students_first_name' => $info['students_first_name'],
						'grade' => $info['grade'],
						'other_students' => $info['other_students'],
						'witness' => $info['witness'],
						'before_activity' => $info['before_activity'],
						'in_activity' => $info['in_activity'],
						'first_aid_by' => $info['first_aid_by'],
						'in_office_time' => $info['in_office_time'],
						'return_to' => $info['return_to'],
						'approver' => $info['approver'],
						'approval_notes' => $info['approval_notes'],
						'approval_time' => $info['approval_time'],
						'approval_status' => $info['approval_status'],
						'submitted_time' => $info['submitted_time'],
						'submitted_by' => $info['submitted_by'],
						'status' => $info['status'],
						'last_modified' => $info['last_modified'],
						'last_modified_by' => $info['last_modified_by']
						);
      }
	 
    return $array;
		 }
?>