<?php
/* http://www.sundesignworkshop.com     */

////
// The HTML href link wrapper function
  function tep_href_link($page = '', $parameters = '', $connection = 'NONSSL', $add_session_id = true, $search_engine_safe = true) {
    global $request_type, $session_started, $SID;

    $page = tep_output_string($page);

    if (!tep_not_null($page)) {
      die('</td></tr></table></td></tr></table><br /><br /><font color="#ff0000"><strong>Error!</strong></font><br /><br /><strong>Unable to determine the page link!<br /><br />');
    }

    if ($connection == 'NONSSL') {
      $link = HTTP_SERVER . DIR_WS_HTTP_CATALOG;
    } elseif ($connection == 'SSL') {
      if (ENABLE_SSL == true) {
        $link = HTTPS_SERVER . DIR_WS_HTTPS_CATALOG;
      } else {
        $link = HTTP_SERVER . DIR_WS_HTTP_CATALOG;
      }
    } else {
      die('</td></tr></table></td></tr></table><br /><br /><font color="#ff0000"><strong>Error!</strong></font><br /><br /><strong>Unable to determine connection method on a link!<br /><br />Known methods: NONSSL SSL</strong><br /><br />');
    }

    if (tep_not_null($parameters)) {
      $link .= $page . '?' . tep_output_string($parameters);
      $separator = '&';
    } else {
      $link .= $page;
      $separator = '?';
    }

    while ( (substr($link, -1) == '&') || (substr($link, -1) == '?') ) $link = substr($link, 0, -1);

// Add the session ID when moving from different HTTP and HTTPS servers, or when SID is defined
    if ( ($add_session_id == true) && ($session_started == true) && (SESSION_FORCE_COOKIE_USE == 'False') ) {
      if (tep_not_null($SID)) {
        $_sid = $SID;
      } elseif ( ( ($request_type == 'NONSSL') && ($connection == 'SSL') && (ENABLE_SSL == true) ) || ( ($request_type == 'SSL') && ($connection == 'NONSSL') ) ) {
        if (HTTP_COOKIE_DOMAIN != HTTPS_COOKIE_DOMAIN) {
          $_sid = tep_session_name() . '=' . tep_session_id();
        }
      }
    }

    if (isset($_sid)) {
      $link .= $separator . tep_output_string($_sid);
    }

    while (strstr($link, '&&')) $link = str_replace('&&', '&', $link);

    if ( (SEARCH_ENGINE_FRIENDLY_URLS == 'true') && ($search_engine_safe == true) ) {
      $link = str_replace('?', '/', $link);
      $link = str_replace('&', '/', $link);
      $link = str_replace('=', '/', $link);
    } else {
      $link = str_replace('&', '&amp;', $link);
    }

    return $link;
  }

////
// The HTML image wrapper function
  function tep_image($src, $alt = '', $width = '', $height = '', $parameters = '') {
    if ( (empty($src) || ($src == DIR_WS_IMAGES)) && (IMAGE_REQUIRED == 'false') ) {
      return false;
    }

// alt is added to the img tag even if it is null to prevent browsers from outputting
// the image filename as default
    $image = '<img src="' . tep_output_string($src) . '" alt="' . tep_output_string($alt) . '"';

    if (tep_not_null($alt)) {
      $image .= ' title=" ' . tep_output_string($alt) . ' "';
    }

    if ( (CONFIG_CALCULATE_IMAGE_SIZE == 'true') && (empty($width) || empty($height)) ) {
      if ($image_size = @getimagesize($src)) {
        if (empty($width) && tep_not_null($height)) {
          $ratio = $height / $image_size[1];
          $width = intval($image_size[0] * $ratio);
        } elseif (tep_not_null($width) && empty($height)) {
          $ratio = $width / $image_size[0];
          $height = intval($image_size[1] * $ratio);
        } elseif (empty($width) && empty($height)) {
          $width = $image_size[0];
          $height = $image_size[1];
        }
      } elseif (IMAGE_REQUIRED == 'false') {
        return false;
      }
    }

    if (tep_not_null($width) && tep_not_null($height)) {
      $image .= ' width="' . tep_output_string($width) . '" height="' . tep_output_string($height) . '"';
    }

    if (tep_not_null($parameters)) $image .= ' ' . $parameters;

    $image .= ' />';

    return $image;
  }

////
// The HTML form submit button wrapper function
// Outputs a button in the selected language
  function tep_image_submit($image, $alt = '', $parameters = '') {
    global $language;

    $image_submit = '<input type="image" src="' . tep_output_string(DIR_WS_LANGUAGES . $language . '/images/buttons/' . $image) . '" alt="' . tep_output_string($alt) . '"';

    if (tep_not_null($alt)) $image_submit .= ' title=" ' . tep_output_string($alt) . ' "';

    if (tep_not_null($parameters)) $image_submit .= ' ' . $parameters;

    $image_submit .= ' />';

    return $image_submit;
  }

////
// Output a function button in the selected language
  function tep_image_button($image, $alt = '', $parameters = '') {
    global $language;

    return tep_image(DIR_WS_LANGUAGES . $language . '/images/buttons/' . $image, $alt, '', '', $parameters);
  }

////
// Output a separator either through whitespace, or with an image
  function tep_draw_separator($image = 'pixel_black.gif', $width = '100%', $height = '1') {
    return tep_image(DIR_WS_IMAGES . $image, '', $width, $height);
  }

////
// Output a form
  function tep_draw_form($name, $action, $method = 'post', $parameters = '', $tokenize = false) {
    global $sessiontoken;

    $form = '<form name="' . tep_output_string($name) . '" action="' . tep_output_string($action) . '" method="' . tep_output_string($method) . '"';

    if (tep_not_null($parameters)) $form .= ' ' . $parameters;

    $form .= '>';

    if ( ($tokenize == true) && isset($sessiontoken) ) {
      $form .= '<input type="hidden" name="formid" value="' . tep_output_string($sessiontoken) . '" />';
    }

    return $form;
  }

////
// Output a form input field
  function tep_draw_input_field($name, $value = '', $parameters = '', $type = 'text', $reinsert_value = true ) {
    global $HTTP_GET_VARS, $HTTP_POST_VARS;

    $field = '<input type="' . tep_output_string($type) . '" name="' . tep_output_string($name) . '"';

    if ( ($reinsert_value == true) && ( (isset($HTTP_GET_VARS[$name]) && is_string($HTTP_GET_VARS[$name])) || (isset($HTTP_POST_VARS[$name]) && is_string($HTTP_POST_VARS[$name])) ) ) {
      if (isset($HTTP_GET_VARS[$name]) && is_string($HTTP_GET_VARS[$name])) {
        $value = stripslashes($HTTP_GET_VARS[$name]);
      } elseif (isset($HTTP_POST_VARS[$name]) && is_string($HTTP_POST_VARS[$name])) {
        $value = stripslashes($HTTP_POST_VARS[$name]);
      }
    }

    if (tep_not_null($value)) {
      $field .= ' value="' . tep_output_string($value) . '"';
    }

    if (tep_not_null($parameters)) $field .= ' ' . $parameters;

    $field .= ' />';

    return $field;
  }
// Output a form input field smaller size
  function tep_draw_input_small_field($name, $value = '', $size='',$title='',  $type = 'text',$parameters = '',$reinsert_value = true ) {
    global $HTTP_GET_VARS, $HTTP_POST_VARS;

    $field = '<input type="' . tep_output_string($type) . '" name="' . tep_output_string($name) . '" title="' . tep_output_string($title) . '" size="' . tep_output_string($size) . '"';

    if ( ($reinsert_value == true) && ( (isset($HTTP_GET_VARS[$name]) && is_string($HTTP_GET_VARS[$name])) || (isset($HTTP_POST_VARS[$name]) && is_string($HTTP_POST_VARS[$name])) ) ) {
      if (isset($HTTP_GET_VARS[$name]) && is_string($HTTP_GET_VARS[$name])) {
        $value = stripslashes($HTTP_GET_VARS[$name]);
      } elseif (isset($HTTP_POST_VARS[$name]) && is_string($HTTP_POST_VARS[$name])) {
        $value = stripslashes($HTTP_POST_VARS[$name]);
      }
    }

    if (tep_not_null($value)) {
      $field .= ' value="' . tep_output_string($value) . '"';
    }

    if (tep_not_null($parameters)) $field .= ' ' . $parameters;

    $field .= ' />';

    return $field;
  }
////

// Output a form password field
  function tep_draw_password_field($name, $value = '', $parameters = 'maxlength="40"') {
    return tep_draw_input_field($name, $value, $parameters, 'password', false);
  }

////
// Output a selection field - alias function for tep_draw_checkbox_field() and tep_draw_radio_field()
  function tep_draw_selection_field($name, $type, $value = '', $checked = false, $parameters = '') {
    global $HTTP_GET_VARS, $HTTP_POST_VARS;

    $selection = '<input type="' . tep_output_string($type) . '" name="' . tep_output_string($name) . '"';

    if (tep_not_null($value)) $selection .= ' value="' . tep_output_string($value) . '"';

    if ( ($checked == true) || (isset($HTTP_GET_VARS[$name]) && is_string($HTTP_GET_VARS[$name]) && (($HTTP_GET_VARS[$name] == 'on') || (stripslashes($HTTP_GET_VARS[$name]) == $value))) || (isset($HTTP_POST_VARS[$name]) && is_string($HTTP_POST_VARS[$name]) && (($HTTP_POST_VARS[$name] == 'on') || (stripslashes($HTTP_POST_VARS[$name]) == $value))) ) {
      $selection .= ' checked="checked"';
    }

    if (tep_not_null($parameters)) $selection .= ' ' . $parameters;

    $selection .= ' />';

    return $selection;
  }

  function tep_draw_selection_field_title($name, $type, $value = '', $checked = false, $title='', $parameters = '') {
    global $HTTP_GET_VARS, $HTTP_POST_VARS;

    $selection = '<input type="' . tep_output_string($type) . '" name="' . tep_output_string($name) . '" title="' . tep_output_string($title) . '"';

    if (tep_not_null($value)) $selection .= ' value="' . tep_output_string($value) . '"';

    if ( ($checked == true) || (isset($HTTP_GET_VARS[$name]) && is_string($HTTP_GET_VARS[$name]) && (($HTTP_GET_VARS[$name] == 'on') || (stripslashes($HTTP_GET_VARS[$name]) == $value))) || (isset($HTTP_POST_VARS[$name]) && is_string($HTTP_POST_VARS[$name]) && (($HTTP_POST_VARS[$name] == 'on') || (stripslashes($HTTP_POST_VARS[$name]) == $value))) ) {
      $selection .= ' checked="checked"';
    }

    if (tep_not_null($parameters)) $selection .= ' ' . $parameters;

    $selection .= ' />';
    return $selection;
  }
  // Output a selection field - alias function for tep_draw_checkbox_field() and tep_draw_radio_field()
  function tep_draw_selection_field_title_class($name, $type, $value = '', $checked = false, $title='',$parameters = '',$class='') {
    global $HTTP_GET_VARS, $HTTP_POST_VARS;

    $selection = '<input type="' . tep_output_string($type) . '" name="' . tep_output_string($name) . '" class="' . tep_output_string($class). '" title="' . tep_output_string($title) . '"';

    if (tep_not_null($value)) $selection .= ' value="' . tep_output_string($value) . '" onclick="resetSelectAll(); "';

    if ( ($checked == true) || (isset($HTTP_GET_VARS[$name]) && is_string($HTTP_GET_VARS[$name]) && (($HTTP_GET_VARS[$name] == 'on') || (stripslashes($HTTP_GET_VARS[$name]) == $value))) || (isset($HTTP_POST_VARS[$name]) && is_string($HTTP_POST_VARS[$name]) && (($HTTP_POST_VARS[$name] == 'on') || (stripslashes($HTTP_POST_VARS[$name]) == $value))) ) {
      $selection .= ' checked="checked"';
    }

    if (tep_not_null($parameters)) $selection .= ' ' . $parameters;

    $selection .= ' />';

    return $selection;
  }
  

  
// Output a form checkbox field
  function tep_draw_checkbox_field($name, $value = '', $checked = false, $parameters = '') {
    return tep_draw_selection_field($name, 'checkbox', $value, $checked, $parameters);
  }
/* /////////// need work on--zzz
  function tep_draw_checkbox_field_title($name, $value = '', $checked = false, $title, $parameters = '') {
    return tep_draw_selection_field_title($name, 'checkbox', $value, $checked, $title, $parameters);
  }

  function tep_draw_checkbox_field_title_class($name,  $value = '', $checked = false, $title, $parameters = '', $class='') {
    return tep_draw_selection_field_title_class($name, 'checkbox', $value, $checked, $title, $class, $parameters);
  }
*/
// Output a form radio field
  function tep_draw_radio_field($name, $value = '', $checked = false, $parameters = '') {
    return tep_draw_selection_field($name, 'radio', $value, $checked, $parameters);
  }

// Output a form textarea field
// The $wrap parameter is no longer used in the core xhtml template
  function tep_draw_textarea_field($name, $wrap, $width, $height, $text = '', $parameters = '', $reinsert_value = true) {
    global $HTTP_GET_VARS, $HTTP_POST_VARS;

    $field = '<textarea name="' . tep_output_string($name) . '" cols="' . tep_output_string($width) . '" rows="' . tep_output_string($height) . '"';

    if (tep_not_null($parameters)) $field .= ' ' . $parameters;

    $field .= '>';

    if ( ($reinsert_value == true) && ( (isset($HTTP_GET_VARS[$name]) && is_string($HTTP_GET_VARS[$name])) || (isset($HTTP_POST_VARS[$name]) && is_string($HTTP_POST_VARS[$name])) ) ) {
      if (isset($HTTP_GET_VARS[$name]) && is_string($HTTP_GET_VARS[$name])) {
        $field .= tep_output_string_protected(stripslashes($HTTP_GET_VARS[$name]));
      } elseif (isset($HTTP_POST_VARS[$name]) && is_string($HTTP_POST_VARS[$name])) {
        $field .= tep_output_string_protected(stripslashes($HTTP_POST_VARS[$name]));
      }
    } elseif (tep_not_null($text)) {
      $field .= tep_output_string_protected($text);
    }

    $field .= '</textarea>';

    return $field;
  }

////
// Output a form hidden field
  function tep_draw_hidden_field($name, $value = '', $parameters = '') {
    global $HTTP_GET_VARS, $HTTP_POST_VARS;

    $field = '<input type="hidden" name="' . tep_output_string($name) . '"';

    if (tep_not_null($value)) {
      $field .= ' value="' . tep_output_string($value) . '"';
    } elseif ( (isset($HTTP_GET_VARS[$name]) && is_string($HTTP_GET_VARS[$name])) || (isset($HTTP_POST_VARS[$name]) && is_string($HTTP_POST_VARS[$name])) ) {
      if ( (isset($HTTP_GET_VARS[$name]) && is_string($HTTP_GET_VARS[$name])) ) {
        $field .= ' value="' . tep_output_string(stripslashes($HTTP_GET_VARS[$name])) . '"';
      } elseif ( (isset($HTTP_POST_VARS[$name]) && is_string($HTTP_POST_VARS[$name])) ) {
        $field .= ' value="' . tep_output_string(stripslashes($HTTP_POST_VARS[$name])) . '"';
      }
    }

    if (tep_not_null($parameters)) $field .= ' ' . $parameters;

    $field .= ' />';

    return $field;
  }

////
// Hide form elements
  function tep_hide_session_id() {
    global $session_started, $SID;

    if (($session_started == true) && tep_not_null($SID)) {
      return tep_draw_hidden_field(tep_session_name(), tep_session_id());
    }
  }

////
// Output a form pull down menu
  function tep_draw_pull_down_menu($name, $values, $default = '', $parameters = '', $required = false) {
    global $HTTP_GET_VARS, $HTTP_POST_VARS;

    $field = '<select   name="' . tep_output_string($name) . '"';

    if (tep_not_null($parameters)) $field .= ' ' . $parameters;

    $field .= '>';

    if (empty($default) && ( (isset($HTTP_GET_VARS[$name]) && is_string($HTTP_GET_VARS[$name])) || (isset($HTTP_POST_VARS[$name]) && is_string($HTTP_POST_VARS[$name])) ) ) {
      if (isset($HTTP_GET_VARS[$name]) && is_string($HTTP_GET_VARS[$name])) {
        $default = stripslashes($HTTP_GET_VARS[$name]);
      } elseif (isset($HTTP_POST_VARS[$name]) && is_string($HTTP_POST_VARS[$name])) {
        $default = stripslashes($HTTP_POST_VARS[$name]);
      }
    }

    for ($i=0, $n=sizeof($values); $i<$n; $i++) {
      $field .= '<option value="' . tep_output_string($values[$i]['id']) . '"';
      if ($default == $values[$i]['id']) {
        $field .= ' selected="selected"';
      }

      $field .= '>' . tep_output_string($values[$i]['text'], array('"' => '&quot;', '\'' => '&#039;', '<' => '&lt;', '>' => '&gt;')) . '</option>';
    }
    $field .= '</select>';

    if ($required == true) $field .= TEXT_FIELD_REQUIRED;

    return $field;
  }

  function tep_draw_pull_down_menu_readonly($name, $values, $default = '', $parameters = '', $required = false) {
    global $HTTP_GET_VARS, $HTTP_POST_VARS;
	$selectedValue="";
    $field = '<select   name="' . tep_output_string($name) . '"';

    if (tep_not_null($parameters)) $field .= ' ' . $parameters;
$field .= 'disabled=true';
    $field .= '>';

    if (empty($default) && ( (isset($HTTP_GET_VARS[$name]) && is_string($HTTP_GET_VARS[$name])) || (isset($HTTP_POST_VARS[$name]) && is_string($HTTP_POST_VARS[$name])) ) ) {
      if (isset($HTTP_GET_VARS[$name]) && is_string($HTTP_GET_VARS[$name])) {
        $default = stripslashes($HTTP_GET_VARS[$name]);
      } elseif (isset($HTTP_POST_VARS[$name]) && is_string($HTTP_POST_VARS[$name])) {
        $default = stripslashes($HTTP_POST_VARS[$name]);
      }
    }

    for ($i=0, $n=sizeof($values); $i<$n; $i++) {
      $field .= '<option value="' . tep_output_string($values[$i]['id']) . '"';
      if ($default == $values[$i]['id']) {
		  $selectedValue=$values[$i]['id'];
        $field .= ' selected="selected"';
      }

      $field .= '>' . tep_output_string($values[$i]['text'], array('"' => '&quot;', '\'' => '&#039;', '<' => '&lt;', '>' => '&gt;')) . '</option>';
    }
    $field .= '</select>';
	if($selectedValue!="")
	$field .= '<input type="hidden" name='.$name.' value="'.$selectedValue.'" />';

    if ($required == true) $field .= TEXT_FIELD_REQUIRED;

    return $field;
  }

  //// BEGIN RADIO BUTTON CONTRIBUTION
// Output a form radio menu
 function tep_draw_radio_menu($name, $values, $default = '', $parameters = '', $required = false) {
$field ='<table border="0" cellspacing="0" cellpadding="0"><tr><td class="main">';   
if (empty($default) && isset($GLOBALS[$name])) $default = stripslashes($GLOBALS[$name]);

for ($i=0, $n=sizeof($values); $i<$n; $i++) {
  $value = tep_output_string($values[$i]['id']);
  $field .= '<input type="radio" name="' . $name . '" value="' . $value .'++'. '"';
 if($i==0) 	 $field .= ' checked'; 
if ($i % 2 == 0){
	if ($default == $values[$i]['id']) {
       $field .= ' checked'; 
      }
  $field .= '>' . tep_output_string($values[$i]['text'], array('"' => '"', '\'' => '', '<' => '<', '>' => '>')) . '</br>';
	}
  else{
	  if ($default == $values[$i]['id']) {
       $field .= ' checked'; 
      }
	$field .= '>' . tep_output_string($values[$i]['text'], array('"' => '"', '\'' => '', '<' => '<', '>' => '>')) . '</br>';
 
  }
}
$field .= '</td></tr></table>';

if ($required == true) $field .= TEXT_FIELD_REQUIRED;

return $field;
 }

 
  function tep_draw_radio_menu_modal($name, $values, $default = '', $parameters = '', $required = false) {
$field ='<table border="0" cellspacing="0" cellpadding="0"><tr><td class="main">';   
if (empty($default) && isset($GLOBALS[$name])) $default = stripslashes($GLOBALS[$name]);

for ($i=0, $n=sizeof($values); $i<$n; $i++) {
  $value = tep_output_string($values[$i]['id']);
  $field .= '<input type="radio" name="' . $name . '" value="' . $value . '"';
 if($i==0) 	 $field .= ' checked'; 
if ($i % 2 == 0){
	if ($default == $values[$i]['id']) {
       $field .= ' checked'; 
      }
  $field .= '>' . tep_output_string($values[$i]['text'], array('"' => '"', '\'' => '', '<' => '<', '>' => '>')) . '++</br>';
	}
  else{
	  if ($default == $values[$i]['id']) {
       $field .= ' checked'; 
      }
	$field .= '>' . tep_output_string($values[$i]['text'], array('"' => '"', '\'' => '', '<' => '<', '>' => '>')) . '++</br>';
 
  }
}
$field .= '</td></tr></table>';

if ($required == true) $field .= TEXT_FIELD_REQUIRED;

return $field;
 }
  // Output a form radio menu
 function tep_draw_radio_menu_hover_popup($name, $values, $default = '', $parameters = '', $required = false) {
$field ='<table border="0" cellspacing="0" cellpadding="0"><tr><td class="main">';   
if (empty($default) && isset($GLOBALS[$name])) $default = stripslashes($GLOBALS[$name]);

for ($i=0, $n=sizeof($values); $i<$n; $i++) {
  $value = tep_output_string($values[$i]['id']);
  $field .= '<input type="radio" name="' . $name . '" value="' . $value . '"';
 if($i==0) 	 $field .= ' checked'; 
if ($i % 2 == 0){
	if ($default == $values[$i]['id']) {
       $field .= ' checked'; 
      }
  $field .= '><a href="class_description.php?classes_id="'.$values[$i]['id'] .' title="'. tep_output_string($values[$i]['text'], array('"' => '"', '\'' => '', '<' => '<', '>' => '>')).'">' . tep_output_string($values[$i]['text'], array('"' => '"', '\'' => '', '<' => '<', '>' => '>')) . '</br>';
	}
  else{
	  if ($default == $values[$i]['id']) {
       $field .= ' checked'; 
      }
	$field .= '><a  href="class_description.php?classes_id="'.$values[$i]['id'] .' title="'. tep_output_string($values[$i]['text'], array('"' => '"', '\'' => '', '<' => '<', '>' => '>')).'">' . tep_output_string($values[$i]['text'], array('"' => '"', '\'' => '', '<' => '<', '>' => '>')) . '</a></br>';
 
  }
}
$field .= '</td></tr></table>';

if ($required == true) $field .= TEXT_FIELD_REQUIRED;

return $field;
 }
//// END RADIO BUTTON CONTRIBUTION

// Output a form pull down menu
//// need work on --zzz
/*
  function tep_draw_pull_down_menu_class($name, $values, $class='', $jscript, $default = '', $parameters = '', $required = false) {
    global $HTTP_GET_VARS, $HTTP_POST_VARS;

    $field = '<select name="' . tep_output_string($name) . '"'.'" class="' . tep_output_string($class) . '"'.' '. tep_output_string($jscript);

    if (tep_not_null($parameters)) $field .= ' ' . $parameters;

    $field .= '>';

    if (empty($default) && ( (isset($HTTP_GET_VARS[$name]) && is_string($HTTP_GET_VARS[$name])) || (isset($HTTP_POST_VARS[$name]) && is_string($HTTP_POST_VARS[$name])) ) ) {
      if (isset($HTTP_GET_VARS[$name]) && is_string($HTTP_GET_VARS[$name])) {
        $default = stripslashes($HTTP_GET_VARS[$name]);
      } elseif (isset($HTTP_POST_VARS[$name]) && is_string($HTTP_POST_VARS[$name])) {
        $default = stripslashes($HTTP_POST_VARS[$name]);
      }
    }

    for ($i=0, $n=sizeof($values); $i<$n; $i++) {
      $field .= '<option value="' . tep_output_string($values[$i]['id']) . '"';
      if ($default == $values[$i]['id']) {
        $field .= ' selected="selected"';
      }

      $field .= '>' . tep_output_string($values[$i]['text'], array('"' => '&quot;', '\'' => '&#039;', '<' => '&lt;', '>' => '&gt;')) . '</option>';
    }
    $field .= '</select>';

    if ($required == true) $field .= TEXT_FIELD_REQUIRED;

    return $field; }
////
*/

// Creates a pull-down list of countries
 function tep_get_country_list($name, $selected = '', $parameters = '') {
     $countries_array = array(array('id' => '', 'text' => PULL_DOWN_DEFAULT));
   // $countries_array = [['id' => '', 'text' => PULL_DOWN_DEFAULT]];
    $countries = tep_get_countries();
 
    if (!empty($countries) && is_array($countries)) {
        foreach ($countries as $country) {
                $countries_array[] = [
                    'id' => $country['id'],
                    'text' => $country['text']
                ];
           
        }
  }

    return tep_draw_pull_down_menu($name, $countries_array, $selected, $parameters);
}

////
// Output a jQuery UI Button
  function tep_draw_button($title = null, $icon = null, $link = null, $priority = null, $params = null) {
    static $button_counter = 1;

    $types = array('submit', 'button', 'reset');

    if ( !isset($params['type']) ) {
      $params['type'] = 'submit';
    }

    if ( !in_array($params['type'], $types) ) {
      $params['type'] = 'submit';
    }

    if ( ($params['type'] == 'submit') && isset($link) ) {
      $params['type'] = 'button';
    }

    if (!isset($priority)) {
      $priority = 'secondary';
    }

    $button = '<span class="tdbLink">';

    if ( ($params['type'] == 'button') && isset($link) ) {
      $button .= '<a id="tdb' . $button_counter . '" href="' . $link . '"';

      if ( isset($params['newwindow']) ) {
        $button .= ' target="_blank"';
      }
    } else {
      $button .= '<button id="tdb' . $button_counter . '" type="' . tep_output_string($params['type']) . '"';
    }

    if ( isset($params['params']) ) {
      $button .= ' ' . $params['params'];
    }

    $button .= '>' . $title;

    if ( ($params['type'] == 'button') && isset($link) ) {
      $button .= '</a>';
    } else {
      $button .= '</button>';
    }

    $button .= '</span><script type="text/javascript">$("#tdb' . $button_counter . '").button(';

    $args = array();

    if ( isset($icon) ) {
      if ( !isset($params['iconpos']) ) {
        $params['iconpos'] = 'left';
      }

      if ( $params['iconpos'] == 'left' ) {
        $args[] = 'icons:{primary:"ui-icon-' . $icon . '"}';
      } else {
        $args[] = 'icons:{secondary:"ui-icon-' . $icon . '"}';
      }
    }

    if (empty($title)) {
      $args[] = 'text:false';
    }

    if (!empty($args)) {
      $button .= '{' . implode(',', $args) . '}';
    }

  //  $button .= ').addClass("ui-priority-' . $priority . '").parent().removeClass("tdbLink");</script>';
   $button .= ').addClass("tab_button").parent().removeClass("tdbLink");</script>';
  

    $button_counter++;

    return $button;
  }
  ////
// Creates a pull-down list of day_schools
  function tep_get_day_school_list($name, $selected = '', $parameters = '') {
    $day_schools_array = array(array('id' => '', 'text' => PULL_DOWN_DEFAULT));
    $day_schools = tep_get_day_schools();

    for ($i=0, $n=sizeof($day_schools); $i<$n; $i++) {
      $day_schools_array[] = array('id' => $day_schools[$i]['day_schools_id'], 'text' => $day_schools[$i]['day_schools_name']);
    }

    return tep_draw_pull_down_menu($name, $day_schools_array, $selected, $parameters);
  }

  // Creates a pull-down list of day_schools classes
  function tep_get_day_schools_products_name_list($name, $day_school_id,$grade, $selected = '', $parameters = '') {
    $day_schools_products_name_array = array(array('id' => '', 'text' => PULL_DOWN_DEFAULT));
    $day_schools_products_name = tep_get_day_schools_products_name($day_school_id,$grade);

    for ($i=0, $n=sizeof($day_schools_products_name); $i<$n; $i++) {
      $day_schools_products_name_array[] = array('id' => $day_schools_products_name[$i]['classes_id'], 'text' => $day_schools_products_name[$i]['classes_name']);
    }

    return tep_draw_pull_down_menu($name, $day_schools_products_name_array, $selected, $parameters);
  }
// Creates a pull-down list of grade
  function tep_get_grade_list($name,  $selected = '') {
    $grade_array[] = array('id' => '0', 'text' => PULL_DOWN_DEFAULT);
	 $grade_array[] = array('id' => 'TK', 'text' => 'TK');
	 $grade_array[] = array('id' => 'K', 'text' => 'K');
    for ($i=1, $n=12; $i<$n; $i++) {
      $grade_array[] = array('id' => $i, 'text' => $i);
    }
    return tep_draw_pull_down_menu($name, $grade_array, $selected, $parameters);
  }
   // Creates a pull-down list of schedule types
  function tep_get_schedule_types_list($name,  $selected = '', $parameters = '') {
    $list_array = array(array('id' => '', 'text' => PULL_DOWN_DEFAULT));
    $list = tep_get_schedule_types();

    for ($i=0, $n=sizeof($list); $i<$n; $i++) {
      $list_array[] = array('id' => $list[$i]['schedule_types_id'], 'text' => $list[$i]['schedule_types']);
    }

    return tep_draw_pull_down_menu($name, $list_array, $selected, $parameters);
  }
  	function tep_get_categories_list($name){
	
	$list_array = array(array('id' => '', 'text' => 'Select'));
    $data_array = tep_get_categories( );
    for ($i=0, $n=sizeof($data_array); $i<$n; $i++) {
      $list_array[] = array('id' => $data_array[$i]['classes_categories_id'], 'text' => $data_array[$i]['classes_categories']);
    }
    return tep_draw_pull_down_menu($name, $list_array, $selected, $parameters);
	}
    
	function tep_get_relationship_list($name, $selected = '', $parameters = ''){
	
	$list_array = array(array('id' => '', 'text' => 'Select'));
   
      $list_array[] = array('id' => 'Mother', 'text' => 'Mother');
	  $list_array[] = array('id' => 'Father', 'text' => 'Father');
	   $list_array[] = array('id' => 'Guardian', 'text' => 'Guardian');
   
    return tep_draw_pull_down_menu($name, $list_array, $selected, $parameters);
		}
		
		function tep_get_afterschool_programs_list($name, $selected = '', $parameters = ''){
	
	$list_array = array(array('id' => '', 'text' => 'Select'));
    $data_array = tep_get_afterschool_programs( );
    for ($i=0, $n=sizeof($data_array); $i<$n; $i++) {
      $list_array[] = array('id' => $data_array[$i]['classes_id'], 'text' => $data_array[$i]['classes_name']);
    }
    return tep_draw_pull_down_menu($name, $list_array, $selected, $parameters);
	}
	// Creates a pull-down list of day_schools
  function tep_get_gender_list($name, $selected = '', $parameters = '') {
   $array = array(array('id' => '', 'text' => PULL_DOWN_DEFAULT));
     $array[] = array('id' =>'female', 'text' => 'Female');
	 $array[] = array( 'id' =>'male', 'text' => 'Male');
    return tep_draw_pull_down_menu($name, $array, $selected, $parameters);
  }
  function tep_get_contact_type_list($name, $selected = '', $parameters = '') {
   $array = array(array('id' => '', 'text' => PULL_DOWN_DEFAULT));
     $array[] = array('id' =>'Friend', 'text' => 'Friend');
	   $array[] = array('id' =>'Relative', 'text' => 'Relative'	  );
	  
    return tep_draw_pull_down_menu($name, $array, $selected, $parameters);
  } 
	  
	    function tep_get_lead_resource_list($name, $selected = '', $parameters = '') {
  		 $array = array(array('id' => '', 'text' => PULL_DOWN_DEFAULT));
    	 $array[] = array('id' =>'Newspaper', 'text' => 'Newspaper');
	 	 $array[]= array('id' =>'Friend', 'text' => 'Friend');
	     $array[] = array('id' =>'Advertisement', 'text' => 'Advertisement'	);
		 $array[] = array('id' =>'Internet', 'text' => 'Internet'	);
	
    return tep_draw_pull_down_menu($name, $array, $selected, $parameters);
  }
   /* function tep_get_grade_list($name, $selected = '', $parameters = '') {
   $array = array(array('id' => '', 'text' => PULL_DOWN_DEFAULT));
     $array = array('id' =>'K', 'text' => 'K');
	  for ($i=1; $i<=12; $i++) {
      $list_array[]=array('id' =>$i, 'text' => $i);
	 }
	  
    return tep_draw_pull_down_menu($name, $array, $selected, $parameters);
  }*/
  
    //get full list of full date camp
   function tep_get_full_dates_list($name,  $selected = '', $parameters = '') {
    $list_array = array(array('id' => '', 'text' => PULL_DOWN_DEFAULT));
    $list = tep_get_full_dates();

    for ($i=0, $n=sizeof($list); $i<$n; $i++) {
      $list_array[] = array('id' => $list[$i]['full_dates'], 'text' => $list[$i]['full_dates']);
    }

    return tep_draw_pull_down_menu($name, $list_array, $selected, $parameters);
  }
  
  
  function tep_get_full_dates_checkbox($name,  $selected = '', $parameters = '') {
    $list = tep_get_full_dates();
    for ($i=0, $n=sizeof($list); $i<$n; $i++) {
		  $value=$list[$i]['full_dates'];
    //  $list_array[] = array('id' => $list[$i]['full_dates'], 'text' => $list[$i]['full_dates']);
	// echo tep_draw_checkbox_field($name, $value = $list[$i]['full_dates'], $checked = false, $compare = '');
	// echo tep_draw_selection_field($name, 'checkbox', $value, $checked, $parameters);
 global $HTTP_GET_VARS, $HTTP_POST_VARS;
    $selection = '<input type="checkbox" name='.$name;
    if (tep_not_null($value)) $selection .= ' value='.$value;
    if ( ($checked == true) || (isset($HTTP_GET_VARS[$name]) && is_string($HTTP_GET_VARS[$name]) && (($HTTP_GET_VARS[$name] == 'on') || (stripslashes($HTTP_GET_VARS[$name]) == $value))) || (isset($HTTP_POST_VARS[$name]) && is_string($HTTP_POST_VARS[$name]) && (($HTTP_POST_VARS[$name] == 'on') || (stripslashes($HTTP_POST_VARS[$name]) == $value))) ) {
      $selection .= ' checked="checked"';
    }
    if (tep_not_null($parameters)) $selection .= ' ' . $parameters;
    $selection .= ' />'.$value.'<br />';
    echo $selection;
    }
  }
  
    function tep_get_schools_full_dates_checkbox($day_schools_id,$name,  $selected = '', $parameters = '') {
    $list = tep_get_school_full_dates($day_schools_id);
    for ($i=0, $n=sizeof($list); $i<$n; $i++) {
		  $value=$list[$i]['school_full_dates'];
    //  $list_array[] = array('id' => $list[$i]['full_dates'], 'text' => $list[$i]['full_dates']);
	// echo tep_draw_checkbox_field($name, $value = $list[$i]['full_dates'], $checked = false, $compare = '');
	// echo tep_draw_selection_field($name, 'checkbox', $value, $checked, $parameters);
 global $HTTP_GET_VARS, $HTTP_POST_VARS;
    $selection = '<input type="checkbox" name='.$name;
    if (tep_not_null($value)) $selection .= ' value='.$value;
    if ( ($checked == true) || (isset($HTTP_GET_VARS[$name]) && is_string($HTTP_GET_VARS[$name]) && (($HTTP_GET_VARS[$name] == 'on') || (stripslashes($HTTP_GET_VARS[$name]) == $value))) || (isset($HTTP_POST_VARS[$name]) && is_string($HTTP_POST_VARS[$name]) && (($HTTP_POST_VARS[$name] == 'on') || (stripslashes($HTTP_POST_VARS[$name]) == $value))) ) {
      $selection .= ' checked="checked"';
    }
    if (tep_not_null($parameters)) $selection .= ' ' . $parameters;
    $selection .= ' />'.$value.'<br />';
    echo $selection;
    }
  }
    //get full list of family_students_list
   function tep_get_family_students_list($name, $families_id, $selected = '', $parameters = '') {
    $list_array = array(array('id' => '', 'text' => PULL_DOWN_DEFAULT));
    $list = tep_get_family_students($families_id);

    for ($i=0, $n=sizeof($list); $i<$n; $i++) {
      $list_array[] = array('id' => $list[$i]['students_id'], 'text' => $list[$i]['students_first_name'].' '.$list[$i]['students_last_name']);
    }

    return tep_draw_pull_down_menu($name, $list_array, $selected, $parameters);
  }
 
   function tep_get_summer_program_list( $name, $selected = '', $parameters = '') {
    $list_array = array(array('id' => '', 'text' => PULL_DOWN_DEFAULT));
    $list = tep_get_summer_programs();
	for ($i=0, $n=sizeof($list); $i<$n; $i++) {
     $list_array[] = array('id' => $list[$i]['summer_programs_id'], 'text' => $list[$i]['summer_program']);
	//   $list_array[] = array('id' => $list[$i]['classes_id'], 'text' => $list[$i]['classes_name']);

    }

    return tep_draw_pull_down_menu($name, $list_array, $selected, $parameters);

  }

   function tep_get_summer_addon_list($name,  $selected = '', $parameters = '') {
    $list_array = array(array('id' => '', 'text' => PULL_DOWN_DEFAULT));
      $list_array[] = array('id' => '1', 'text' => 'Lego Fun');
	   $list_array[] = array(  'id' => '2', 'text' => 'Advanced Art'
	  );
   // return tep_draw_pull_down_menu($name, $list_array, $selected, $parameters);
	    return tep_draw_pull_down_menu_class($name, $list_array, 'thelists',"onchange=ajaxFunction(this.value);" ,$selected, $parameters);

  }
  
    function tep_get_summer_addon_lego_week_list($name,  $selected = '', $parameters = '') {
    $list_array = array(array('id' => '', 'text' => 'Please Select Lego Program week'));
    $list_array[] = array('id' => '2', 'text' => '6/17-6/21');
	$list_array[] = array(  'id' => '6', 'text' => '7/15-7/19' );
	$list_array[] = array(  'id' => '10', 'text' => '8/12-8/16' );
	
	
    return tep_draw_pull_down_menu($name, $list_array, $selected, $parameters);
  } 

    function tep_get_summer_addon_art_week_list($name,  $selected = '', $parameters = '') {
    $list_array = array(array('id' => '', 'text' => 'Please Select Art Program week'));
    $list_array[] = array('id' => '3', 'text' => '6/24-6/28');
	$list_array[] = array(  'id' => '5', 'text' => '7/18-7/12' );
	$list_array[] = array(  'id' => '8', 'text' => '7/29-8/02' );
    return tep_draw_pull_down_menu($name, $list_array, $selected, $parameters);
  } 
  
    function tep_get_summer_art_class_list($name,$summer_class_level_id, $week, $selected = '', $parameters = '') {
     $list_array = array(array('id' => '', 'text' => PULL_DOWN_DEFAULT));
    $list = tep_get_summer_art_class($summer_class_level_id,$week);

    for ($i=0, $n=sizeof($list); $i<$n; $i++) {
      $list_array[] = array('id' => $list[$i]['summer_art_classes_id'], 'text' => $list[$i]['summer_art_class']);
    }
 return tep_draw_pull_down_menu($name, $list_array, $selected, $parameters);
    //return tep_draw_radio_menu($name, $list_array, $selected, $parameters);
  }
  
     function tep_get_summer_sports_list($name, $week,$summer_class_level_id, $selected = '', $parameters = '') {
    $list_array = array(array('id' => '', 'text' => PULL_DOWN_DEFAULT));
    $list = tep_get_summer_sports($week,$summer_class_level_id);

    for ($i=0, $n=sizeof($list); $i<$n; $i++) {
      $list_array[] = array('id' => $list[$i]['summer_sports_id'], 'text' => $list[$i]['summer_sport']);
    }

    return tep_draw_pull_down_menu($name, $list_array, $selected, $parameters);
	//return tep_draw_radio_menu($name, $list_array, $selected, $parameters);
  }
  
   function tep_get_summer_art_class_checkbox($name, $summer_class_levels_id,$week, $selected = '', $parameters = '') {
    $list = tep_get_summer_art_class_box($summer_class_levels_id,$week);
	
	if(sizeof($list)==1){
	 echo $list[0]['summer_art_class'];
}
	if(sizeof($list)>1){ 
    for ($i=0, $n=sizeof($list); $i<$n; $i++) {
		if($list[$i]['summer_art_classes_id']==$selected)
		$checked =true;
		else
		$checked=false;
		echo tep_draw_radio_menu($name, $list[$i]['summer_art_classes_id'], $checked); echo $list[$i]['summer_art_class']."<br />";
    }
	
	}
	
  }
  // Output a jQuery UI Button -yellow button
  function tep_draw_yellow_button($title = null, $icon = null, $link = null, $priority = null, $params = null) {
    static $button_counter = 1;

    $types = array('submit', 'button', 'reset');

    if ( !isset($params['type']) ) {
      $params['type'] = 'submit';
    }

    if ( !in_array($params['type'], $types) ) {
      $params['type'] = 'submit';
    }

    if ( ($params['type'] == 'submit') && isset($link) ) {
      $params['type'] = 'button';
    }

    if (!isset($priority)) {
      $priority = 'secondary';
    }

    $button = '<span class="yellow_button">';

    if ( ($params['type'] == 'button') && isset($link) ) {
      $button .= '<a id="tdb' . $button_counter . '" href="' . $link . '"';

      if ( isset($params['newwindow']) ) {
        $button .= ' target="_blank"';
      }
    } else {
      $button .= '<button id="tdb' . $button_counter . '" type="' . tep_output_string($params['type']) . '"';
    }

    if ( isset($params['params']) ) {
      $button .= ' ' . $params['params'];
    }

    $button .= '>' . $title;

    if ( ($params['type'] == 'button') && isset($link) ) {
      $button .= '</a>';
    } else {
      $button .= '</button>';
    }

    $button .= '</span><script type="text/javascript">$("#tdb' . $button_counter . '").button(';

    $args = array();

    if ( isset($icon) ) {
      if ( !isset($params['iconpos']) ) {
        $params['iconpos'] = 'left';
      }

      if ( $params['iconpos'] == 'left' ) {
        $args[] = 'icons:{primary:"ui-icon-' . $icon . '"}';
      } else {
        $args[] = 'icons:{secondary:"ui-icon-' . $icon . '"}';
      }
    }

    if (empty($title)) {
      $args[] = 'text:false';
    }

    if (!empty($args)) {
      $button .= '{' . implode(',', $args) . '}';
    }

    $button .= ').addClass("ui-priority-' . $priority . '").parent().removeClass("tdbLink");</script>';

    $button_counter++;

    return $button;
  }
     function tep_get_morning_class($week, $grade){
	  $morning_query=tep_db_query("SELECT summer_week_description, summer_sports.`summer_week` ,  `summer_sport` ,  `summer_class_level` , class_description, class_status, COUNT(  `summer_sport` ) AS morning
FROM summer_sports, summer_class_levels, summer_weeks, summer_enrollments
WHERE summer_sports.YEAR =2018
AND summer_weeks.summer_week = summer_sports.`summer_week` 
AND summer_class_levels.summer_class_level_id = summer_sports.`summer_class_level_id` 
AND summer_enrollments.summer_week = summer_sports.summer_week
AND summer_enrollments.`summer_sports_id` = summer_sports.`summer_sports_id` 
and summer_sports.`summer_week`=".$week."
and summer_sports.`summer_class_level_id`=".$grade."
GROUP BY summer_week_description,summer_sports.`summer_week` ,  `summer_sport` ,  `summer_class_level`
order by summer_sports.`summer_class_level_id` ");
	 while ($info = tep_db_fetch_array($morning_query)) {
		$status="<img src='http://ingenius.us/enroll/images/status_green.png' width='10px'/>";
		if ($info['morning']>13)
			$status="<img src='http://ingenius.us/enroll/images/status_yellow.png' width='10px'/>";
		if ($info['class_status']=='F')
			$status="<img src='http://ingenius.us/enroll/images/status_yellow.png' width='10px'/>";
		if ($info['morning']>=7&&($grade==4||$grade==5))
			$status="<img src='http://ingenius.us/enroll/images/status_yellow.png' width='10px'/>";
			if (($info['morning']>=11 && $grade==1))
                 $status="<img src='http://ingenius.us/enroll/images/status_yellow.png' width='10px'/>";
		if ($info['class_status']=='N')
			$status="<img src='http://ingenius.us/enroll/images/status_red.png' width='10px'/>";
		echo "<div >";
		//echo $status."<font color='#006CB7'> ";
		echo $info['summer_sport']."</font></div>";
	//echo "<br>";
	 }
 }
   function tep_get_morning_class_description($week, $grade){
	  $morning_query=tep_db_query("SELECT summer_week_description, summer_sports.`summer_week` ,  `summer_sport` ,  `summer_class_level` , class_description, class_status, COUNT(  `summer_sport` ) AS morning
FROM summer_sports, summer_class_levels, summer_weeks, summer_enrollments
WHERE summer_sports.YEAR =2018
AND summer_weeks.summer_week = summer_sports.`summer_week` 
AND summer_class_levels.summer_class_level_id = summer_sports.`summer_class_level_id` 
AND summer_enrollments.summer_week = summer_sports.summer_week
AND summer_enrollments.`summer_sports_id` = summer_sports.`summer_sports_id` 
and summer_sports.`summer_week`=".$week."
and summer_sports.`summer_class_level_id`=".$grade."
GROUP BY summer_week_description,summer_sports.`summer_week` ,  `summer_sport` ,  `summer_class_level`
order by summer_sports.`summer_class_level_id` ");
	 while ($info = tep_db_fetch_array($morning_query)) {
		$status="<img src='http://ingenius.us/enroll/images/status_green.png' width='15px'/>";
		if ($info['morning']>13)
			$status="<img src='http://ingenius.us/enroll/images/status_yellow.png' width='15px'/>";
		if ($info['class_status']=='F')
			$status="<img src='http://ingenius.us/enroll/images/status_yellow.png' width='15px'/>";
		if ($info['morning']>=7&&($grade==4||$grade==5))
			$status="<img src='http://ingenius.us/enroll/images/status_yellow.png' width='15px'/>";
		if ($info['class_status']=='N')
			$status="<img src='http://ingenius.us/enroll/images/status_red.png' width='15px'/>";
		if (($info['morning']>=11 && $grade==1))
                 $status="<img src='http://ingenius.us/enroll/images/status_yellow.png' width='15px'/>";
		echo "<div >";
		//echo $status."<font color='#006CB7'><b> ";
		echo $info['summer_sport']."</b></font></div>";
	echo "<div >"
		.$info['class_description']."</div><br>";
	 }
 }
  function tep_get_after_class($week, $grade){
	      $afternoon_query=tep_db_query("SELECT summer_week_description, summer_art_classes.`summer_week` ,  `summer_art_class` ,  `summer_class_level` , class_description, class_status, COUNT(  `summer_art_class` ) AS afternoon
FROM  `summer_art_classes` , summer_class_levels, summer_weeks, summer_enrollments
WHERE  `summer_art_classes`.`year` =2018
AND summer_weeks.summer_week = summer_art_classes.`summer_week` 
AND summer_class_levels.`summer_class_level_id` = summer_art_classes.`summer_class_levels_id` 
AND summer_enrollments.`summer_week` = summer_art_classes.`summer_week` 
AND summer_enrollments.`summer_art_classes_id` = summer_art_classes.`summer_art_classes_id` 
and summer_art_classes.`summer_week`=".$week." 
and summer_art_classes.`summer_class_levels_id`=".$grade." 
GROUP BY summer_week_description,summer_art_classes.`summer_week` ,  `summer_art_class`,`summer_class_level` 
order by summer_art_classes.`summer_class_levels_id`
");
	 while ($info = tep_db_fetch_array($afternoon_query)) {
		$status="<img src='http://ingenius.us/enroll/images/status_green.png' width='10px'/>";
		if ($info['afternoon']>13 && $info['summer_art_class']!="Rhythmic Gymnastics**")
			$status="<img src='http://ingenius.us/enroll/images/status_yellow.png' width='10px'/>";
		if ($info['class_status']=='F')
			$status="<img src='http://ingenius.us/enroll/images/status_yellow.png' width='10px'/>";
		if ($info['afternoon']>=7&&($grade==4||$grade==5))
			$status="<img src='http://ingenius.us/enroll/images/status_yellow.png' width='10px'/>";
        if (($info['afternoon']>11 && $grade==1))
                 $status="<img src='http://ingenius.us/enroll/images/status_yellow.png' width='10px'/>";
		if ($info['class_status']=='N')
			$status="<img src='http://ingenius.us/enroll/images/status_red.png' width='10px'/>";
		echo "<div  >";
		//echo $status." <font color='#006CB7'> ";
		echo $info['summer_art_class']."</font></div>";
	//echo "<br>";
	 }
  }
 
  function tep_get_after_class_description($week, $grade){
	      $afternoon_query=tep_db_query("SELECT summer_week_description, summer_art_classes.`summer_week` ,  `summer_art_class` ,  `summer_class_level` , class_description, class_status, COUNT(  `summer_art_class` ) AS afternoon
FROM  `summer_art_classes` , summer_class_levels, summer_weeks, summer_enrollments
WHERE  `summer_art_classes`.`year` =2018
AND summer_weeks.summer_week = summer_art_classes.`summer_week` 
AND summer_class_levels.`summer_class_level_id` = summer_art_classes.`summer_class_levels_id` 
AND summer_enrollments.`summer_week` = summer_art_classes.`summer_week` 
AND summer_enrollments.`summer_art_classes_id` = summer_art_classes.`summer_art_classes_id` 
and summer_art_classes.`summer_week`=".$week." 
and summer_art_classes.`summer_class_levels_id`=".$grade." 
GROUP BY summer_week_description,summer_art_classes.`summer_week` ,  `summer_art_class`,`summer_class_level` 
order by summer_art_classes.`summer_class_levels_id`
");
	 while ($info = tep_db_fetch_array($afternoon_query)) {
		$status="<img src='http://ingenius.us/enroll/images/status_green.png' width='15px'/>";
		if ($info['afternoon']>=13 && $info['summer_art_class']!="Rhythmic Gymnastics**")
			$status="<img src='http://ingenius.us/enroll/images/status_yellow.png' width='15px'/>";
		if ($info['class_status']=='F')
			$status="<img src='http://ingenius.us/enroll/images/status_yellow.png' width='15px'/>";
		if ($info['afternoon']>=7&&($grade==4||$grade==5))
			$status="<img src='http://ingenius.us/enroll/images/status_yellow.png' width='15px'/>";
        if (($info['afternoon']>=11 && $grade==1))
                 $status="<img src='http://ingenius.us/enroll/images/status_yellow.png' width='15px'/>";
		if ($info['class_status']=='N')
			$status="<img src='http://ingenius.us/enroll/images/status_red.png' width='15px'/>";
		echo "<div  >";
		//echo $status." <font color='#006CB7'><b> ";
		echo $info['summer_art_class']."</b></font></div>";
	echo "<div >"
		.$info['class_description']."</div><br>";
	 }
  }
  

  function tep_get_class_description($week, $grade,$class_period,$year,$locations_id){
	  
	  //get all classes description with enrollment count
	/*   $sql="SELECT summer_classes.summer_classes_id, summer_week_id, summer_week_description, summer_classes.`summer_week` , `summer_class_name` , `summer_class_level` , class_description, class_status, summer_classes.year, summer_classes.locations_id, COUNT( `summer_class_name` ) AS morning
FROM summer_classes, summer_class_levels, summer_weeks, summer_enrollments
WHERE summer_classes.YEAR =".$year."
AND class_period = '".$class_period."'
AND summer_weeks.summer_week = summer_classes.`summer_week`
and  summer_weeks.summer_year= summer_classes.`year`
and summer_weeks.locations_id= summer_classes.`locations_id`
AND summer_class_levels.summer_class_level_id = summer_classes.`summer_class_level_id`
AND summer_enrollments.summer_week = summer_classes.summer_week
AND summer_enrollments.`summer_sports_id` = summer_classes.`summer_classes_id`
AND summer_classes.`summer_week` =".$week."
AND summer_classes.`summer_class_level_id` =".$grade."
and summer_classes.locations_id=".$locations_id."
GROUP BY summer_week_description, summer_classes.`summer_week` , `summer_class_name` , `summer_class_level`
ORDER BY summer_classes.`summer_class_level_id` ";
*/
	  
	    //get all classes description without enrollment count
	   $sql="SELECT summer_classes.summer_classes_id, summer_week_id, summer_week_description, summer_classes.`summer_week` , `summer_class_name` , 
	  `summer_class_level` , courses.courses_description, class_status, summer_classes.year, summer_classes.locations_id
FROM summer_classes, summer_class_levels, summer_weeks,courses
WHERE 
 summer_classes.courses_id=courses.courses_id
And summer_classes.YEAR =".$year."
AND class_period = '".$class_period."'
AND summer_weeks.summer_week = summer_classes.`summer_week`
and  summer_weeks.summer_year= summer_classes.`year`
and summer_weeks.locations_id= summer_classes.`locations_id`
AND summer_class_levels.summer_class_level_id = summer_classes.`summer_class_level_id`
AND summer_classes.`summer_week` =".$week."
AND summer_classes.`summer_class_level_id` =".$grade."
and summer_classes.locations_id=".$locations_id."
GROUP BY summer_classes.summer_classes_id, summer_week_id, summer_week_description, summer_classes.`summer_week` , `summer_class_name` , 
	  `summer_class_level` , courses.courses_description, class_status, summer_classes.year, summer_classes.locations_id
ORDER BY summer_classes.`summer_class_level_id` ";
	  $query=tep_db_query($sql);
	 while ($info = tep_db_fetch_array($query)) {
		 
		 $stucount=tep_count_class_enrollment($info['summer_classes_id'],$class_period,$year);
		$status="<img src='http://ingenius.us/enroll/images/status_green.png' width='10px'/>";
		if ($info['class_status']=='N'||$info['class_status']=='F'){
			$status="<img src='http://ingenius.us/enroll/images/status_red.png' width='10px'/>";
		}
		else{
			if ($stucount>10)
			$status="<img src='http://ingenius.us/enroll/images/status_yellow.png' width='10px'/>";	
		/*if ($stucount>13)
			$status="<img src='http://ingenius.us/enroll/images/status_yellow.png' width='10px'/>";	
		if ($stucount>=7&&($grade==4||$grade==5))
			$status="<img src='http://ingenius.us/enroll/images/status_yellow.png' width='10px'/>";
		if ($stucount>=10&&($grade==6))
			$status="<img src='http://ingenius.us/enroll/images/status_yellow.png' width='10px'/>";
		if (($stucount>=11 && $grade==1))
            $status="<img src='http://ingenius.us/enroll/images/status_yellow.png' width='10px'/>";
		*/
		}
		echo "<div >";
		echo $status."<font color='#006CB7'><b> ";
		echo $info['summer_class_name']."</b></font></div>";
	echo "<div >"
		.$info['courses_description']."</div><br>";
	 }
 }
  
  // Output a form checkbox field
   // need work ---zzz
  function tep_draw_checkbox_field_title_readonly($name, $value = '', $checked = false, $title='', $parameters = '') {
    return tep_draw_selection_field_title_readonly($name, 'checkbox', $value, $checked, $title, $parameters);
  }

   function tep_draw_selection_field_title_readonly($name, $type, $value = '', $checked = false, $title='',$parameters = '') {
    global $HTTP_GET_VARS, $HTTP_POST_VARS;

    $selection = '<input type="' . tep_output_string($type) . '" name="' . tep_output_string($name) . '" title="' . tep_output_string($title) . '"';

    if (tep_not_null($value)) $selection .= ' value="' . tep_output_string($value) . '"';

    if ( ($checked == true) || (isset($HTTP_GET_VARS[$name]) && is_string($HTTP_GET_VARS[$name]) && (($HTTP_GET_VARS[$name] == 'on') || (stripslashes($HTTP_GET_VARS[$name]) == $value))) || (isset($HTTP_POST_VARS[$name]) && is_string($HTTP_POST_VARS[$name]) && (($HTTP_POST_VARS[$name] == 'on') || (stripslashes($HTTP_POST_VARS[$name]) == $value))) ) {
      $selection .= ' checked="checked"';
    }
 $selection .= ' disabled="disabled"';
    if (tep_not_null($parameters)) $selection .= ' ' . $parameters;

    $selection .= ' />';

    return $selection;
  }
  
      //get full list of summer class levels
   function tep_get_summer_class_levels_list($name,$locations_id,$year, $selected = '', $parameters = '') {
    $list_array = array(array('id' => '', 'text' => PULL_DOWN_DEFAULT));
    $list = tep_get_summer_class_levels($locations_id,$year);

    for ($i=0, $n=sizeof($list); $i<$n; $i++) {
      $list_array[] = array('id' => $list[$i]['summer_class_level_id'], 'text' => $list[$i]['summer_class_level']);
    }

    return tep_draw_pull_down_menu_class($name, $list_array, 'thechoices',"onchange=ajaxFunction(this.value);" ,$selected, $parameters);
  }
  
   function tep_draw_checkbox_field_title_readonly1($name, $value = '', $checked = false,$title='', $parameters = '') {
    return tep_draw_selection_field_title_readonly1($name, 'checkbox', $value, $checked,$title, $parameters);
  }

     function tep_draw_selection_field_title_readonly1($name, $type, $value = '', $checked = false, $title='',$parameters = '') {
    global $HTTP_GET_VARS, $HTTP_POST_VARS;

    $selection = '<input type="' . tep_output_string($type) . '" name="' . tep_output_string($name) . '" title="' . tep_output_string($title) . '"';

    if (tep_not_null($value)) $selection .= ' value="' . tep_output_string($value) . '"';

    if ( ($checked == true) || (isset($HTTP_GET_VARS[$name]) && is_string($HTTP_GET_VARS[$name]) && (($HTTP_GET_VARS[$name] == 'on') || (stripslashes($HTTP_GET_VARS[$name]) == $value))) || (isset($HTTP_POST_VARS[$name]) && is_string($HTTP_POST_VARS[$name]) && (($HTTP_POST_VARS[$name] == 'on') || (stripslashes($HTTP_POST_VARS[$name]) == $value))) ) {
      $selection .= ' checked="checked"';
    }
// $selection .= ' disabled="disabled"';
$selection.= ' onclick="event.preventDefault();"';
   if (tep_not_null($parameters)) $selection .= ' ' . $parameters;

    $selection .= ' />';

    return $selection;
  }
  ///////////////////////new or update functions 2020 ////////////////////////////
 /*     function tep_get_summer_class_list($name,$summer_class_level_id, $week, $class_period, $locations_id,$year,$class_status='', $selected = '', $parameters = '') {
   //  $list_array = array(array('id' => '', 'text' => PULL_DOWN_DEFAULT));
   $list_array = array(array('id' => '', 'text' => ''));
  if($class_period=="Aftercamp"){
	  $class_period="Aftercamp1";
  }
		$list = tep_get_summer_classes($summer_class_level_id,$week,$class_period, $locations_id,$year,$class_status);
	
	if($class_period=="Aftercamp1"){	
		if(sizeof($list)){			
		$list_array[] = array('id' => 1, 'text' => 'Attend Aftercamp');		
		}
	}
	else{
	for ($i=0, $n=sizeof($list); $i<$n; $i++) {
      $list_array[] = array('id' => $list[$i]['summer_classes_id'], 'text' => $list[$i]['courses_name']);
		}
	}
    return tep_draw_pull_down_menu($name, $list_array, $selected, $parameters);
  }
  */
   ///////////////////////new or update functions 2023////////////////////////////
   ////// after school one  choice: attend or not ///////////////
 /*     function tep_get_summer_class_simple_list($name,$summer_class_level_id, $week, $class_period, $locations_id,$year,$class_status='', $selected = '', $parameters = '') {
    // $list_array = array(array('id' => '', 'text' => PULL_DOWN_DEFAULT));

	$list_array = array(array('id' => '', 'text' => ''));
    $list = tep_get_summer_classes($summer_class_level_id,$week,$class_period, $locations_id,$year,$class_status);
	
	if(sizeof($list)){
		$list_array[] = array('id' => 1, 'text' => 'Attend Aftercamp');		
		}
	}	

    return tep_draw_pull_down_menu($name, $list_array, $selected, $parameters);
  }

   function tep_get_summer_class_for_change_list($name,$summer_class_level_id, $week, $class_period, $locations_id,$year,$class_status='', $enrollments_id,$selected = '', $parameters = '') {
   //  $list_array = array(array('id' => '', 'text' => PULL_DOWN_DEFAULT));
   $list_array = array(array('id' => '', 'text' => ''));
  if($class_period=="Aftercamp"){
	  $class_period="Aftercamp1";
  }
		$list = tep_get_summer_classes_enrolled_for_change($summer_class_level_id,$week,$class_period,$locations_id,$year,$class_status='',$enrollments_id);
	
	if($class_period=="Aftercamp1"){	
		if(sizeof($list)){			
		$list_array[] = array('id' => 1, 'text' => 'Attend Aftercamp');		
		}
	}
	else{
	for ($i=0, $n=sizeof($list); $i<$n; $i++) {
      $list_array[] = array('id' => $list[$i]['summer_classes_id'], 'text' => $list[$i]['courses_name']);
		}
	}
    return tep_draw_pull_down_menu($name, $list_array, $selected, $parameters);
  }
    */
   function tep_get_summer_class($week, $summer_class_level_id,$class_period, $locations_id,$year){

	 $count=0;$class_status="";
	   $list_array = array(array('id' => '', 'text' => PULL_DOWN_DEFAULT));
    $list = tep_get_summer_classes($summer_class_level_id,$week,$class_period, $locations_id,$year);	

	if ($list>0){
			for ($i=0, $n=sizeof($list); $i<$n; $i++) {
     // $list_array[] = array('id' => $list[$i]['summer_classes_id'], 'text' => $list[$i]['summer_class_name']);
  $count=tep_count_class_enrollment($list[$i]['summer_classes_id'],$class_period,$year);
    $class_status=check_class_availability($list[$i]['summer_classes_id']);
   
		$status="<img src='http://ingenius.us/enroll/images/status_green.png' width='10px'/>";
		if ($count>13 && $info['summer_class_name']!="Rhythmic Gymnastics**")
			$status="<img src='http://ingenius.us/enroll/images/status_yellow.png' width='10px'/>";
		if ($class_status=='F')
			$status="<img src='http://ingenius.us/enroll/images/status_yellow.png' width='10px'/>";
		if ($count>=7&&($grade==4||$grade==5))
			$status="<img src='http://ingenius.us/enroll/images/status_yellow.png' width='10px'/>";
        if (($count>11 && $grade==1))
                 $status="<img src='http://ingenius.us/enroll/images/status_yellow.png' width='10px'/>";
		if ($class_status=='N')
			$status="<img src='http://ingenius.us/enroll/images/status_red.png' width='10px'/>";
		
		echo "<div  >";
		echo $status." <font color='#006CB7'> ";
		echo  $list[$i]['summer_class_name']."</font></div>";
	//echo "<br>";
	 }
	}

	else{
		echo "No result found";
		
	}
  }
     function tep_get_summer_class_list_2023($name,$summer_class_levels_id,$grade, $week, $class_period, $locations_id,$year,$class_status='', $selected = '', $parameters = '') {
   //  $list_array = array(array('id' => '', 'text' => PULL_DOWN_DEFAULT));
   $list_array = array(array('id' => '', 'text' => ''));
  if($class_period=="Aftercamp"){
	  $class_period="Aftercamp1";
  }
		$list = tep_get_summer_classes_2023($summer_class_levels_id,$grade,$week,$class_period, $locations_id,$year,$class_status);
	
	if($class_period=="Aftercamp1"){	
		if(sizeof($list)){			
		$list_array[] = array('id' => 1, 'text' => 'Attend Aftercamp');		
		}
	}
	else{
	for ($i=0, $n=sizeof($list); $i<$n; $i++) {
     // $list_array[] = array('id' => $list[$i]['summer_classes_id'], 'text' => $list[$i]['courses_name']);
	 $list_array[] = array('id' => $list[$i]['summer_classes_id'], 'text' => $list[$i]['summer_class_name']);
		}
	}
    return tep_draw_pull_down_menu($name, $list_array, $selected, $parameters);
  }
  
  //need work ---zzz
  /*function tep_get_summer_class_for_change_list_2023($name,$summer_class_level_id,$grade, $week, $class_period, $locations_id,$year,$class_status='', $enrollments_id,$selected = '', $parameters = '') {
   $list_array = array(array('id' => '', 'text' => ''));
  if($class_period=="Aftercamp"){
	  $class_period="Aftercamp1";
  }
		$list = tep_get_summer_classes_enrolled_for_change_2023($summer_class_level_id,$grade,$week,$class_period,$locations_id,$year,$class_status='',$enrollments_id);
	
	if($class_period=="Aftercamp1"){	
		if(sizeof($list)){			
		$list_array[] = array('id' => 1, 'text' => 'Attend Aftercamp');		
		}
	}
	else{
	for ($i=0, $n=sizeof($list); $i<$n; $i++) {
      $list_array[] = array('id' => $list[$i]['summer_classes_id'], 'text' => $list[$i]['courses_name']);
		}
	}
    return tep_draw_pull_down_menu($name, $list_array, $selected, $parameters);
  } 

  function tep_get_summer_class_for_change_list_2023_readonly($name,$summer_class_level_id,$grade, $week, $class_period, $locations_id,$year,$class_status='', $enrollments_id,$selected = '', $parameters = '') {
   //  $list_array = array(array('id' => '', 'text' => PULL_DOWN_DEFAULT));
   $list_array = array(array('id' => '', 'text' => ''));
  if($class_period=="Aftercamp"){
	  $class_period="Aftercamp1";
  }
		$list = tep_get_summer_classes_enrolled_for_change_2023($summer_class_level_id,$grade,$week,$class_period,$locations_id,$year,$class_status='',$enrollments_id);
	
	if($class_period=="Aftercamp1"){	
		if(sizeof($list)){			
		$list_array[] = array('id' => 1, 'text' => 'Attend Aftercamp');		
		}
	}
	else{
	for ($i=0, $n=sizeof($list); $i<$n; $i++) {
      $list_array[] = array('id' => $list[$i]['summer_classes_id'], 'text' => $list[$i]['courses_name']);
		}
	}
    return tep_draw_pull_down_menu_readonly($name, $list_array, $selected, $parameters);
  }      */
  ?>