<?php
/* http://www.sundesignworkshop.com     */

////
// The HTML href link wrapper function
  function tep_href_link($page = '', $parameters = '', $connection = 'SSL') {
    $page = tep_output_string($page);

    if ($page == '') {
    //  die('</td></tr></table></td></tr></table><br /><br /><font color="#ff0000"><strong>Error!</strong></font><br /><br /><strong>Unable to determine the page link!<br /><br />Function used:<br /><br />tep_href_link(\'' . $page . '\', \'' . $parameters . '\', \'' . $connection . '\')</strong>');
    $page = basename($HTTP_SERVER_VARS['PHP_SELF']);
	}
    if ($connection == 'NONSSL') {
      $link = HTTP_SERVER . DIR_WS_ADMIN;
    } elseif ($connection == 'SSL') {
      if (ENABLE_SSL_CATALOG == 'true') {
        $link = HTTPS_SERVER . DIR_WS_ADMIN;
      } else {
        $link = HTTP_SERVER . DIR_WS_ADMIN;
      }
    } else {
      die('</td></tr></table></td></tr></table><br /><br /><font color="#ff0000"><strong>Error!</strong></font><br /><br /><strong>Unable to determine connection method on a link!<br /><br />Known methods: NONSSL SSL<br /><br />Function used:<br /><br />tep_href_link(\'' . $page . '\', \'' . $parameters . '\', \'' . $connection . '\')</strong>');
    }
    if ($parameters == '') {
      $link = $link . $page . '?' . SID;
    } else {
      $link = $link . $page . '?' . tep_output_string($parameters) . '&' . SID;
    }

    while ( (substr($link, -1) == '&') || (substr($link, -1) == '?') ) $link = substr($link, 0, -1);

    return $link;
  }

  function tep_catalog_href_link($page = '', $parameters = '', $connection = 'SSL') {
    if ($connection == 'NONSSL') {
      $link = HTTP_CATALOG_SERVER . DIR_WS_CATALOG;
    } elseif ($connection == 'SSL') {
      if (ENABLE_SSL_CATALOG == 'true') {
        $link = HTTPS_CATALOG_SERVER . DIR_WS_CATALOG;
      } else {
        $link = HTTP_CATALOG_SERVER . DIR_WS_CATALOG;
      }
    } else {
      die('</td></tr></table></td></tr></table><br /><br /><font color="#ff0000"><strong>Error!</strong></font><br /><br /><strong>Unable to determine connection method on a link!<br /><br />Known methods: NONSSL SSL<br /><br />Function used:<br /><br />tep_href_link(\'' . $page . '\', \'' . $parameters . '\', \'' . $connection . '\')</strong>');
    }
    if ($parameters == '') {
      $link .= $page;
    } else {
      $link .= $page . '?' . $parameters;
    }

    while ( (substr($link, -1) == '&') || (substr($link, -1) == '?') ) $link = substr($link, 0, -1);

    return $link;
  }

////
// The HTML image wrapper function
  function tep_image($src, $alt = '', $width = '', $height = '', $parameters = '') {
    $image = '<img src="' . tep_output_string($src) . '" border="0" alt="' . tep_output_string($alt) . '"';

    if (tep_not_null($alt)) {
      $image .= ' title=" ' . tep_output_string($alt) . ' "';
    }

    if (tep_not_null($width) && tep_not_null($height)) {
      $image .= ' width="' . tep_output_string($width) . '" height="' . tep_output_string($height) . '"';
    }

    if (tep_not_null($parameters)) $image .= ' ' . $parameters;

    $image .= ' />';

    return $image;
  }

////
// The HTML form submit button wrapper function
// Outputs a button in the selected language
  function tep_image_submit($image, $alt = '', $parameters = '') {
    global $language;

    $image_submit = '<input type="image" src="' . tep_output_string(DIR_WS_LANGUAGES . $language . '/images/buttons/' . $image) . '" border="0" alt="' . tep_output_string($alt) . '"';

    if (tep_not_null($alt)) $image_submit .= ' title=" ' . tep_output_string($alt) . ' "';

    if (tep_not_null($parameters)) $image_submit .= ' ' . $parameters;

    $image_submit .= ' />';

    return $image_submit;
  }

////
// Draw a 1 pixel black line
  function tep_black_line() {
    return tep_image(DIR_WS_IMAGES . 'pixel_black.gif', '', '100%', '1');
  }

////
// Output a separator either through whitespace, or with an image
  function tep_draw_separator($image = 'pixel_black.gif', $width = '100%', $height = '1') {
    return tep_image(DIR_WS_IMAGES . $image, '', $width, $height);
  }

////
// Output a function button in the selected language
  function tep_image_button($image, $alt = '', $params = '') {
    global $language;

    return tep_image(DIR_WS_LANGUAGES . $language . '/images/buttons/' . $image, $alt, '', '', $params);
  }

////
// javascript to dynamically update the states/provinces list when the country is changed
// TABLES: zones
  function tep_js_zone_list($country, $form, $field) {
    $countries_query = tep_db_query("select distinct zone_country_id from " . TABLE_ZONES . " order by zone_country_id");
    $num_country = 1;
    $output_string = '';
    while ($countries = tep_db_fetch_array($countries_query)) {
      if ($num_country == 1) {
        $output_string .= '  if (' . $country . ' == "' . $countries['zone_country_id'] . '") {' . "\n";
      } else {
        $output_string .= '  } else if (' . $country . ' == "' . $countries['zone_country_id'] . '") {' . "\n";
      }

      $states_query = tep_db_query("select zone_name, zone_id from " . TABLE_ZONES . " where zone_country_id = '" . $countries['zone_country_id'] . "' order by zone_name");

      $num_state = 1;
      while ($states = tep_db_fetch_array($states_query)) {
        if ($num_state == '1') $output_string .= '    ' . $form . '.' . $field . '.options[0] = new Option("' . PLEASE_SELECT . '", "");' . "\n";
        $output_string .= '    ' . $form . '.' . $field . '.options[' . $num_state . '] = new Option("' . $states['zone_name'] . '", "' . $states['zone_id'] . '");' . "\n";
        $num_state++;
      }
      $num_country++;
    }
    $output_string .= '  } else {' . "\n" .
                      '    ' . $form . '.' . $field . '.options[0] = new Option("' . TYPE_BELOW . '", "");' . "\n" .
                      '  }' . "\n";

    return $output_string;
  }

////
// Output a form
  function tep_draw_form($name, $action, $parameters = '', $method = 'post', $params = '') {
    $form = '<form name="' . tep_output_string($name) . '" action="';
    if (tep_not_null($parameters)) {
      $form .= tep_href_link($action, $parameters,'SSL');
    } else {
      $form .= tep_href_link($action,'','SSL');
    }
    $form .= '" method="' . tep_output_string($method) . '"';
    if (tep_not_null($params)) {
      $form .= ' ' . $params;
    }
    $form .= '>';

    return $form;
  }

////
// Output a form input field
  function tep_draw_input_field($name, $value = '', $parameters = '', $required = false, $type = 'text', $reinsert_value = true,$size='') {
    global $HTTP_GET_VARS, $HTTP_POST_VARS;

    $field = '<input type="' . tep_output_string($type) . '" name="' . tep_output_string($name) . '"';

    if ( ($reinsert_value == true) && ( (isset($HTTP_GET_VARS[$name]) && is_string($HTTP_GET_VARS[$name])) || (isset($HTTP_POST_VARS[$name]) && is_string($HTTP_POST_VARS[$name])) ) ) {
      if (isset($HTTP_GET_VARS[$name]) && is_string($HTTP_GET_VARS[$name])) {
        $value = stripslashes($HTTP_GET_VARS[$name]);
      } elseif (isset($HTTP_POST_VARS[$name]) && is_string($HTTP_POST_VARS[$name])) {
        $value = stripslashes($HTTP_POST_VARS[$name]);
      }
    }

    if (tep_not_null($value)) {
      $field .= ' value="' . tep_output_string($value) . '"';
    }
if (tep_not_null($size)) {
      $field .= ' size="' . tep_output_string($size) . '"';
    }
    if (tep_not_null($parameters)) $field .= ' ' . $parameters;

    $field .= ' />';
 	
    if ($required == true) $field .= TEXT_FIELD_REQUIRED;

    return $field;
  }

////
// Output a form password field
  function tep_draw_password_field($name, $value = '', $required = false) {
    $field = tep_draw_input_field($name, $value, 'maxlength="40"', $required, 'password', false);

    return $field;
  }

////
// Output a form filefield
  function tep_draw_file_field($name, $required = false) {
    $field = tep_draw_input_field($name, '', '', $required, 'file');

    return $field;
  }

////
// Output a selection field - alias function for tep_draw_checkbox_field() and tep_draw_radio_field()
  function tep_draw_selection_field($name, $type, $value = '', $checked = false, $compare = '') {
    global $HTTP_GET_VARS, $HTTP_POST_VARS;

    $selection = '<input type="' . tep_output_string($type) . '" name="' . tep_output_string($name) . '"';

    if (tep_not_null($value)) $selection .= ' value="' . tep_output_string($value) . '"';

    if ( ($checked == true) || (isset($HTTP_GET_VARS[$name]) && is_string($HTTP_GET_VARS[$name]) && (($HTTP_GET_VARS[$name] == 'on') || (stripslashes($HTTP_GET_VARS[$name]) == $value))) || (isset($HTTP_POST_VARS[$name]) && is_string($HTTP_POST_VARS[$name]) && (($HTTP_POST_VARS[$name] == 'on') || (stripslashes($HTTP_POST_VARS[$name]) == $value))) || (tep_not_null($compare) && ($value == $compare)) ) {
      $selection .= ' checked="checked"';
    }

    $selection .= ' />';

    return $selection;
  }

////
// Output a form checkbox field
  function tep_draw_checkbox_field($name, $value = '', $checked = false, $compare = '') {
    return tep_draw_selection_field($name, 'checkbox', $value, $checked, $compare);
  }

////
// Output a form radio field
  function tep_draw_radio_field($name, $value = '', $checked = false, $compare = '') {
    return tep_draw_selection_field($name, 'radio', $value, $checked, $compare);
  }

////
// Output a form textarea field
// The $wrap parameter is no longer used in the core xhtml template
  function tep_draw_textarea_field($name, $wrap, $width, $height, $text = '', $parameters = '', $reinsert_value = true) {
    global $HTTP_GET_VARS, $HTTP_POST_VARS;

    $field = '<textarea name="' . tep_output_string($name) . '" cols="' . tep_output_string($width) . '" rows="' . tep_output_string($height) . '"';

    if (tep_not_null($parameters)) $field .= ' ' . $parameters;

    $field .= '>';

    if ( ($reinsert_value == true) && ( (isset($HTTP_GET_VARS[$name]) && is_string($HTTP_GET_VARS[$name])) || (isset($HTTP_POST_VARS[$name]) && is_string($HTTP_POST_VARS[$name])) ) ) {
      if (isset($HTTP_GET_VARS[$name]) && is_string($HTTP_GET_VARS[$name])) {
        $field .= tep_output_string_protected(stripslashes($HTTP_GET_VARS[$name]));
      } elseif (isset($HTTP_POST_VARS[$name]) && is_string($HTTP_POST_VARS[$name])) {
        $field .= tep_output_string_protected(stripslashes($HTTP_POST_VARS[$name]));
      }
    } elseif (tep_not_null($text)) {
      $field .= tep_output_string_protected($text);
    }

    $field .= '</textarea>';

    return $field;
  }

////
// Output a form hidden field
  function tep_draw_hidden_field($name, $value = '', $parameters = '') {
    global $HTTP_GET_VARS, $HTTP_POST_VARS;

    $field = '<input type="hidden" name="' . tep_output_string($name) . '"';

    if (tep_not_null($value)) {
      $field .= ' value="' . tep_output_string($value) . '"';
    } elseif ( (isset($HTTP_GET_VARS[$name]) && is_string($HTTP_GET_VARS[$name])) || (isset($HTTP_POST_VARS[$name]) && is_string($HTTP_POST_VARS[$name])) ) {
      if ( (isset($HTTP_GET_VARS[$name]) && is_string($HTTP_GET_VARS[$name])) ) {
        $field .= ' value="' . tep_output_string(stripslashes($HTTP_GET_VARS[$name])) . '"';
      } elseif ( (isset($HTTP_POST_VARS[$name]) && is_string($HTTP_POST_VARS[$name])) ) {
        $field .= ' value="' . tep_output_string(stripslashes($HTTP_POST_VARS[$name])) . '"';
      }
    }

    if (tep_not_null($parameters)) $field .= ' ' . $parameters;

    $field .= ' />';

    return $field;
  }

////
// Hide form elements
  function tep_hide_session_id() {
    $string = '';

    if (defined('SID') && tep_not_null(SID)) {
      $string = tep_draw_hidden_field(tep_session_name(), tep_session_id());
    }

    return $string;
  }

////
// Output a form pull down menu
  function tep_draw_pull_down_menu($name, $values, $default = '', $parameters = '', $required = false) {
    global $HTTP_GET_VARS, $HTTP_POST_VARS;

    $field = '<select name="' . tep_output_string($name) . '"';

    if (tep_not_null($parameters)) $field .= ' ' . $parameters;

    $field .= '>';

    if (empty($default) && ( (isset($HTTP_GET_VARS[$name]) && is_string($HTTP_GET_VARS[$name])) || (isset($HTTP_POST_VARS[$name]) && is_string($HTTP_POST_VARS[$name])) ) ) {
      if (isset($HTTP_GET_VARS[$name]) && is_string($HTTP_GET_VARS[$name])) {
        $default = stripslashes($HTTP_GET_VARS[$name]);
      } elseif (isset($HTTP_POST_VARS[$name]) && is_string($HTTP_POST_VARS[$name])) {
        $default = stripslashes($HTTP_POST_VARS[$name]);
      }
    }

    for ($i=0, $n=sizeof($values); $i<$n; $i++) {
      $field .= '<option value="' . tep_output_string($values[$i]['id']) . '"';
      if ($default == $values[$i]['id']) {
        $field .= ' selected="selected"';
      }

      $field .= '>' . tep_output_string($values[$i]['text'], array('"' => '&quot;', '\'' => '&#039;', '<' => '&lt;', '>' => '&gt;')) . '</option>';
    }
    $field .= '</select>';

    if ($required == true) $field .= TEXT_FIELD_REQUIRED;

    return $field;
  }

////
// Output a jQuery UI Button
  function tep_draw_button($title = null, $icon = null, $link = null, $priority = null, $params = null) {
    static $button_counter = 1;

    $types = array('submit', 'button', 'reset');

    if ( !isset($params['type']) ) {
      $params['type'] = 'submit';
    }

    if ( !in_array($params['type'], $types) ) {
      $params['type'] = 'submit';
    }

    if ( ($params['type'] == 'submit') && isset($link) ) {
      $params['type'] = 'button';
    }

    if (!isset($priority)) {
      $priority = 'secondary';
    }

    $button = '<span class="btn btn-primary">';

    if ( ($params['type'] == 'button') && isset($link) ) {
      $button .= '<a id="tdb' . $button_counter . '" href="' . $link . '"';

      if ( isset($params['newwindow']) ) {
        $button .= ' target="_blank"';
      }
    } else {
      $button .= '<button id="tdb' . $button_counter . '" type="' . tep_output_string($params['type']) . '"';
    }

    if ( isset($params['params']) ) {
      $button .= ' ' . $params['params'];
    }

    $button .= '>' . $title;

    if ( ($params['type'] == 'button') && isset($link) ) {
      $button .= '</a>';
    } else {
      $button .= '</button>';
    }

    $button .= '</span><script type="text/javascript">$("#tdb' . $button_counter . '").button(';

    $args = array();

    if ( isset($icon) ) {
      if ( !isset($params['iconpos']) ) {
        $params['iconpos'] = 'left';
      }

      if ( $params['iconpos'] == 'left' ) {
        $args[] = 'icons:{primary:"ui-icon-' . $icon . '"}';
      } else {
        $args[] = 'icons:{secondary:"ui-icon-' . $icon . '"}';
      }
    }

    if (empty($title)) {
      $args[] = 'text:false';
    }

    if (!empty($args)) {
      $button .= '{' . implode(',', $args) . '}';
    }

    $button .= ').addClass("ui-priority-' . $priority . '").parent().removeClass("tdbLink");</script>';

    $button_counter++;

    return $button;
  }
    ////
// Creates a pull-down list of day_schools
  function tep_get_day_school_list($name, $selected = '', $parameters = '') {
    $day_schools_array = array(array('id' => '', 'text' => 'Select One'));
    $day_schools = tep_get_day_schools();

    for ($i=0, $n=sizeof($day_schools); $i<$n; $i++) {
      $day_schools_array[] = array('id' => $day_schools[$i]['day_schools_id'], 'text' => $day_schools[$i]['day_schools_name']);
    }

    return tep_draw_pull_down_menu($name, $day_schools_array, $selected, $parameters);
  }
	function tep_get_categories_list($name){
	
	$list_array = array(array('id' => '', 'text' => 'Select'));
    $data_array = tep_get_categories( );
    for ($i=0, $n=sizeof($data_array); $i<$n; $i++) {
      $list_array[] = array('id' => $data_array[$i]['classes_categories_id'], 'text' => $data_array[$i]['classes_categories']);
    }
    return tep_draw_pull_down_menu($name, $list_array, $selected, $parameters);
	}
  
      ////
// Creates a pull-down list of family_names
  function tep_get_day_family_names($name, $selected = '', $parameters = '') {
    $family_names_array = array(array('id' => '', 'text' => 'Select One'));
    $family_names = tep_get_family_names();

    for ($i=0, $n=sizeof($family_names); $i<$n; $i++) {
      $family_names_array[] = array('id' => $family_names[$i]['families_id'], 'text' => $family_names[$i]['families_name'].', '.$family_names[$i]['families_address']);
    }

    return tep_draw_pull_down_menu($name, $family_names_array, $selected, $parameters);
  }
  
  function tep_get_schedule_types_list($name,  $selected = '', $parameters = '') {
    $list_array = array(array('id' => '', 'text' => 'Select'));
    $list = tep_get_schedule_types();

    for ($i=0, $n=sizeof($list); $i<$n; $i++) {
      $list_array[] = array('id' => $list[$i]['schedule_types_id'], 'text' => $list[$i]['schedule_types']);
    }

    return tep_draw_pull_down_menu($name, $list_array, $selected, $parameters);
  }
  
	// Creates a pull-down list of day_schools
  function tep_get_gender_list($name, $selected = '', $parameters = '') {
   $array = array(array('id' => '', 'text' => PULL_DOWN_DEFAULT));
     $array[] = array('id' =>'female', 'text' => 'Female');
	 $array[] = array( 'id' =>'male', 'text' => 'Male');
    return tep_draw_pull_down_menu($name, $array, $selected, $parameters);
  }
  function tep_get_contact_type_list($name, $selected = '', $parameters = '') {
   $array = array(array('id' => '', 'text' => PULL_DOWN_DEFAULT));
     $array[] = array('id' =>'Friend', 'text' => 'Friend');
	   $array[] = array('id' =>'Relative', 'text' => 'Relative'	  );
	   $array[] = array('id' =>'Nanny', 'text' => 'Nanny'	  );
	  
    return tep_draw_pull_down_menu($name, $array, $selected, $parameters);
  } 
	  
	    function tep_get_lead_resource_list($name, $selected = '', $parameters = '') {
  		 $array = array(array('id' => '', 'text' => PULL_DOWN_DEFAULT));
    	 $array[] = array('id' =>'Newspaper', 'text' => 'Newspaper');
	 	 $array[]= array('id' =>'Friend', 'text' => 'Friend');
	     $array[] = array('id' =>'Advertisement', 'text' => 'Advertisement'	);
		 $array[] = array('id' =>'Internet', 'text' => 'Internet'	);
	
    return tep_draw_pull_down_menu($name, $array, $selected, $parameters);
  }
  function tep_get_relationship_list($name,  $selected = ''){
	
	$list_array = array(array('id' => '', 'text' => 'Select'));
   
      $list_array[] = array('id' => 'Mother', 'text' => 'Mother');
	  $list_array[] = array('id' => 'Father', 'text' => 'Father');
	   $list_array[] = array('id' => 'Guardian', 'text' => 'Guardian');
   
    return tep_draw_pull_down_menu($name, $list_array, $selected, $parameters);
		}
		// Creates a pull-down list of grade
  function tep_get_grade_list($name,  $selected = '') {
    $grade_array = array(array('id' => 0, 'text' => PULL_DOWN_DEFAULT));
	$grade_array[] =array('id' => 'TK', 'text' => 'TK');
	 $grade_array[] =array('id' => 'K', 'text' => 'K');
    for ($i=1, $n=12; $i<$n; $i++) {
      $grade_array[] = array('id' => $i, 'text' => $i);
    }
    return tep_draw_pull_down_menu($name, $grade_array, $selected, $parameters);
  }
function tep_get_afterschool_programs_list($name, $selected = '', $parameters = ''){
	
	$list_array = array(array('id' => '', 'text' => 'Show All'));
    $data_array = tep_get_afterschool_programs( );
    for ($i=0, $n=sizeof($data_array); $i<$n; $i++) {
      $list_array[] = array('id' => $data_array[$i]['classes_id'], 'text' => $data_array[$i]['classes_name']);
    }
    return tep_draw_pull_down_menu($name, $list_array, $selected, $parameters);
	}
	 
 function tep_get_enrollment_status_list($name, $selected = '', $parameters = '') {
  		 $array = array(array('id' => '', 'text' => PULL_DOWN_DEFAULT));
    	 $array[] = array('id' =>'Accepted', 'text' => 'Accepted');
	 	 $array[]= array('id' =>'Waiting List', 'text' => 'Waiting List');
	     $array[] = array('id' =>'Processing', 'text' => 'Processing'	);

    return tep_draw_pull_down_menu($name, $array, $selected, $parameters);
  }
  
 // Output a form checkbox field
  function tep_draw_checkbox_field_title($name, $value = '', $checked = false,$title='', $parameters = '') {
    return tep_draw_selection_field_title($name, 'checkbox', $value, $checked,$title, $parameters);
  }////
 // Output a selection field - alias function for tep_draw_checkbox_field() and tep_draw_radio_field()
  function tep_draw_selection_field_title($name, $type, $value = '', $checked = false, $title='',$parameters = '') {
    global $HTTP_GET_VARS, $HTTP_POST_VARS;

    $selection = '<input type="' . tep_output_string($type) . '" name="' . tep_output_string($name) . '" title="' . tep_output_string($title) . '"';

    if (tep_not_null($value)) $selection .= ' value="' . tep_output_string($value) . '"';

    if ( ($checked == true) || (isset($HTTP_GET_VARS[$name]) && is_string($HTTP_GET_VARS[$name]) && (($HTTP_GET_VARS[$name] == 'on') || (stripslashes($HTTP_GET_VARS[$name]) == $value))) || (isset($HTTP_POST_VARS[$name]) && is_string($HTTP_POST_VARS[$name]) && (($HTTP_POST_VARS[$name] == 'on') || (stripslashes($HTTP_POST_VARS[$name]) == $value))) ) {
      $selection .= ' checked="checked"';
    }

    if (tep_not_null($parameters)) $selection .= ' ' . $parameters;

    $selection .= ' />';

    return $selection;
  }
   function tep_get_summer_class_levels_list($name, $selected = '', $parameters = '') {
    $list_array= array(array('id' => '', 'text' => PULL_DOWN_DEFAULT));
	//$list_array[]= array(array('id' => '99', 'text' => 'All'));
    $list = tep_get_summer_class_levels();

    for ($i=0, $n=sizeof($list); $i<$n; $i++) {
      $list_array[] = array('id' => $list[$i]['summer_class_level_id'], 'text' => $list[$i]['summer_class_level']);
    }

    return tep_draw_pull_down_menu_class($name, $list_array, 'thechoices',"onchange=ajaxFunction(this.value);" ,$selected, $parameters);
  }
   function tep_get_summer_program_list($name, $selected = '', $parameters = '') {
    $list_array = array(array('id' => '', 'text' => PULL_DOWN_DEFAULT));
    $list = tep_get_summer_programs();
	for ($i=0, $n=sizeof($list); $i<$n; $i++) {
     $list_array[] = array('id' => $list[$i]['summer_programs_id'], 'text' => $list[$i]['summer_program']);
	  //  $list_array[] = array('id' => $list[$i]['classes_id'], 'text' => $list[$i]['classes_name']);

    }

    return tep_draw_pull_down_menu($name, $list_array, $selected, $parameters);

  }
   function tep_get_summer_sports_list($name, $week,$summer_class_level_id, $selected = '', $parameters = '') {
  
    $list = tep_get_summer_sports($week,$summer_class_level_id);
	
	if (sizeof($list)==1) {
		for ($i=0, $n=sizeof($list); $i<$n; $i++) {
			 $list_array = array(array('id' => '', 'text' => ''));
      $list_array[] = array('id' => $list[$i]['summer_sports_id'], 'text' => $list[$i]['summer_sport']);
    }
		
	}
	if (sizeof($list)>1 ){
		  $list_array = array(array('id' => '', 'text' => ''));
    for ($i=0, $n=sizeof($list); $i<$n; $i++) {
      $list_array[] = array('id' => $list[$i]['summer_sports_id'], 'text' => $list[$i]['summer_sport']);
    }
	}
    return tep_draw_pull_down_menu($name, $list_array, $selected, $parameters);
  }
  
  // Output a form input field smaller size
  function tep_draw_input_small_field($name, $value = '', $size='',$title='',  $type = 'text',$parameters = '',$reinsert_value = true ) {
    global $HTTP_GET_VARS, $HTTP_POST_VARS;

    $field = '<input type="' . tep_output_string($type) . '" name="' . tep_output_string($name) . '" title="' . tep_output_string($title) . '" size="' . tep_output_string($size) . '"';

    if ( ($reinsert_value == true) && ( (isset($HTTP_GET_VARS[$name]) && is_string($HTTP_GET_VARS[$name])) || (isset($HTTP_POST_VARS[$name]) && is_string($HTTP_POST_VARS[$name])) ) ) {
      if (isset($HTTP_GET_VARS[$name]) && is_string($HTTP_GET_VARS[$name])) {
        $value = stripslashes($HTTP_GET_VARS[$name]);
      } elseif (isset($HTTP_POST_VARS[$name]) && is_string($HTTP_POST_VARS[$name])) {
        $value = stripslashes($HTTP_POST_VARS[$name]);
      }
    }

    if (tep_not_null($value)) {
      $field .= ' value="' . tep_output_string($value) . '"';
    }

    if (tep_not_null($parameters)) $field .= ' ' . $parameters;

    $field .= ' />';

    return $field;
  }
///
// Output a form pull down menu
  function tep_draw_pull_down_menu_class($name, $values, $class='',$jscript='', $default = '', $parameters = '', $required = false) {
    global $HTTP_GET_VARS, $HTTP_POST_VARS;

    $field = '<select name="' . tep_output_string($name) . '"'.'" class="' . tep_output_string($class) . '"'.' '. tep_output_string($jscript);

    if (tep_not_null($parameters)) $field .= ' ' . $parameters;

    $field .= '>';

    if (empty($default) && ( (isset($HTTP_GET_VARS[$name]) && is_string($HTTP_GET_VARS[$name])) || (isset($HTTP_POST_VARS[$name]) && is_string($HTTP_POST_VARS[$name])) ) ) {
      if (isset($HTTP_GET_VARS[$name]) && is_string($HTTP_GET_VARS[$name])) {
        $default = stripslashes($HTTP_GET_VARS[$name]);
      } elseif (isset($HTTP_POST_VARS[$name]) && is_string($HTTP_POST_VARS[$name])) {
        $default = stripslashes($HTTP_POST_VARS[$name]);
      }
    }

    for ($i=0, $n=sizeof($values); $i<$n; $i++) {
      $field .= '<option value="' . tep_output_string($values[$i]['id']) . '"';
      if ($default == $values[$i]['id']) {
        $field .= ' selected="selected"';
      }

      $field .= '>' . tep_output_string($values[$i]['text'], array('"' => '&quot;', '\'' => '&#039;', '<' => '&lt;', '>' => '&gt;')) . '</option>';
    }
    $field .= '</select>';

    if ($required == true) $field .= TEXT_FIELD_REQUIRED;

    return $field;
  }
   function tep_get_summer_art_class_checkbox($name, $summer_class_levels_id,$week, $selected = '', $parameters = '') {
    $list = tep_get_summer_art_class_box($summer_class_levels_id,$week);
	
	if(sizeof($list)==1)
	 echo $list[0]['summer_art_class'];
	if(sizeof($list)>1){
    for ($i=0, $n=sizeof($list); $i<$n; $i++) {
		if($list[$i]['summer_art_classes_id']==$selected)
		$checked =true;
		else
		$checked=false;
		echo tep_draw_radio_field($name, $list[$i]['summer_art_classes_id'], $checked); echo $list[$i]['summer_art_class']."<br />";
    }
	echo "<i>Play-Well TEKnologies requires full week enrollment.</i>";
	}
	
  }
  
     //get full list of family_students_list
   function tep_get_students_list($name,  $selected = '', $parameters = '') {
    $list_array = array(array('id' => '', 'text' => PULL_DOWN_DEFAULT));
    $list = tep_get_students();

    for ($i=0, $n=sizeof($list); $i<$n; $i++) {
      $list_array[] = array('id' => $list[$i]['students_id'], 'text' => $list[$i]['students_id']." ".$list[$i]['students_last_name'].', '.$list[$i]['students_first_name']);
    }

    return tep_draw_pull_down_menu($name, $list_array, $selected, $parameters);
  }
  function tep_get_summer_days_list($name, $selected = '', $parameters = '') {
    $list_array = array(array('id' => '', 'text' => PULL_DOWN_DEFAULT));
    $list = tep_get_summer_days(2014);

    for ($i=0, $n=sizeof($list); $i<$n; $i++) {	
		$d=date("m-d-Y", strtotime($list[$i]['summer_date']));
      $list_array[] = array('id' => $list[$i]['summer_day_id'], 'text' => $d);
    }

    return tep_draw_pull_down_menu($name, $list_array, $selected, $parameters);
  }
   function tep_get_summer_noon_classes_list($name, $selected = '', $parameters = '') {
    $list_array = array(array('id' => '', 'text' => PULL_DOWN_DEFAULT));
   
    for ($i=1, $n=5; $i<=$n; $i++) {	
		$nclass="Noon".$i;
      $list_array[] = array('id' => $nclass, 'text' =>$nclass);
    }
	 $list_array[] = array('id' => 'Lego', 'text' =>'Lego');
    return tep_draw_pull_down_menu($name, $list_array, $selected, $parameters);
  }
 function tep_get_summer_chinese_classes_list($name, $selected = '', $parameters = '') {
    $list_array = array(array('id' => '', 'text' => PULL_DOWN_DEFAULT));
      $list_array[] = array('id' => 'C1', 'text' =>'C1');
	  $list_array[] = array('id' => 'C2', 'text' =>'C2');
	  $list_array[] = array('id' => 'C3', 'text' =>'C3');
	  $list_array[] = array('id' => 'C4', 'text' =>'C4');
	 $list_array[] = array('id' => 'NC1', 'text' =>'NC1');
	  $list_array[] = array('id' => 'NC2', 'text' =>'NC2');
    
    return tep_draw_pull_down_menu($name, $list_array, $selected, $parameters);
  }
   function tep_get_summer_spanish_classes_list($name, $selected = '', $parameters = '') {
    $list_array = array(array('id' => '', 'text' => PULL_DOWN_DEFAULT));
   
    for ($i=1, $n=3; $i<=$n; $i++) {	
		$class="S".$i;
      $list_array[] = array('id' => $class, 'text' =>$class);
    }
    return tep_draw_pull_down_menu($name, $list_array, $selected, $parameters);
  }
 function tep_get_summer_language_classes_list($name, $selected = '', $parameters = '') {
    $list_array = array(array('id' => '', 'text' => PULL_DOWN_DEFAULT));
      $list_array[] = array('id' => 'C1', 'text' =>'C1');
	  $list_array[] = array('id' => 'C2', 'text' =>'C2');
	  $list_array[] = array('id' => 'C3', 'text' =>'C3');
	  $list_array[] = array('id' => 'C4', 'text' =>'C4');
	 $list_array[] = array('id' => 'NC1', 'text' =>'NC1');
	  $list_array[] = array('id' => 'NC2', 'text' =>'NC2');
	    $list_array[] = array('id' => 'S1', 'text' =>'S1');
	$list_array[] = array('id' => 'S2', 'text' =>'S2');
	$list_array[] = array('id' => 'S3', 'text' =>'S3');
    
    return tep_draw_pull_down_menu($name, $list_array, $selected, $parameters);
  }
  
    function tep_get_summer_art_class_list($name,$summer_class_level_id, $week, $selected = '', $parameters = '') {
     
    $list = tep_get_summer_art_class($summer_class_level_id,$week);
if (sizeof($list)==1) {
	$list_array = array(array('id' => '', 'text' => ''));
		 for ($i=0, $n=sizeof($list); $i<$n; $i++) {
      $list_array[] = array('id' => $list[$i]['summer_art_classes_id'], 'text' => $list[$i]['summer_art_class']);
    }
}
if (sizeof($list)>1) {
	$list_array = array(array('id' => '', 'text' => ''));
    for ($i=0, $n=sizeof($list); $i<$n; $i++) {
      $list_array[] = array('id' => $list[$i]['summer_art_classes_id'], 'text' => $list[$i]['summer_art_class']);
    }
}
    return tep_draw_pull_down_menu($name, $list_array, $selected, $parameters);
  }
     function tep_get_summer_pickup_locations_list($name, $selected = '', $parameters = '') {
    $list_array = array(array('id' => '', 'text' => PULL_DOWN_DEFAULT));   
    $list_array[] = array('id' => '4S Ranch', 'text' =>'4S Ranch'); 
     $list_array[] = array('id' => 'Solana Ranch', 'text' =>'Solana Ranch');    
	 $list_array[] = array('id' => 'CCA', 'text' =>'CCA');
    return tep_draw_pull_down_menu($name, $list_array, $selected, $parameters);
  }
   // Output a form checkbox field
  function tep_draw_checkbox_field_title_class($name,  $value = '', $checked = false,$title='',$parameters = '', $class='') {
    return tep_draw_selection_field_title_class($name, 'checkbox', $value, $checked,$title, $class,$parameters);
  }////
 // Output a selection field - alias function for tep_draw_checkbox_field() and tep_draw_radio_field()
  function tep_draw_selection_field_title_class($name, $type, $value = '', $checked = false, $title='',$parameters = '',$class='')  {
    global $HTTP_GET_VARS, $HTTP_POST_VARS;

    $selection = '<input type="' . tep_output_string($type) . '" name="' . tep_output_string($name) . '" class="' . tep_output_string($class). '" title="' . tep_output_string($title) . '"';

    if (tep_not_null($value)) $selection .= ' value="' . tep_output_string($value) . '" onclick="resetSelectAll(); "';

    if ( ($checked == true) || (isset($HTTP_GET_VARS[$name]) && is_string($HTTP_GET_VARS[$name]) && (($HTTP_GET_VARS[$name] == 'on') || (stripslashes($HTTP_GET_VARS[$name]) == $value))) || (isset($HTTP_POST_VARS[$name]) && is_string($HTTP_POST_VARS[$name]) && (($HTTP_POST_VARS[$name] == 'on') || (stripslashes($HTTP_POST_VARS[$name]) == $value))) ) {
      $selection .= ' checked="checked"';
    }

    if (tep_not_null($parameters)) $selection .= ' ' . $parameters;

    $selection .= ' />';

    return $selection;
  }
  
     function tep_get_morning_class($week, $grade){

	 $morning_query=tep_db_query("SELECT summer_week_description,summer_sports.`summer_week` , summer_sports_id, `summer_sport` ,  `summer_class_level`,  class_description, class_status, COUNT(  `summer_sport` ) AS morning
FROM   summer_sports,summer_class_levels,summer_weeks
WHERE  year=2018
and summer_weeks.summer_week=summer_sports.`summer_week`
and summer_class_levels.summer_class_level_id=summer_sports.`summer_class_level_id`
and summer_sports.`summer_week`=".$week."
and summer_sports.`summer_class_level_id`=".$grade."
GROUP BY summer_week_description,summer_sports.`summer_week` ,  `summer_sport` ,  `summer_class_level`
order by summer_sports.`summer_class_level_id` ");
	 while ($info = tep_db_fetch_array($morning_query)) {
		$status="<img src='http://ingenius.us/enroll/images/status_green.png' width='15px'/>";
		if ($info['morning']>15&&$i!=3)
			$status="<img src='http://ingenius.us/enroll/images/status_yellow.png' width='15px'/>";
		if ($info['class_status']=='N')
			$status="<img src='http://ingenius.us/enroll/images/status_red.png' width='15px'/>";
		echo "<div >".$status."<font color='#006CB7'><b> "
		.$info['summer_sport']."</b></font></div>";
	//echo "<div >".$info['class_description']."</div><br>";
	 }
 }
  function tep_get_after_class($week, $grade){
	      $afternoon_query=tep_db_query("SELECT summer_week_description, summer_art_classes.`summer_week` , `summer_art_class` ,summer_art_classes_id, `summer_class_level` , class_description,class_status,  COUNT( `summer_art_class` ) AS afternoon
FROM `summer_art_classes` , summer_class_levels, summer_weeks
WHERE `summer_art_classes`.`year` =2018
AND summer_weeks.summer_week = summer_art_classes.`summer_week`
AND summer_class_levels.`summer_class_level_id` = summer_art_classes.`summer_class_levels_id`
and summer_art_classes.`summer_week`=".$week." 
and summer_art_classes.`summer_class_levels_id`=".$grade." 
GROUP BY summer_week_description,summer_art_classes.`summer_week` ,  `summer_art_class`,`summer_class_level` 
order by summer_art_classes.`summer_class_levels_id`
");
	 while ($info = tep_db_fetch_array($afternoon_query)) {
		$status="<img src='http://ingenius.us/enroll/images/status_green.png' width='15px'/>";
		if ($info['afternoon']>15 && $info['summer_art_class']!="Rhythmic Gymnastics**")
			$status="<img src='http://ingenius.us/enroll/images/status_yellow.png' width='15px'/>";
        if (($info['afternoon']>13 && $grade==1))
                 $status="<img src='http://ingenius.us/enroll/images/status_yellow.png' width='15px'/>";
		if ($info['class_status']=='N')
			$status="<img src='http://ingenius.us/enroll/images/status_red.png' width='15px'/>";
		echo "<div  >".$status." <font color='#006CB7'><b> "
		.$info['summer_art_class']."</b></font></div>";
	//echo "<div >".$info['class_description']."</div><br>";
	 }
  }
  
  function tep_get_employees_list($name,  $selected = '', $parameters = '') {
    $list_array = array(array('id' => '', 'text' => ''));
    $list = tep_get_employees();

    for ($i=0, $n=sizeof($list); $i<$n; $i++) {
      $list_array[] = array('id' => $list[$i]['employees_id'], 
	  'text' =>$list[$i]['employees_full_name']);
    }

    return tep_draw_pull_down_menu($name, $list_array, $selected, $parameters);
  }
  
   function tep_get_rooms_list($name,  $selected = '', $parameters = '') {
    $list_array = array(array('id' => '', 'text' => ''));
	$locations_id=1;
    $list = tep_get_rooms($locations_id);

    for ($i=0, $n=sizeof($list); $i<$n; $i++) {
      $list_array[] = array('id' => $list[$i]['rooms_id'], 
	  'text' =>$list[$i]['rooms_number']);
    }

    return tep_draw_pull_down_menu($name, $list_array, $selected, $parameters);
  }
  
  ///////////////////////////////////////////////////////////////
	//////////////// New Functions 2019 //////////////////////////
	///////////////////////////////////////////////////////////////
  
   function tep_get_summer_class_list($name,$summer_class_level_id, $week, $class_period, $locations_id,$year, $selected = '', $parameters = '') {
  
	$list_array = array(array('id' => '', 'text' => PULL_DOWN_DEFAULT));
    $list = tep_get_summer_classes_admin($summer_class_level_id,$week,$class_period, $locations_id,$year);
	for ($i=0, $n=sizeof($list); $i<$n; $i++) {
		if($summer_class_level_id==8){
			$list_array[] = array('id' => $list[$i]['summer_classes_id'], 'text' => $list[$i]['summer_class_name'].'-'.$list[$i]['summer_class_level']);
		}else
		$list_array[] = array('id' => $list[$i]['summer_classes_id'], 'text' => $list[$i]['summer_class_name']);
    }
	
/*if (sizeof($list)==1) {
	$list_array = array(array('id' => '', 'text' =>  PULL_DOWN_DEFAULT));
		 for ($i=0, $n=sizeof($list); $i<$n; $i++) {
      $list_array[] = array('id' => $list[$i]['summer_classes_id'], 'text' => $list[$i]['summer_class_name']);
    }
}
if (sizeof($list)>1) {
	$list_array = array(array('id' => '', 'text' =>  PULL_DOWN_DEFAULT));
    for ($i=0, $n=sizeof($list); $i<$n; $i++) {
      $list_array[] = array('id' => $list[$i]['summer_classes_id'], 'text' => $list[$i]['summer_class_name']);
    }
}*/
    return tep_draw_pull_down_menu($name, $list_array, $selected, $parameters);
  }
  
   function tep_get_summer_class($week, $summer_class_level_id,$class_period, $locations_id,$year){
	   
	   /* $sql="SELECT summer_classes.summer_classes_id, summer_week_id, summer_week_description, summer_classes.`summer_week` , `summer_class_name` , `summer_class_level` , class_description, class_status, summer_classes.year, summer_classes.locations_id
FROM summer_classes, summer_class_levels, summer_weeks
WHERE summer_classes.YEAR =".$year."
AND class_period = '".$class_period."'
AND summer_weeks.summer_week = summer_classes.`summer_week`
and  summer_weeks.summer_year= summer_classes.`year`
and summer_weeks.locations_id= summer_classes.`locations_id`
AND summer_class_levels.summer_class_level_id = summer_classes.`summer_class_level_id`
AND summer_classes.`summer_week` =".$week."
AND summer_classes.`summer_class_level_id` =".$grade."
and summer_classes.locations_id=".$locations_id."
GROUP BY summer_week_description, summer_classes.`summer_week` , `summer_class_name` , `summer_class_level`
ORDER BY summer_classes.`summer_class_level_id` ";
		 $query= tep_db_query($sql);
	 while ($info = tep_db_fetch_array($query)) {*/
	 
	   $list_array = array(array('id' => '', 'text' => PULL_DOWN_DEFAULT));
    $list = tep_get_summer_classes($summer_class_level_id,$week,$class_period, $locations_id,$year);

	if ($list>0){
	for ($i=0, $n=sizeof($list); $i<$n; $i++) {
     // $list_array[] = array('id' => $list[$i]['summer_classes_id'], 'text' => $list[$i]['summer_class_name']);
   
		$status="<img src='http://ingenius.us/enroll/images/status_green.png' width='10px'/>";
	/*	if ($list[$i]['afternoon']>13 && $info['summer_class_name']!="Rhythmic Gymnastics**")
			$status="<img src='http://ingenius.us/enroll/images/status_yellow.png' width='10px'/>";
		if ($list[$i]['class_status']=='F')
			$status="<img src='http://ingenius.us/enroll/images/status_yellow.png' width='10px'/>";
		if ($list[$i]['afternoon']>=7&&($grade==4||$grade==5))
			$status="<img src='http://ingenius.us/enroll/images/status_yellow.png' width='10px'/>";
        if (($list[$i]['afternoon']>11 && $grade==1))
                 $status="<img src='http://ingenius.us/enroll/images/status_yellow.png' width='10px'/>";
		if ($list[$i]['class_status']=='N')
			$status="<img src='http://ingenius.us/enroll/images/status_red.png' width='10px'/>";
		*/
		echo "<div  >";
		//echo $status." <font color='#006CB7'> ";
		echo  $list[$i]['summer_class_name']."</font></div>";
	//echo "<br>";
	 }
	}
	else{
		echo "No result found";
		
	}
  }
 
  
  function tep_get_class_description($week, $grade,$class_period,$year,$locations_id){
	  
	  //get all classes description with enrollment count
	/*   $sql="SELECT summer_classes.summer_classes_id, summer_week_id, summer_week_description, summer_classes.`summer_week` , `summer_class_name` , `summer_class_level` , class_description, class_status, summer_classes.year, summer_classes.locations_id, COUNT( `summer_class_name` ) AS morning
FROM summer_classes, summer_class_levels, summer_weeks, summer_enrollments
WHERE summer_classes.YEAR =".$year."
AND class_period = '".$class_period."'
AND summer_weeks.summer_week = summer_classes.`summer_week`
and  summer_weeks.summer_year= summer_classes.`year`
and summer_weeks.locations_id= summer_classes.`locations_id`
AND summer_class_levels.summer_class_level_id = summer_classes.`summer_class_level_id`
AND summer_enrollments.summer_week = summer_classes.summer_week
AND summer_enrollments.`summer_sports_id` = summer_classes.`summer_classes_id`
AND summer_classes.`summer_week` =".$week."
AND summer_classes.`summer_class_level_id` =".$grade."
and summer_classes.locations_id=".$locations_id."
GROUP BY summer_week_description, summer_classes.`summer_week` , `summer_class_name` , `summer_class_level`
ORDER BY summer_classes.`summer_class_level_id` ";
*/
	  
	    //get all classes description without enrollment count
	   $sql="SELECT summer_classes.summer_classes_id, summer_week_id, summer_week_description, summer_classes.`summer_week` , `summer_class_name` , 
	  `summer_class_level` , class_description, class_status, summer_classes.year, summer_classes.locations_id
FROM summer_classes, summer_class_levels, summer_weeks
WHERE summer_classes.YEAR =".$year."
AND class_period = '".$class_period."'
AND summer_weeks.summer_week = summer_classes.`summer_week`
and  summer_weeks.summer_year= summer_classes.`year`
and summer_weeks.locations_id= summer_classes.`locations_id`
AND summer_class_levels.summer_class_level_id = summer_classes.`summer_class_level_id`
AND summer_classes.`summer_week` =".$week."
AND summer_classes.`summer_class_level_id` =".$grade."
and summer_classes.locations_id=".$locations_id."
GROUP BY summer_week_description, summer_classes.`summer_week` , `summer_class_name` , `summer_class_level`
ORDER BY summer_classes.`summer_class_level_id` ";
	  $query=tep_db_query($sql);
	 while ($info = tep_db_fetch_array($query)) {
		 
		 $stucount=tep_count_class_enrollment($info['summer_classes_id'],$class_period,$year);
		$status="<img src='http://ingenius.us/enroll/images/status_green.png' width='10px'/>";
		if ($info['class_status']=='N'||$info['class_status']=='F'){
			$status="<img src='http://ingenius.us/enroll/images/status_red.png' width='10px'/>";
		}
		else{
		if ($stucount>13)
			$status="<img src='http://ingenius.us/enroll/images/status_yellow.png' width='10px'/>";	
		if ($stucount>=7&&($grade==4||$grade==5))
			$status="<img src='http://ingenius.us/enroll/images/status_yellow.png' width='10px'/>";
		if (($stucount>=11 && $grade==1))
            $status="<img src='http://ingenius.us/enroll/images/status_yellow.png' width='10px'/>";
		}
		echo "<div >";
		echo $status."<font color='#006CB7'><b> ";
		echo $info['summer_class_name']."</b></font></div>";
	echo "<div >"
		.$info['class_description']."</div><br>";
	 }
 }

   // Output a form checkbox field
  function tep_draw_checkbox_field_title_readonly($name, $value = '', $checked = false,$title='', $parameters = '') {
    return tep_draw_selection_field_title_readonly($name, 'checkbox', $value, $checked,$title, $parameters);
  }////
   function tep_draw_selection_field_title_readonly($name, $type, $value = '', $checked = false, $title='',$parameters = '') {
    global $HTTP_GET_VARS, $HTTP_POST_VARS;

    $selection = '<input type="' . tep_output_string($type) . '" name="' . tep_output_string($name) . '" title="' . tep_output_string($title) . '"';

    if (tep_not_null($value)) $selection .= ' value="' . tep_output_string($value) . '"';

    if ( ($checked == true) || (isset($HTTP_GET_VARS[$name]) && is_string($HTTP_GET_VARS[$name]) && (($HTTP_GET_VARS[$name] == 'on') || (stripslashes($HTTP_GET_VARS[$name]) == $value))) || (isset($HTTP_POST_VARS[$name]) && is_string($HTTP_POST_VARS[$name]) && (($HTTP_POST_VARS[$name] == 'on') || (stripslashes($HTTP_POST_VARS[$name]) == $value))) ) {
      $selection .= ' checked="checked"';
    }
 $selection .= ' disabled="disabled"';
    if (tep_not_null($parameters)) $selection .= ' ' . $parameters;

    $selection .= ' />';

    return $selection;
  } 

 function tep_get_week_list($name, $selected = '', $parameters = '') {
		$locations_id=1;$current_year=date('Y');
     $list_array = array(array('id' => '', 'text' => PULL_DOWN_DEFAULT));
    $list = tep_get_summer_week ($locations_id,$current_year);
	for ($i=0, $n=sizeof($list); $i<$n; $i++) {
      $list_array[] = array(
	  'id' => $list[$i]['summer_week'], 
	  'text' => $list[$i]['summer_week_description']);
    }
	
    //return tep_draw_pull_down_menu($name, $list_array, $selected, $parameters);
 return tep_draw_pull_down_menu_class($name, $list_array, 'thechoices',"onchange=ajaxFunction(this.value);" ,$selected, $parameters);

  }
 
   function tep_get_locations_list($name, $selected = '', $parameters = '') {
	
     $list_array = array(array('id' => '', 'text' => PULL_DOWN_DEFAULT));
    $list = tep_get_locations();
	for ($i=0, $n=sizeof($list); $i<$n; $i++) {
      $list_array[] = array(
	  'id' => $list[$i]['locations_id'], 
	  'text' => $list[$i]['locations_name']);
    }	
    return tep_draw_pull_down_menu($name, $list_array, $selected, $parameters);
	// return tep_draw_pull_down_menu_class($name, $list_array, 'thechoices',"onchange=ajaxFunction(this.value);" ,$selected, $parameters);
  }
   function tep_get_locations_checkbox($name,  $selected = '', $parameters = '') {
    $list = tep_get_locations( );
	
	if(sizeof($list)==1)
	 echo $list[0]['locations_name'];
	if(sizeof($list)>1){
    for ($i=0, $n=sizeof($list); $i<$n; $i++) {
		if($list[$i]['locations_id']==$selected)
		$checked =true;
		else
		$checked=false;
		echo tep_draw_radio_field($name, $list[$i]['locations_id'], $checked); echo $list[$i]['locations_name']."<br />";
    }

	}
	
  }
  
  
  
///////////////////////////// update or new 2020 ////////////////////////////
function tep_get_summer_class_levels_list_2020($name, $selected = '', $parameters = '') {
    $list_array= array(array('id' => '', 'text' => PULL_DOWN_DEFAULT));
	//$list_array[]= array(array('id' => '99', 'text' => 'All'));
    $list = tep_get_summer_class_levels_2020();

    for ($i=0, $n=sizeof($list); $i<$n; $i++) {
      $list_array[] = array('id' => $list[$i]['summer_class_level_id'], 'text' => $list[$i]['summer_class_level']);
    }

    return tep_draw_pull_down_menu_class($name, $list_array, 'thechoices',"onchange=ajaxFunction(this.value);" ,$selected, $parameters);
  }
   
   
  //////////new in 2023///
    function tep_get_summer_class_list_2023($name,$summer_class_levels_id,$grade, $week, $class_period, $locations_id,$year,$class_status='', $selected = '', $parameters = '') {
   //  $list_array = array(array('id' => '', 'text' => PULL_DOWN_DEFAULT));
   $list_array = array(array('id' => '', 'text' => ''));
  if($class_period=="Aftercamp"){
	  $class_period="Aftercamp1";
  }
		$list = tep_get_summer_classes_2023($summer_class_levels_id,$grade,$week,$class_period, $locations_id,$year,$class_status);
	
	if($class_period=="Aftercamp1"){	
		if(sizeof($list)){			
		$list_array[] = array('id' => 1, 'text' => 'Attend Aftercamp');		
		}
	}
	else{
	for ($i=0, $n=sizeof($list); $i<$n; $i++) {
		if ($list[$i]['class_status']=='N')
			 $status=" (Full)";
     // $list_array[] = array('id' => $list[$i]['summer_classes_id'], 'text' => $list[$i]['courses_name']);
	 $list_array[] = array('id' => $list[$i]['summer_classes_id'], 'text' => $list[$i]['summer_class_name'].$status);
		}
	}
    return tep_draw_pull_down_menu($name, $list_array, $selected, $parameters);
  }
  
     function tep_draw_checkbox_field_title_readonly1($name, $value = '', $checked = false,$title='', $parameters = '') {
    return tep_draw_selection_field_title_readonly1($name, 'checkbox', $value, $checked,$title, $parameters);
  }
    function tep_draw_selection_field_title_readonly1($name, $type, $value = '', $checked = false, $title='',$parameters = '') {
    global $HTTP_GET_VARS, $HTTP_POST_VARS;

    $selection = '<input type="' . tep_output_string($type) . '" name="' . tep_output_string($name) . '" title="' . tep_output_string($title) . '"';

    if (tep_not_null($value)) $selection .= ' value="' . tep_output_string($value) . '"';

    if ( ($checked == true) || (isset($HTTP_GET_VARS[$name]) && is_string($HTTP_GET_VARS[$name]) && (($HTTP_GET_VARS[$name] == 'on') || (stripslashes($HTTP_GET_VARS[$name]) == $value))) || (isset($HTTP_POST_VARS[$name]) && is_string($HTTP_POST_VARS[$name]) && (($HTTP_POST_VARS[$name] == 'on') || (stripslashes($HTTP_POST_VARS[$name]) == $value))) ) {
      $selection .= ' checked="checked"';
    }
// $selection .= ' disabled="disabled"';
$selection.= ' onclick="event.preventDefault();"';
   if (tep_not_null($parameters)) $selection .= ' ' . $parameters;

    $selection .= ' />';

    return $selection;
  }
  
  function tep_get_message_types_checkbox($name,  $selected = '', $parameters = '') {
	    $list_array = array(array('id' => '', 'text' => ''));
		$list=array("Message to Admin","Teacher Reqest for Sub","Staff Request Day Off","Website Help");
    for ($i=1;$i<=sizeof($list); $i++) {	
		$n=$i-1;
      $list_array[] = array('id' =>$list[$n], 'text' =>$list[$n]);
	  
    }

return tep_draw_pull_down_menu($name, $list_array, $selected, $parameters);
	
  }
  
    function tep_get_locations_checkbox_horizontal($name,  $selected = '', $parameters = '') {
    $list = tep_get_locations( );
	
	if(sizeof($list)==1)
	 echo $list[0]['locations_name'];
	if(sizeof($list)>1){
    for ($i=0, $n=sizeof($list); $i<$n; $i++) {
		if($list[$i]['locations_id']==$selected)
		$checked =true;
		else
		$checked=false;
		echo tep_draw_radio_field($name, $list[$i]['locations_id'], $checked); echo $list[$i]['locations_name'];
    }

	}
	
  }
?>